/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.pollers;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.pollers.CancelException;
import com.vmware.vise.vim.messaging.pollers.PollTask;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Poller
implements Runnable {
    private static final Log _logger = LogFactory.getLog(Poller.class);
    private static final long HUNDRED_SECONDS_IN_NANOS = TimeUnit.SECONDS.toNanos(100L);
    private static final long TEN_SECONDS_IN_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final PollTask _inputPollTask;
    private final ThreadPoolExecutor _liveUpdatesThreadPoolExecutor;
    private final ScheduledExecutorService _pollingThreadPool;
    private final ThreadPoolExecutor _handlerExecutor;
    private final long _delay;
    private final HttpServletRequest _request;
    private final TimeUnit _timeUnitForDelay;
    private volatile MessageSender _handler;
    private volatile PeriodicTask _modifiedPeriodicTask;
    private volatile ScheduledFuture<?> _future;
    private int _consequentReschedules = 0;

    public Poller(PollTask pollTask, HttpServletRequest httpServletRequest, ThreadPoolExecutor threadPoolExecutor, ScheduledExecutorService scheduledExecutorService, ThreadPoolExecutor threadPoolExecutor2, long l, TimeUnit timeUnit) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{pollTask, httpServletRequest, threadPoolExecutor, scheduledExecutorService, threadPoolExecutor2, timeUnit});
        this._inputPollTask = pollTask;
        this._request = httpServletRequest;
        this._liveUpdatesThreadPoolExecutor = threadPoolExecutor;
        this._pollingThreadPool = scheduledExecutorService;
        this._handlerExecutor = threadPoolExecutor2;
        this._delay = l;
        this._timeUnitForDelay = timeUnit;
    }

    public void setHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._handler = messageSender;
    }

    public void start() {
        this._modifiedPeriodicTask = new PeriodicTask();
        this.schedule();
    }

    @Override
    public synchronized void run() {
        if (this._modifiedPeriodicTask == null) {
            return;
        }
        BlockingQueue<Runnable> blockingQueue = this._liveUpdatesThreadPoolExecutor.getQueue();
        if (blockingQueue.remainingCapacity() == 0) {
            ++this._consequentReschedules;
            if (this._consequentReschedules >= 30) {
                _logger.error((Object)"\"liveUpdatesExecutorThreadPool\" queue was full for more than 300 seconds. The task won't be rescheduled.");
                return;
            }
            _logger.warn((Object)"\"liveUpdatesExecutorThreadPool\" queue is full. Reschedule the task with 10 seconds delay.");
            this._future = this._pollingThreadPool.schedule(this, 10L, TimeUnit.SECONDS);
            return;
        }
        this._consequentReschedules = 0;
        this._modifiedPeriodicTask.executionSubmitTime = System.nanoTime();
        try {
            this._liveUpdatesThreadPoolExecutor.execute(this._modifiedPeriodicTask);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _logger.error((Object)"Task was rejected for execution:", (Throwable)rejectedExecutionException);
        }
    }

    private void schedule() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this._future = this._pollingThreadPool.schedule(this, this._delay, this._timeUnitForDelay);
    }

    public void stop() {
        if (this._future != null) {
            this._future.cancel(true);
        }
        this._modifiedPeriodicTask = null;
        this._handler = null;
    }

    private class PeriodicTask
    implements Runnable {
        private long executionSubmitTime;
        private long executionStartTime;
        private long handleSubmitTime;
        private long handleStartTime;
        private long handleDoneTime;

        private PeriodicTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (Poller.this._handler == null) {
                Poller.this.schedule();
                return;
            }
            this.executionStartTime = System.nanoTime();
            long l = this.executionStartTime - this.executionSubmitTime;
            if (l > HUNDRED_SECONDS_IN_NANOS) {
                _logger.warn((Object)("A task waited more than 100 seconds to be executed in \"liveUpdatesExecutorThreadPool\".\n   Wait time: " + TimeUnit.NANOSECONDS.toSeconds(l) + " seconds.\n   QueueSize: " + Poller.this._liveUpdatesThreadPoolExecutor.getQueue().size()));
            } else if (l > TEN_SECONDS_IN_NANOS) {
                _logger.warn((Object)("A task waited more than 10 seconds to be executed in \"liveUpdatesExecutorThreadPool\".\n   Wait time: " + TimeUnit.NANOSECONDS.toSeconds(l) + " seconds.\n   QueueSize: " + Poller.this._liveUpdatesThreadPoolExecutor.getQueue().size()));
            }
            List<PartialUpdate<?>> list = null;
            try {
                object = Poller.this;
                synchronized (object) {
                    list = Poller.this._inputPollTask.call();
                }
            }
            catch (CancelException cancelException) {
                _logger.info((Object)"Polling canceled.");
                return;
            }
            catch (Exception exception) {
                _logger.error((Object)"Error calling the poll task:", (Throwable)exception);
            }
            if (list == null || list.isEmpty()) {
                Poller.this.schedule();
                return;
            }
            object = list;
            this.handleSubmitTime = System.nanoTime();
            long l2 = this.handleSubmitTime - this.executionStartTime;
            if (l2 > HUNDRED_SECONDS_IN_NANOS) {
                _logger.warn((Object)("A task execution took more than 100 seconds in \"liveUpdatesExecutorThreadPool\".\n   Execution time: " + TimeUnit.NANOSECONDS.toSeconds(l2) + " seconds.\n   QueueSize: " + Poller.this._liveUpdatesThreadPoolExecutor.getQueue().size()));
            } else if (l2 > TEN_SECONDS_IN_NANOS) {
                _logger.warn((Object)("A task execution took more than 10 seconds in \"liveUpdatesExecutorThreadPool\".\n   Execution time: " + TimeUnit.NANOSECONDS.toSeconds(l2) + " seconds.\n   QueueSize: " + Poller.this._liveUpdatesThreadPoolExecutor.getQueue().size()));
            }
            this.checkRunningTasks();
            Poller.this._handlerExecutor.execute(new Runnable((List)object){
                final /* synthetic */ List val$taskResult;
                {
                    this.val$taskResult = list;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PeriodicTask.this.handleStartTime = System.nanoTime();
                    long l = PeriodicTask.this.handleStartTime - PeriodicTask.this.handleSubmitTime;
                    if (l > HUNDRED_SECONDS_IN_NANOS) {
                        _logger.warn((Object)("A task waited more than 100 seconds to be executed in \"websocketSenderThreadPool\".\n   Wait time: " + TimeUnit.NANOSECONDS.toSeconds(l) + " seconds.\n   Pool size: " + Poller.this._handlerExecutor.getPoolSize() + ". Active count: " + Poller.this._handlerExecutor.getActiveCount()));
                    } else if (l > TEN_SECONDS_IN_NANOS) {
                        _logger.warn((Object)("A task waited more than 10 seconds to be executed in \"websocketSenderThreadPool\".\n   Wait time: " + TimeUnit.NANOSECONDS.toSeconds(l) + " seconds.\n   Pool size: " + Poller.this._handlerExecutor.getPoolSize() + ". Active count: " + Poller.this._handlerExecutor.getActiveCount()));
                    }
                    if (Poller.this._handler == null) {
                        Poller.this.schedule();
                        return;
                    }
                    SessionUtil.setHttpRequest((HttpServletRequest)Poller.this._request);
                    try {
                        Poller poller = Poller.this;
                        synchronized (poller) {
                            for (PartialUpdate partialUpdate : this.val$taskResult) {
                                Poller.this._handler.send((Object)partialUpdate);
                            }
                        }
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"Error handling the updates:", (Throwable)exception);
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                        Poller.this.schedule();
                    }
                    PeriodicTask.this.handleDoneTime = System.nanoTime();
                    long l2 = PeriodicTask.this.handleDoneTime - PeriodicTask.this.handleStartTime;
                    if (l2 > HUNDRED_SECONDS_IN_NANOS) {
                        _logger.warn((Object)("A task was executed for more than 100 seconds. Execution time: " + TimeUnit.NANOSECONDS.toSeconds(l2) + " seconds.\n   Pool size: " + Poller.this._handlerExecutor.getPoolSize() + ". Active count: " + Poller.this._handlerExecutor.getActiveCount()));
                    } else if (l > TEN_SECONDS_IN_NANOS) {
                        _logger.warn((Object)("A task was executed for more than 10 seconds. Execution time: " + TimeUnit.NANOSECONDS.toSeconds(l2) + " seconds.\n   Pool size: " + Poller.this._handlerExecutor.getPoolSize() + ". Active count: " + Poller.this._handlerExecutor.getActiveCount()));
                    }
                }
            });
        }

        private void checkRunningTasks() {
            int n = Poller.this._handlerExecutor.getActiveCount();
            int n2 = Poller.this._handlerExecutor.getMaximumPoolSize();
            int n3 = Poller.this._handlerExecutor.getCorePoolSize();
            if (n == n3) {
                _logger.info((Object)("websocketSenderThreadPool state: " + Poller.this._handlerExecutor.toString()));
            } else if ((double)n == 0.1 * (double)n2) {
                _logger.info((Object)("websocketSenderThreadPool reached 10% of its capacity: " + Poller.this._handlerExecutor.toString()));
            } else if ((double)n == 0.5 * (double)n2) {
                _logger.warn((Object)("websocketSenderThreadPool reached 50% of its capacity: " + Poller.this._handlerExecutor.toString()));
            } else if ((double)n == 0.8 * (double)n2) {
                _logger.warn((Object)("websocketSenderThreadPool reached 80% of its capacity. LargestPoolSize: " + Poller.this._handlerExecutor.getLargestPoolSize() + " threadpool state: " + Poller.this._handlerExecutor.toString()));
            } else if ((double)n == 0.9 * (double)n2) {
                _logger.warn((Object)("websocketSenderThreadPool reached 90% of its capacity. LargestPoolSize: " + Poller.this._handlerExecutor.getLargestPoolSize() + " threadpool state: " + Poller.this._handlerExecutor.toString()));
            } else if ((double)n == 0.99 * (double)n2) {
                _logger.warn((Object)("websocketSenderThreadPool reached 99% of its capacity. LargestPoolSize: " + Poller.this._handlerExecutor.getLargestPoolSize() + " threadpool state:" + Poller.this._handlerExecutor.toString()));
            } else if (n == n2) {
                _logger.warn((Object)("websocketSenderThreadPool reached 100% of its capacity. Threadpool state:" + Poller.this._handlerExecutor.toString()));
            }
        }
    }
}

