/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;

class UpdatesUtil {
    public static final String OPERATION_STARTED = "operationStarted";
    public static final String INVENTORY_SERVICE_TAG_TYPE = "InventoryServiceTag";
    public static final String INVENTORY_SERVICE_CATEGORY_TYPE = "InventoryServiceCategory";

    UpdatesUtil() {
    }

    static RequestSpec getQuerySpecForRecentTasks() {
        QuerySpec querySpec = UpdatesUtil.createRecentTasksSpec();
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[1];
        requestSpec.querySpec[0] = querySpec;
        return requestSpec;
    }

    public static boolean is60VcOperation(OperationResultEx operationResultEx) {
        Object object = operationResultEx.operationResult.task;
        if (object != null && object instanceof ManagedObjectReference) {
            return !VcServiceUtil.is65VcOrLaterByServerGuid((String)((ManagedObjectReference)object).getServerGuid());
        }
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo != null && clientTaskInfo.taskRef != null && clientTaskInfo.taskRef instanceof ManagedObjectReference) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)clientTaskInfo.taskRef;
            return !VcServiceUtil.is65VcOrLaterByServerGuid((String)managedObjectReference.getServerGuid());
        }
        if (operationResultEx.operationResult != null) {
            ManagedObjectReference managedObjectReference = null;
            if (operationResultEx.operationResult.entity != null && operationResultEx.operationResult.entity instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)operationResultEx.operationResult.entity;
            } else if (operationResultEx.operationResult.result != null && operationResultEx.operationResult.result instanceof ManagedObjectReference) {
                managedObjectReference = (ManagedObjectReference)operationResultEx.operationResult.result;
            }
            boolean bl = false;
            if (ManagedObjectUtil.isOfType(managedObjectReference, (String)INVENTORY_SERVICE_TAG_TYPE) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, (String)INVENTORY_SERVICE_CATEGORY_TYPE)) {
                bl = true;
            }
            if (managedObjectReference != null) {
                return !VcServiceUtil.is65VcOrLaterByServerGuid((String)managedObjectReference.getServerGuid(), (boolean)bl);
            }
        }
        return false;
    }

    private static QuerySpec createRecentTasksSpec() {
        Constraint constraint;
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resourceSpec.constraint = constraint = UpdatesUtil.createRecentTaskSearchConstraint();
        propertySpec.propertyNames = new String[1];
        propertySpec.propertyNames[0] = "info";
        resourceSpec.propertySpecs = new PropertySpec[1];
        resourceSpec.propertySpecs[0] = propertySpec;
        querySpec.name = "vsphere:Task-info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    private static Constraint createRecentTaskSearchConstraint() {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = "info.recentTasks";
        propertyConstraint.comparableValue = true;
        propertyConstraint.targetType = "vsphere:Task";
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }
}

