/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.update.impl;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.storageDrs.ApplyRecommendationResult;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.ObjectChangeInfo;
import com.vmware.vise.core.model.OperationType;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.messaging.update.VcOperations;
import com.vmware.vise.vim.messaging.update.impl.OperationResultEx;
import com.vmware.vise.vim.messaging.websocket.MessagingService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Vc60Operations
implements VcOperations {
    private static final Log _logger = LogFactory.getLog(Vc60Operations.class);
    private static final String HOST_DISCONNECT = "HostSystem.disconnect";
    private static final String HOST_RECONNECT = "HostSystem.reconnect";
    private static final List<String> RELATIONSHIP_CHANGE_IDS = Arrays.asList(".migrate", ".move", ".turnOffFaultTolerance", ".relocate", "StorageResourceManager.applyRecommendation");
    private static final List<String> OBJECT_ADDED_IDS = Arrays.asList("VirtualMachine.clone", "VirtualApp.clone", ".importVm", ".registerVm", ".new", ".add", ".create");
    private static final List<String> CHILDREN_UPDATE_IDS = Arrays.asList("HostSystem.disconnect", "HostSystem.reconnect");
    private static final int RETRIES = 5;
    private static int _sleepDurationMs = 1000;
    private final ListeningExecutorService _listeningExecutor;
    private final MessagingService _messagingService;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;

    public Vc60Operations(MessagingService messagingService, QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService, ListeningExecutorService listeningExecutorService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messagingService, queryServiceFactory, objectReferenceService, listeningExecutorService});
        this._queryService = queryServiceFactory.getQueryService();
        this._listeningExecutor = listeningExecutorService;
        this._messagingService = messagingService;
        this._objRefService = objectReferenceService;
    }

    public Vc60Operations(MessagingService messagingService, QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService, ListeningExecutorService listeningExecutorService, int n) {
        this(messagingService, queryServiceFactory, objectReferenceService, listeningExecutorService);
        _sleepDurationMs = n;
    }

    @Override
    public Optional<ListenableFuture<ObjectChangeInfo>> handleOperationResult(HttpSession httpSession, OperationResultEx operationResultEx) {
        if (operationResultEx == null || operationResultEx.taskInfo == null) {
            return Optional.absent();
        }
        ClientTaskInfo clientTaskInfo = operationResultEx.taskInfo;
        if (clientTaskInfo.state != TaskState.SUCCESS) {
            return Optional.absent();
        }
        ManagedObjectReference managedObjectReference = null;
        if (clientTaskInfo.result instanceof ApplyRecommendationResult) {
            managedObjectReference = ((ApplyRecommendationResult)clientTaskInfo.result).vm;
        } else if (clientTaskInfo.result instanceof ManagedObjectReference) {
            managedObjectReference = (ManagedObjectReference)clientTaskInfo.result;
        }
        if (managedObjectReference == null) {
            return Optional.absent();
        }
        if (this.contains(RELATIONSHIP_CHANGE_IDS, clientTaskInfo.taskTypeId)) {
            ListenableFuture<ObjectChangeInfo> listenableFuture = this.submitTask(httpSession, this.createChange(managedObjectReference, OperationType.RELATIONSHIP_CHANGE));
            return Optional.of(listenableFuture);
        }
        if (this.contains(CHILDREN_UPDATE_IDS, clientTaskInfo.taskTypeId)) {
            ListenableFuture<ObjectChangeInfo> listenableFuture = HOST_RECONNECT.equals(clientTaskInfo.taskTypeId) || HOST_DISCONNECT.equals(clientTaskInfo.taskTypeId) ? this.submitTask(httpSession, this.createHostTask(httpSession, managedObjectReference, clientTaskInfo.taskTypeId, OperationType.CHILDREN_UPDATE)) : this.submitTask(httpSession, this.createChange(managedObjectReference, OperationType.CHILDREN_UPDATE));
            return Optional.of(listenableFuture);
        }
        if (this.contains(OBJECT_ADDED_IDS, clientTaskInfo.taskTypeId)) {
            if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class)) {
                return Optional.of(this.submitTask(httpSession, this.createAddHost(httpSession, managedObjectReference)));
            }
            return Optional.of(this.submitTask(httpSession, this.createChangeEntity(httpSession, managedObjectReference)));
        }
        return Optional.absent();
    }

    private Callable<ObjectChangeInfo> createHostTask(HttpSession httpSession, final ManagedObjectReference managedObjectReference, final String string, final OperationType operationType) {
        Operation operation = new Operation(){

            @Override
            public ObjectChangeInfo apply() {
                ResultSet resultSet = Vc60Operations.this._queryService.select(new String[]{"runtime.connectionState"}).from(new String[]{"HostSystem"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).fetch();
                HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)((ResourceItem)resultSet.getItems().get(0)).get("runtime.connectionState");
                if (string.equals(Vc60Operations.HOST_DISCONNECT) && connectionState == HostSystem.ConnectionState.disconnected) {
                    return Vc60Operations.this.createObjectChangeInfo(managedObjectReference, operationType);
                }
                if (string.equals(Vc60Operations.HOST_RECONNECT) && connectionState == HostSystem.ConnectionState.connected) {
                    return Vc60Operations.this.createObjectChangeInfo(managedObjectReference, operationType);
                }
                return null;
            }
        };
        return this.wrapOperation(httpSession, operation, managedObjectReference, Operation.SleepKind.FAST);
    }

    private Callable<ObjectChangeInfo> createChange(final ManagedObjectReference managedObjectReference, final OperationType operationType) {
        return new Callable<ObjectChangeInfo>(){

            @Override
            public ObjectChangeInfo call() throws Exception {
                Thread.sleep(_sleepDurationMs * 2);
                return Vc60Operations.this.createObjectChangeInfo(managedObjectReference, operationType);
            }
        };
    }

    private Callable<ObjectChangeInfo> createChangeEntity(HttpSession httpSession, final ManagedObjectReference managedObjectReference) {
        Operation operation = new Operation(){

            @Override
            public ObjectChangeInfo apply() {
                ResultSet resultSet = Vc60Operations.this._queryService.select(new String[]{"@modelKey"}).from(new String[]{Vc60Operations.this._objRefService.getResourceObjectType((Object)managedObjectReference)}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).withTotalCount().fetch();
                if (resultSet.getTotalCount() > 0) {
                    return Vc60Operations.this.createObjectChangeInfo(managedObjectReference, OperationType.ADD);
                }
                return null;
            }
        };
        return this.wrapOperation(httpSession, operation, managedObjectReference, Operation.SleepKind.SLOW);
    }

    private Callable<ObjectChangeInfo> createAddHost(HttpSession httpSession, final ManagedObjectReference managedObjectReference) {
        Operation operation = new Operation(){

            @Override
            public ObjectChangeInfo apply() {
                ResultSet resultSet = Vc60Operations.this._queryService.select(new String[]{"host"}).from(new String[]{"ComputeResource"}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).fetch();
                Object[] objectArray = (ManagedObjectReference[])((ResourceItem)resultSet.getItems().get(0)).get("host");
                if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                    return null;
                }
                return Vc60Operations.this.createObjectChangeInfo((ManagedObjectReference)objectArray[0], OperationType.ADD);
            }
        };
        return this.wrapOperation(httpSession, operation, managedObjectReference, Operation.SleepKind.SLOW);
    }

    private ObjectChangeInfo createObjectChangeInfo(ManagedObjectReference managedObjectReference, OperationType operationType) {
        ObjectChangeInfo objectChangeInfo = new ObjectChangeInfo();
        objectChangeInfo.object = managedObjectReference;
        objectChangeInfo.objectId = this._objRefService.getUid((Object)managedObjectReference, true);
        objectChangeInfo.operationType = operationType;
        return objectChangeInfo;
    }

    private ListenableFuture<ObjectChangeInfo> submitTask(final HttpSession httpSession, Callable<ObjectChangeInfo> callable) {
        ListenableFuture listenableFuture = this._listeningExecutor.submit(callable);
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<ObjectChangeInfo>(){

            public void onSuccess(ObjectChangeInfo objectChangeInfo) {
                if (objectChangeInfo == null) {
                    return;
                }
                try {
                    SessionUtil.setHttpSession((HttpSession)httpSession);
                    Vc60Operations.this._messagingService.sendMessage(objectChangeInfo);
                }
                finally {
                    SessionUtil.setHttpSession(null);
                }
            }

            public void onFailure(Throwable throwable) {
                _logger.error((Object)"Failed to execute a future: ", throwable);
            }
        });
        return listenableFuture;
    }

    private boolean contains(List<String> list, String string) {
        for (String string2 : list) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private Callable<ObjectChangeInfo> wrapOperation(final HttpSession httpSession, final Operation operation, final ManagedObjectReference managedObjectReference, final Operation.SleepKind sleepKind) {
        return new Callable<ObjectChangeInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ObjectChangeInfo call() throws Exception {
                for (int i = 5; i > 0; --i) {
                    if (sleepKind == Operation.SleepKind.SLOW) {
                        Thread.sleep(sleepKind.getDuration());
                    }
                    try {
                        SessionUtil.setHttpSession((HttpSession)httpSession);
                        ObjectChangeInfo objectChangeInfo = operation.apply();
                        if (objectChangeInfo == null) continue;
                        ObjectChangeInfo objectChangeInfo2 = objectChangeInfo;
                        return objectChangeInfo2;
                    }
                    finally {
                        SessionUtil.setHttpSession(null);
                    }
                }
                throw new Exception("property was not there after 5 tries for: " + managedObjectReference);
            }
        };
    }

    private static abstract class Operation {
        private Operation() {
        }

        public abstract ObjectChangeInfo apply();

        public static enum SleepKind {
            FAST(Vc60Operations.access$300()),
            SLOW(Vc60Operations.access$300() * 2);

            private int _durationMs;

            private SleepKind(int n2) {
                this._durationMs = n2;
            }

            public int getDuration() {
                return this._durationMs;
            }
        }
    }
}

