/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.messaging.updates;

import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.messaging.MutationOperationUpdatePublisher;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.messaging.websocket.MessageSender;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MutationOperationUpdatesHandler
implements MutationOperationUpdatePublisher {
    private static final Log _logger = LogFactory.getLog(MutationOperationUpdatesHandler.class);
    private final Map<MessageSender, Boolean> _updateHandlers = new HashMap<MessageSender, Boolean>();

    public synchronized void addHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._updateHandlers.put(messageSender, Boolean.TRUE);
    }

    public synchronized void removeHandler(MessageSender messageSender) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{messageSender});
        this._updateHandlers.remove(messageSender);
    }

    public synchronized void publish(PartialUpdate<?> partialUpdate) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{partialUpdate});
        for (MessageSender messageSender : this._updateHandlers.keySet()) {
            try {
                messageSender.send(partialUpdate);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error handling update:", (Throwable)exception);
            }
        }
    }
}

