/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.FlexContext;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSessionAttributeListener;
import flex.messaging.FlexSessionBindingEvent;
import flex.messaging.FlexSessionBindingListener;
import flex.messaging.FlexSessionListener;
import flex.messaging.LocalizedException;
import flex.messaging.MessageClient;
import flex.messaging.MessageClientListener;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientListener;
import flex.messaging.messages.Message;
import flex.messaging.util.TimeoutAbstractObject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class FlexSession
extends TimeoutAbstractObject
implements FlexClientListener,
MessageClientListener {
    public static final String FLEX_SESSION_LOG_CATEGORY = "Endpoint.FlexSession";
    public static final int MAX_CONNECTIONS_PER_SESSION_UNLIMITED = -1;
    private static final CopyOnWriteArrayList<FlexSessionListener> createdListeners = new CopyOnWriteArrayList();
    private static final int FLEX_SESSION_INVALIDATED = 10019;
    protected boolean invalidating;
    protected final Object lock = new Object();
    protected boolean valid = true;
    private Map<String, Object> attributes;
    private volatile CopyOnWriteArrayList<FlexSessionAttributeListener> attributeListeners;
    private boolean creationNotified;
    private volatile CopyOnWriteArrayList<FlexSessionListener> destroyedListeners;
    private final CopyOnWriteArrayList<FlexClient> flexClients = new CopyOnWriteArrayList();
    private volatile CopyOnWriteArrayList<MessageClient> messageClients;
    private volatile Map remoteCredentials;
    public volatile HashMap<String, FlexClient.AsyncPollWithTimeout> asyncPollMap;
    private final AbstractFlexSessionProvider sessionProvider;
    private Principal userPrincipal;
    public volatile boolean canStream = true;
    public int maxConnectionsPerSession = -1;
    public int streamingConnectionsCount;
    private boolean useSmallMessages;
    public volatile HashMap<String, FlexClient.EndpointQueue> waitMonitor;

    public FlexSession() {
        this(null);
    }

    public FlexSession(AbstractFlexSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public static void addSessionCreatedListener(FlexSessionListener listener) {
        if (listener != null) {
            createdListeners.addIfAbsent(listener);
        }
    }

    public static void removeSessionCreatedListener(FlexSessionListener listener) {
        if (listener != null) {
            createdListeners.remove(listener);
        }
    }

    public AbstractFlexSessionProvider getFlexSessionProvider() {
        return this.sessionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getUserPrincipal() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.userPrincipal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserPrincipal(Principal userPrincipal) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            this.userPrincipal = userPrincipal;
        }
    }

    public boolean useSmallMessages() {
        return this.useSmallMessages;
    }

    public void setUseSmallMessages(boolean value) {
        this.useSmallMessages = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionAttributeListener(FlexSessionAttributeListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.attributeListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.attributeListeners == null) {
                        this.attributeListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.attributeListeners.addIfAbsent(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionDestroyedListener(FlexSessionListener listener) {
        if (listener != null) {
            this.checkValid();
            if (this.destroyedListeners == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.destroyedListeners == null) {
                        this.destroyedListeners = new CopyOnWriteArrayList();
                    }
                }
            }
            this.destroyedListeners.addIfAbsent(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            return this.attributes == null ? null : this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            if (this.attributes == null) {
                return Collections.enumeration(Collections.emptyList());
            }
            return Collections.enumeration(new ArrayList<String>(this.attributes.keySet()));
        }
    }

    @Override
    public void messageClientCreated(MessageClient messageClient) {
    }

    @Override
    public void messageClientDestroyed(MessageClient messageClient) {
        this.unregisterMessageClient(messageClient);
    }

    public abstract boolean isPushSupported();

    public void push(Message message) {
        throw new UnsupportedOperationException("Push not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            value = this.attributes != null ? this.attributes.remove(name) : null;
        }
        if (value == null) {
            return;
        }
        this.notifyAttributeUnbound(name, value);
        this.notifyAttributeRemoved(name, value);
    }

    public void removeSessionAttributeListener(FlexSessionAttributeListener listener) {
        if (listener != null && this.attributeListeners != null) {
            this.attributeListeners.remove(listener);
        }
    }

    public void removeSessionDestroyedListener(FlexSessionListener listener) {
        if (listener != null && this.destroyedListeners != null) {
            this.destroyedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            oldValue = this.attributes.put(name, value);
        }
        if (oldValue == null) {
            this.notifyAttributeBound(name, value);
            this.notifyAttributeAdded(name, value);
        } else {
            this.notifyAttributeUnbound(name, oldValue);
            this.notifyAttributeReplaced(name, oldValue);
            this.notifyAttributeBound(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRemoteCredentials(FlexRemoteCredentials credentials) {
        if (credentials != null) {
            Object object;
            if (this.remoteCredentials == null) {
                object = this.lock;
                synchronized (object) {
                    if (this.remoteCredentials == null) {
                        this.remoteCredentials = new HashMap(4);
                    }
                }
            }
            object = this.remoteCredentials;
            synchronized (object) {
                HashMap<String, FlexRemoteCredentials> serviceMap = (HashMap<String, FlexRemoteCredentials>)this.remoteCredentials.get(credentials.getService());
                if (serviceMap == null) {
                    serviceMap = new HashMap<String, FlexRemoteCredentials>(7);
                    this.remoteCredentials.put(credentials.getService(), serviceMap);
                }
                serviceMap.put(credentials.getDestination(), credentials);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexRemoteCredentials getRemoteCredentials(String serviceId, String destinationId) {
        if (serviceId != null && destinationId != null) {
            if (this.remoteCredentials == null) {
                return null;
            }
            Map map = this.remoteCredentials;
            synchronized (map) {
                Map serviceMap = (Map)this.remoteCredentials.get(serviceId);
                return serviceMap != null ? (FlexRemoteCredentials)serviceMap.get(destinationId) : null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemoteCredentials(String serviceId, String destinationId) {
        if (serviceId != null && destinationId != null) {
            if (this.remoteCredentials == null) {
                return;
            }
            Map map = this.remoteCredentials;
            synchronized (map) {
                Map serviceMap = (Map)this.remoteCredentials.get(serviceId);
                if (serviceMap != null) {
                    serviceMap.put(destinationId, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Iterator<FlexClient.EndpointQueue> iterator = this.lock;
        synchronized (iterator) {
            if (!this.valid || this.invalidating) {
                return;
            }
            this.invalidating = true;
            this.cancelTimeout();
            if (this.sessionProvider != null) {
                this.sessionProvider.removeFlexSession(this);
            }
        }
        if (!this.flexClients.isEmpty()) {
            for (FlexClient flexClient : this.flexClients) {
                this.unregisterFlexClient(flexClient);
            }
        }
        if (this.messageClients != null && !this.messageClients.isEmpty()) {
            for (MessageClient messageClient : this.messageClients) {
                messageClient.removeMessageClientDestroyedListener(this);
                messageClient.invalidate();
            }
            this.messageClients.clear();
        }
        if (this.destroyedListeners != null && !this.destroyedListeners.isEmpty()) {
            for (FlexSessionListener destroyListener : this.destroyedListeners) {
                destroyListener.sessionDestroyed(this);
            }
            this.destroyedListeners.clear();
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            String[] keys;
            Set<String> keySet = this.attributes.keySet();
            for (String key : keys = keySet.toArray(new String[keySet.size()])) {
                this.removeAttribute(key);
            }
            this.attributes = null;
        }
        this.internalInvalidate();
        iterator = this.lock;
        synchronized (iterator) {
            this.valid = false;
            this.invalidating = false;
        }
        if (this.waitMonitor != null) {
            iterator = this.waitMonitor.values().iterator();
            while (iterator.hasNext()) {
                FlexClient.EndpointQueue endpointQueue;
                FlexClient.EndpointQueue endpointQueue2 = endpointQueue = iterator.next();
                synchronized (endpointQueue2) {
                    endpointQueue.notifyAll();
                }
            }
        }
    }

    protected void internalInvalidate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlexClient> getFlexClients() {
        ArrayList<FlexClient> currentFlexClients = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            currentFlexClients = new ArrayList<FlexClient>(this.flexClients);
        }
        return currentFlexClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageClient> getMessageClients() {
        ArrayList<MessageClient> currentMessageClients = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkValid();
            currentMessageClients = this.messageClients != null ? new ArrayList<MessageClient>(this.messageClients) : new ArrayList();
        }
        return currentMessageClients;
    }

    public abstract String getId();

    public boolean isUserInRole(String role) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(role);
        return FlexContext.getMessageBroker().getLoginManager().checkRoles(this.userPrincipal, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    @Override
    public void clientCreated(FlexClient flexClient) {
    }

    @Override
    public void clientDestroyed(FlexClient flexClient) {
        this.unregisterFlexClient(flexClient);
    }

    public void registerFlexClient(FlexClient flexClient) {
        if (this.flexClients.addIfAbsent(flexClient)) {
            flexClient.addClientDestroyedListener(this);
            flexClient.registerFlexSession(this);
        }
    }

    public void unregisterFlexClient(FlexClient flexClient) {
        if (this.flexClients.remove(flexClient)) {
            flexClient.removeClientDestroyedListener(this);
            flexClient.unregisterFlexSession(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageClient(MessageClient messageClient) {
        if (this.messageClients == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageClients == null) {
                    this.messageClients = new CopyOnWriteArrayList();
                }
            }
        }
        if (this.messageClients.addIfAbsent(messageClient)) {
            messageClient.addMessageClientDestroyedListener(this);
        }
    }

    public void unregisterMessageClient(MessageClient messageClient) {
        if (this.messageClients != null && this.messageClients.remove(messageClient)) {
            messageClient.removeMessageClientDestroyedListener(this);
        }
    }

    @Override
    public void timeout() {
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkValid() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                LocalizedException e = new LocalizedException();
                e.setMessage(10019);
                throw e;
            }
        }
    }

    protected void notifyAttributeAdded(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            for (FlexSessionAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeAdded(event);
            }
        }
    }

    protected void notifyAttributeBound(String name, Object value) {
        if (value != null && value instanceof FlexSessionBindingListener) {
            FlexSessionBindingEvent bindingEvent = new FlexSessionBindingEvent(this, name);
            ((FlexSessionBindingListener)value).valueBound(bindingEvent);
        }
    }

    protected void notifyAttributeRemoved(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            for (FlexSessionAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeRemoved(event);
            }
        }
    }

    protected void notifyAttributeReplaced(String name, Object value) {
        if (this.attributeListeners != null && !this.attributeListeners.isEmpty()) {
            FlexSessionBindingEvent event = new FlexSessionBindingEvent(this, name, value);
            for (FlexSessionAttributeListener attribListener : this.attributeListeners) {
                attribListener.attributeReplaced(event);
            }
        }
    }

    protected void notifyAttributeUnbound(String name, Object value) {
        if (value != null && value instanceof FlexSessionBindingListener) {
            FlexSessionBindingEvent bindingEvent = new FlexSessionBindingEvent(this, name);
            ((FlexSessionBindingListener)value).valueUnbound(bindingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCreated() {
        Object object = this.lock;
        synchronized (object) {
            if (this.creationNotified) {
                return;
            }
            this.creationNotified = true;
        }
        if (!createdListeners.isEmpty()) {
            Iterator<FlexSessionListener> iter = createdListeners.iterator();
            while (iter.hasNext()) {
                iter.next().sessionCreated(this);
            }
        }
    }
}

