/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting.util;

import com.vmware.vise.reporting.DataSource;
import com.vmware.vise.reporting.ReportDef;
import com.vmware.vise.reporting.ReportingException;
import com.vmware.vise.util.io.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class Utils {
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        inputStream.close();
        outputStream.close();
    }

    public static byte[] file2bytes(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            return Utils.inputStream2bytes(fileInputStream);
        }
        catch (Exception exception) {
            StreamUtil.close(fileInputStream);
            throw new ReportingException(exception);
        }
    }

    public static byte[] inputStream2bytes(InputStream inputStream) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Utils.copyStream(inputStream, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReportingException(iOException);
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
        }
    }

    public static String inputStream2String(InputStream inputStream) {
        try {
            int n;
            char[] cArray = new char[65536];
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            do {
                if ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) <= 0) continue;
                stringBuilder.append(cArray, 0, n);
            } while (n >= 0);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new ReportingException(iOException);
        }
    }

    public static DataSource.Field fromJRField(JRField jRField) {
        DataSource.Field field = new DataSource.Field(jRField.getName(), jRField.getValueClass(), jRField.getDescription(), null);
        JRPropertiesMap jRPropertiesMap = jRField.getPropertiesMap();
        if (jRPropertiesMap != null) {
            String[] stringArray = jRPropertiesMap.getPropertyNames();
            field.properties = new HashMap<String, String>(stringArray.length);
            for (String string : stringArray) {
                field.properties.put(string, jRPropertiesMap.getProperty(string));
            }
        }
        return field;
    }

    public static JRField fromField(DataSource.Field field) {
        JRDesignField jRDesignField = new JRDesignField();
        jRDesignField.setName(field.name);
        jRDesignField.setDescription(field.description);
        jRDesignField.setValueClass(field.valueClass);
        JRPropertiesMap jRPropertiesMap = jRDesignField.getPropertiesMap();
        for (String string : field.properties.keySet()) {
            jRPropertiesMap.setProperty(string, field.properties.get(string));
        }
        return jRDesignField;
    }

    public static DataSource fromJRDataSource(final JRDataSource jRDataSource) {
        return new DataSource(){

            @Override
            public Object getValue(DataSource.Field field) {
                try {
                    return jRDataSource.getFieldValue(Utils.fromField(field));
                }
                catch (JRException jRException) {
                    throw new ReportingException((Exception)((Object)jRException));
                }
            }

            @Override
            public boolean nextRow() throws ReportingException {
                try {
                    return jRDataSource.next();
                }
                catch (JRException jRException) {
                    throw new ReportingException((Exception)((Object)jRException));
                }
            }
        };
    }

    public static JRDataSource fromDataSource(final DataSource dataSource) {
        return new JRDataSource(){

            public Object getFieldValue(JRField jRField) throws JRException {
                return dataSource.getValue(Utils.fromJRField(jRField));
            }

            public boolean next() throws JRException {
                return dataSource.nextRow();
            }
        };
    }

    public static JRDataSource ensureJRDataSource(Object object) {
        if (object instanceof DataSource) {
            return Utils.fromDataSource((DataSource)object);
        }
        if (object instanceof JRDataSource) {
            return (JRDataSource)object;
        }
        throw new RuntimeException("Object " + object + " cannot be converted into a JRDataSource");
    }

    /*
     * WARNING - void declaration
     */
    public static List<JRDesignElement> findElementsByType(JasperDesign jasperDesign, Class clazz) {
        Object arrayList2;
        ArrayList<JRElement> arrayList = new ArrayList<JRElement>();
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getBackground().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getTitle().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getPageHeader().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getColumnHeader().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            void e;
            arrayList2 = jasperDesign.getDetailSection().getBands();
            int n = ((JRBand[])arrayList2).length;
            boolean bl = false;
            while (e < n) {
                JRBand jRBand = arrayList2[e];
                arrayList.addAll(Arrays.asList(jRBand.getElements()));
                ++e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getColumnFooter().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getPageFooter().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getSummary().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            arrayList.addAll(Arrays.asList(jasperDesign.getNoData().getElements()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        arrayList2 = new ArrayList();
        for (Object e : arrayList) {
            if (!clazz.isInstance(e)) continue;
            arrayList2.add((JRDesignElement)e);
        }
        return arrayList2;
    }

    public static ResourceBundle createResourceBundle(ReportDef reportDef, Locale locale) throws IOException {
        InputStream inputStream = Utils.findLocalizedResource(reportDef, locale);
        if (inputStream == null) {
            return null;
        }
        return new PropertyResourceBundle(inputStream);
    }

    public static InputStream findLocalizedResource(ReportDef reportDef, Locale locale) throws IOException {
        String string = reportDef.getManifest().getProperty("BundleName");
        InputStream inputStream = null;
        if (locale != null) {
            String string2 = locale.toString();
            try {
                inputStream = reportDef.getResource(string + "_" + string2 + ".properties");
            }
            catch (Exception exception) {
                string2 = locale.getLanguage() + "_" + locale.getCountry().toUpperCase(Locale.ENGLISH);
                try {
                    inputStream = reportDef.getResource(string + "_" + string2 + ".properties");
                }
                catch (Exception exception2) {
                    string2 = locale.getLanguage();
                    try {
                        inputStream = reportDef.getResource(string + "_" + string2 + ".properties");
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
        }
        if (inputStream == null) {
            inputStream = reportDef.getResource(string + ".properties");
        }
        return inputStream;
    }

    public static Properties getLocalizedResource(ReportDef reportDef, Locale locale) {
        try {
            InputStream inputStream = Utils.findLocalizedResource(reportDef, locale);
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Locale createLocale(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        String[] stringArray = string.split("_");
        switch (stringArray.length) {
            case 3: {
                return new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
            case 2: {
                return new Locale(stringArray[0], stringArray[1]);
            }
            case 1: {
                return new Locale(stringArray[0]);
            }
        }
        return Locale.getDefault();
    }
}

