/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.srs.impl;

import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.opsmgmt.client.srs.impl.SrsPropertiesProvider;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.util.codec.Base64;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.http.HttpUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrsChartsProvider
implements PropertyProviderBean {
    private static final Log LOGGER = LogFactory.getLog(SrsChartsProvider.class);
    private static final int HEADER_CHUNK_SIZE_BYTES = 1024;
    private static final int DEFAULT_SOCKET_TIMEOUT_MS = 600000;
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final int SRS_TEXT_URL_REQUEST_PARAMETER_INDEX = 0;
    private static final int IS_HTML_PAGE_REQUEST_REQUEST_PARAMETER_INDEX = 1;
    private static final int NUMBER_OF_REQUEST_PARAMETERS = 2;
    private KeystoreService _keystoreService;
    private final SSLConfigurationProvider _sslConfigProvider;

    public SrsChartsProvider(SSLConfigurationProvider sSLConfigurationProvider) {
        Validate.notNull((Object)sSLConfigurationProvider);
        this._sslConfigProvider = sSLConfigurationProvider;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    @type(value="Datacenter,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Datastore,StoragePod")
    public String getSrsTextContent(ManagedObjectReference managedObjectReference, Object[] objectArray) {
        if (objectArray.length != 2) {
            LOGGER.error((Object)("Invalid number of request parameters : " + objectArray.length));
            return null;
        }
        String string = (String)objectArray[0];
        Boolean bl = (Boolean)objectArray[1];
        if (string == null || bl == null) {
            LOGGER.error((Object)"There is null in the request parameters.");
            return null;
        }
        HttpClient httpClient = this.getVcHttpClient(managedObjectReference);
        if (httpClient == null) {
            return null;
        }
        Map<String, String> map = this.getCustomHeaders(httpClient, managedObjectReference, string);
        long l = System.currentTimeMillis();
        String string2 = httpClient.executeMethod(string, null, map);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("Text content retrieved in %sms.", System.currentTimeMillis() - l));
        }
        return string2;
    }

    @type(value="Datacenter,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Datastore,StoragePod")
    public byte[] getSrsImage(ManagedObjectReference managedObjectReference, String string) {
        HttpClient httpClient = this.getVcHttpClient(managedObjectReference);
        if (httpClient == null) {
            return null;
        }
        Map<String, String> map = this.getCustomHeaders(httpClient, managedObjectReference, string);
        return httpClient.executeMethodResponseAsBytes(string, null, map);
    }

    protected HttpClient getVcHttpClient(ManagedObjectReference managedObjectReference) {
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        HttpClient httpClient = null;
        try {
            httpClient = this._keystoreService != null && VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) ? new SSLBuilder().sslConfigurationProvider(this._sslConfigProvider).addTrustStore(this._keystoreService.getKeyStore()).socketReadTimeout(600000).buildHttpClient() : new SSLBuilder().sslConfigurationProvider(this._sslConfigProvider).thumbprint(vcService.getThumbprint()).socketReadTimeout(600000).buildHttpClient();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Cannot build HttpClient", (Throwable)exception);
        }
        return httpClient;
    }

    private Map<String, String> getCustomHeaders(HttpClient httpClient, ManagedObjectReference managedObjectReference, String string) {
        HttpServletRequest httpServletRequest = SessionUtil.getHttpRequest();
        Map map = HttpUtil.getRequestHeaders((HttpServletRequest)httpServletRequest, (String[])new String[]{"Accept-Language", "Accept-Charset"});
        boolean bl = SrsPropertiesProvider.isPerfchartsServiceVersionOneDotOne(managedObjectReference.getServerGuid());
        this.addAuthorizationHeaders(map, string, bl);
        return map;
    }

    private void addAuthorizationHeaders(Map<String, String> map, String string, boolean bl) {
        try {
            SamlToken samlToken = AuthSessionUtil.getSsoToken();
            if (bl) {
                PrivateKey privateKey = SsoUtil.getSolutionUser().getPrivateKey();
                SsoOverRestRequest ssoOverRestRequest = new SsoOverRestRequest(Request.Method.GET, new URL(string), null);
                Map map2 = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)ssoOverRestRequest, (PrivateKey)privateKey, (SamlToken)samlToken, (int)1024);
                map.putAll(map2);
            } else {
                String string2 = samlToken.toXml();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(9);
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
                byte[] byArray = string2.getBytes("UTF-8");
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                byte[] byArray2 = Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray());
                String string3 = new String(byArray2);
                map.put(HEADER_AUTHORIZATION, string3);
            }
        }
        catch (SsoOverRestHelper.SsoOverRestHelperException ssoOverRestHelperException) {
            LOGGER.error((Object)"Failed to calculate the authorization header", (Throwable)ssoOverRestHelperException);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Failed to add the authorization header", (Throwable)exception);
        }
    }
}

