/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.srs.impl;

import com.vmware.opsmgmt.client.srs.impl.SrsPingTask;
import com.vmware.opsmgmt.client.srs.impl.SrsServiceDescriptor;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SrsConnectionManager
implements UserSessionListener {
    private static final Log _logger = LogFactory.getLog(SrsConnectionManager.class);
    private static final String KEEP_ALIVE_PERIOD_KEY = "performance.charts.keep.alive.period";
    private static final int KEEP_ALIVE_PERIOD_MIN = 180;
    private final LookupService _lookupService;
    private final ScheduledExecutorService _scheduler;
    private final KeystoreService _keystoreService;
    private final ConfigurationService _configService;
    private final SSLConfigurationProvider _sslConfigProvider;
    private final int _pingTimeout;
    private final long _keepAlivePeriod;
    private final Collection<SrsPingTask> _tasks;

    public SrsConnectionManager(LookupService lookupService, KeystoreService keystoreService, ConfigurationService configurationService, SSLConfigurationProvider sSLConfigurationProvider, ScheduledExecutorService scheduledExecutorService, int n) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{lookupService, scheduledExecutorService, keystoreService, sSLConfigurationProvider});
        this._lookupService = lookupService;
        this._keystoreService = keystoreService;
        this._configService = configurationService;
        this._sslConfigProvider = sSLConfigurationProvider;
        this._scheduler = scheduledExecutorService;
        this._pingTimeout = n;
        this._keepAlivePeriod = this.getKeepAlivePeriod();
        this._tasks = new HashSet<SrsPingTask>();
        SrsConnectionManager.debugLog("Initialized; keepAlivePeriod=%ss; pingTimeout=%sms.", this._keepAlivePeriod, this._pingTimeout);
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        if (!this.keepAliveEnabled()) {
            _logger.info((Object)"Invalid keep alive period; keep alive is disabled.");
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        this.login(httpSession, this.lookupServices());
        SrsConnectionManager.debugLog("Session started; sessionId=%s.", SessionUtil.getHashedSessionId((HttpSession)httpSession));
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        HttpSession httpSession = httpSessionEvent.getSession();
        this.logout(httpSession);
        SrsConnectionManager.debugLog("Session ended; hashedSessionId=%s.", SessionUtil.getHashedSessionId((HttpSession)httpSession));
    }

    public void destroy() throws Exception {
        this._scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SrsServiceDescriptor> lookupServices() {
        ServiceRegistration.EndpointType endpointType;
        Object object;
        ServiceRegistration.Info[] infoArray = null;
        long l = System.currentTimeMillis();
        try {
            object = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.perfcharts");
            endpointType = new ServiceRegistration.EndpointType("http", "com.vmware.perfcharts.entry.url");
            ServiceRegistration.Info[] infoArray2 = new ServiceRegistration.Filter();
            infoArray2.setServiceType((ServiceRegistration.ServiceType)object);
            infoArray2.setEndpointType(endpointType);
            infoArray = this._lookupService.getServiceRegistrationInfos((ServiceRegistration.Filter)infoArray2);
        }
        catch (InvalidArgument | SecurityError throwable) {
            try {
                _logger.error((Object)"LS search failed.", throwable);
            }
            catch (Throwable throwable2) {
                SrsConnectionManager.debugLog("LS search complete in %sms.", System.currentTimeMillis() - l);
                throw throwable2;
            }
            SrsConnectionManager.debugLog("LS search complete in %sms.", System.currentTimeMillis() - l);
        }
        SrsConnectionManager.debugLog("LS search complete in %sms.", System.currentTimeMillis() - l);
        if (infoArray == null) {
            SrsConnectionManager.debugLog("LS search did not return a result.", new Object[0]);
            return Collections.emptyList();
        }
        object = new ArrayList();
        if (infoArray.length > 0) {
            endpointType = infoArray[0];
            for (ServiceRegistration.Info info : infoArray) {
                if (!"1.1".equals(info.getServiceVersion())) continue;
                String string = info.getServiceId();
                ServiceRegistration.Endpoint endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)endpointType, (String)"com.vmware.perfcharts.entry.url");
                endpoint = Objects.requireNonNull(endpoint);
                object.add(SrsServiceDescriptor.newInstance(string, endpoint));
                SrsConnectionManager.debugLog("Service found; id=%s.", string);
            }
        }
        SrsConnectionManager.debugLog("%s services total.", object.size());
        return Collections.unmodifiableCollection(object);
    }

    private synchronized void login(HttpSession httpSession, Collection<SrsServiceDescriptor> collection) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        for (SrsServiceDescriptor srsServiceDescriptor : collection) {
            this.scheduleTask(string, srsServiceDescriptor);
        }
        SrsConnectionManager.debugLog("Login; %s running tasks.", this._tasks.size());
    }

    private synchronized void logout(HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        ArrayList<SrsPingTask> arrayList = new ArrayList<SrsPingTask>();
        for (SrsPingTask srsPingTask : this._tasks) {
            if (!string.equals(srsPingTask.getClientId())) continue;
            arrayList.add(srsPingTask);
        }
        for (SrsPingTask srsPingTask : arrayList) {
            this.cancelTask(srsPingTask);
        }
        SrsConnectionManager.debugLog("Logout; %s running tasks.", this._tasks.size());
    }

    private void scheduleTask(String string, SrsServiceDescriptor srsServiceDescriptor) {
        try {
            SrsPingTask srsPingTask = SrsPingTask.newInstance(srsServiceDescriptor, string, this._pingTimeout, this._keystoreService, this._sslConfigProvider);
            srsPingTask.setHandle(this._scheduler.scheduleAtFixedRate(srsPingTask, 0L, this._keepAlivePeriod, TimeUnit.SECONDS));
            this._tasks.add(srsPingTask);
        }
        catch (Exception exception) {
            _logger.error((Object)"Task creation failed.", (Throwable)exception);
        }
    }

    private void cancelTask(SrsPingTask srsPingTask) {
        boolean bl = srsPingTask.cancel();
        this._tasks.remove(srsPingTask);
        SrsConnectionManager.debugLog("Task cancelled; hashedClientId=%s; serviceId=%s; success=%s.", SessionUtil.getHashedClientId((String)srsPingTask.getClientId()), srsPingTask.getServiceId(), bl);
    }

    private long getKeepAlivePeriod() {
        try {
            return Long.parseLong(this._configService.getProperty(KEEP_ALIVE_PERIOD_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            _logger.warn((Object)String.format("Unable to parse '%s' property; keep alive is disabled.", KEEP_ALIVE_PERIOD_KEY));
            return 0L;
        }
    }

    private boolean keepAliveEnabled() {
        return this._keepAlivePeriod >= 180L;
    }

    private static void debugLog(String string, Object ... objectArray) {
        if (!_logger.isDebugEnabled()) {
            return;
        }
        _logger.debug((Object)String.format(string, objectArray));
    }
}

