/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.is.ModelMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ModelMetadataImpl
implements ModelMetadata {
    private Map<String, StructureInfoImpl> metadata = new HashMap<String, StructureInfoImpl>();

    @Override
    public StructureInfoImpl getStructureInfo(String structureName) {
        return this.metadata.get(structureName);
    }

    public void setStructureInfo(String structureName, StructureInfoImpl metadata) {
        Validate.notNull((Object)structureName);
        Validate.notNull((Object)metadata);
        this.metadata.put(structureName, metadata);
    }

    public Collection<String> getStructureNames() {
        return this.metadata.keySet();
    }

    public static class StructureInfoImpl
    implements ModelMetadata.StructureInfo {
        private Map<String, ModelMetadata.FieldInfo> fieldInfo = new HashMap<String, ModelMetadata.FieldInfo>();
        private String modelKeyField;
        private String modelName;

        public StructureInfoImpl(String modelKeyField, String modelName) {
            this.modelKeyField = modelKeyField;
            this.modelName = modelName;
        }

        @Override
        public ModelMetadata.FieldInfo getFieldInfo(String fieldName) {
            return this.fieldInfo.get(fieldName);
        }

        @Override
        public String getModelIdField() {
            return this.modelKeyField;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        public Map<String, ModelMetadata.FieldInfo> getFieldInfo() {
            return this.fieldInfo;
        }
    }

    public static class FieldInfoImpl
    implements ModelMetadata.FieldInfo {
        private String resourceType;
        private String resourceTypeFieldName;

        public FieldInfoImpl(String resourceType, String resourceTypeFieldName) {
            if (!(resourceType == null ^ resourceTypeFieldName == null)) {
                throw new IllegalArgumentException("Requires exactly one non-null argument");
            }
            this.resourceType = resourceType;
            this.resourceTypeFieldName = resourceTypeFieldName;
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String getResourceTypeFieldName() {
            return this.resourceTypeFieldName;
        }
    }
}

