/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is;

import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.internal.is.ModelMetadataBuilder;
import com.vmware.vapi.internal.is.ValueSerializer;
import com.vmware.vapi.is.DocumentConfig;
import com.vmware.vapi.is.IsAttributeGenerator;
import com.vmware.vapi.is.ModelMetadata;
import com.vmware.vapi.is.XmlOutputHandler;
import com.vmware.vapi.is.exception.SerializationException;

public class Serializer
implements com.vmware.vapi.is.Serializer {
    private final ValueSerializer serializer;

    public Serializer() {
        this(null);
    }

    public Serializer(IsAttributeGenerator idGenerator) {
        this.serializer = new ValueSerializer(idGenerator);
    }

    @Override
    public void serialize(Structure object, XmlOutputHandler outputHandler) throws SerializationException {
        this.serialize(object, outputHandler, null);
    }

    @Override
    public void serialize(Structure object, XmlOutputHandler outputHandler, DocumentConfig documentConfig) throws SerializationException {
        if (object instanceof DynamicStructure) {
            throw new SerializationException("Cannot serialize dynamic structures as resource models. Their bindings do not have information about resources and resource identifiers.");
        }
        if (!(object instanceof StaticStructure)) {
            throw new SerializationException("Unknown structure type " + object.getClass().getName());
        }
        StaticStructure objectAsStatic = (StaticStructure)object;
        StructType type = objectAsStatic._getType();
        if (!type.isModel()) {
            throw new SerializationException("Can not serialize structure that is not a model");
        }
        ModelMetadata metadata = ModelMetadataBuilder.build(objectAsStatic);
        this.serializer.serialize(objectAsStatic._getDataValue(), metadata, documentConfig, outputHandler);
    }
}

