/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.is;

import com.vmware.vapi.is.DefaultAttributeGenerator;
import com.vmware.vapi.is.IsAttributeGenerator;

public class MoRefAttributeGenerator
extends IsAttributeGenerator {
    private static final String QS_RESOURCE_FORMAT = "urn:vmomi:%s:%s";
    private static final String MO_REF_ID_PREFIX = "urn:vmomi:";
    private IsAttributeGenerator defaultGenerator = new DefaultAttributeGenerator();

    @Override
    public String generateQsIdValue(IsAttributeGenerator.IdDetails idDetails) {
        return this.defaultGenerator.generateQsIdValue(idDetails);
    }

    private boolean isMoRefId(String idValue) {
        return idValue.startsWith(MO_REF_ID_PREFIX);
    }

    private boolean isMoRefType(String resourceType) {
        return !resourceType.contains(".");
    }

    @Override
    public String generateXlinkHrefValue(IsAttributeGenerator.IdDetails idDetails) {
        if (this.isMoRefId(idDetails.getIdValue())) {
            return idDetails.getIdValue();
        }
        if (this.isMoRefType(idDetails.getResourceType())) {
            return String.format(QS_RESOURCE_FORMAT, idDetails.getResourceType(), idDetails.getIdValue());
        }
        return this.defaultGenerator.generateXlinkHrefValue(idDetails);
    }
}

