/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security;

import com.vmware.vim.binding.vim.version.internal.version7;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VcDirectory {
    private List<ServerInfoEx> _vcServers = null;
    private static final Log _logger = LogFactory.getLog(VcDirectory.class);
    private static final String PERSISTENCE_STORE_BASEDIR = "PS_BASEDIR";
    private static final String VC_DIRECTORY_FOLDER = "SerenityDB";
    private static final String SERVICE_URL = "serviceUrl";
    private static final String SERVICE_GUID = "serviceGuid";
    private static final String SERVER_INFO_TYPE = "com.vmware.vise.usersession.ServerInfo";
    private static final String ROOT_ELEMENT_TYPE = "VcDirectory";
    private static final String THUMBPRINT = "thumbprint";
    private static final String API_VERSION = "apiVersion";
    private static final String VC_DIRECTORY_VERSION = "directoryVersion";
    private static final String NGC_VERSION = "5.1";
    private static final String MN_VERSION = "5.0";
    private static final String MN_NEXT_VERSION = "5.1";
    private static final String MN_API_VERSION = "5.0";
    private boolean _dirty = false;
    private final String _fileName;

    public VcDirectory(String string) {
        this._fileName = string;
        this.updateServerInfoTypeTags();
        this.sanitizeVcDirectory();
    }

    public ServerInfoEx[] getVcServers() {
        List<ServerInfoEx> list = this.loadVcDirectory();
        if (list == null) {
            _logger.info((Object)"No vc's found in the directory.");
            return new ServerInfoEx[0];
        }
        ServerInfoEx[] serverInfoExArray = list.toArray(new ServerInfoEx[0]);
        return serverInfoExArray;
    }

    public boolean isServerPreRegistered(String string, String string2) {
        ServerInfoEx serverInfoEx = this.getServerInfo(string, string2);
        return serverInfoEx != null;
    }

    public ServerInfoEx getServerInfo(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string) && StringUtil.isNullOrEmpty((String)string2)) {
            return null;
        }
        List<ServerInfoEx> list = this.loadVcDirectory();
        if (list == null) {
            return null;
        }
        for (ServerInfoEx serverInfoEx : list) {
            if (!StringUtil.isNullOrEmpty((String)string2) && string2.equals(serverInfoEx.serviceGuid)) {
                return serverInfoEx;
            }
            if (!serverInfoEx.serviceUrl.equals(string)) continue;
            return serverInfoEx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVc(String string, String string2, String string3, String string4) throws Exception {
        VcDirectory vcDirectory = this;
        synchronized (vcDirectory) {
            try {
                Object object;
                Object object2;
                String string5 = this.getVcDirectoryXml();
                Document document = null;
                if (StringUtil.isNullOrEmpty((String)string5)) {
                    object2 = DocumentBuilderFactory.newInstance();
                    object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                    DOMImplementation dOMImplementation = ((DocumentBuilder)object).getDOMImplementation();
                    document = dOMImplementation.createDocument(null, null, null);
                    Element element = document.createElement(ROOT_ELEMENT_TYPE);
                    element.setAttribute(VC_DIRECTORY_VERSION, "5.1");
                    document.appendChild(element);
                } else {
                    document = XMLUtil.parseXml((String)string5);
                }
                object2 = this.createServerInfoElement(document, string, string2, string3, string4);
                document.getDocumentElement().appendChild((Node)object2);
                object = XMLUtil.xmlToString((Node)document);
                this.saveVcDirectory((String)object);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when registerting vCenter server", (Throwable)exception);
                throw exception;
            }
        }
    }

    private Element createServerInfoElement(Document document, String string, String string2, String string3, String string4) {
        Element element;
        Element element2 = document.createElement(SERVER_INFO_TYPE);
        Element element3 = document.createElement(SERVICE_URL);
        element3.appendChild(document.createTextNode(string));
        element2.appendChild(element3);
        if (!StringUtil.isNullOrEmpty((String)string2)) {
            element = document.createElement(SERVICE_GUID);
            element.appendChild(document.createTextNode(string2));
            element2.appendChild(element);
        }
        if (!StringUtil.isNullOrEmpty((String)string3)) {
            element = document.createElement(THUMBPRINT);
            element.appendChild(document.createTextNode(string3));
            element2.appendChild(element);
        }
        if (!StringUtil.isNullOrEmpty((String)string4)) {
            element = document.createElement(API_VERSION);
            element.appendChild(document.createTextNode(string4));
            element2.appendChild(element);
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVc(String string) throws Exception {
        VcDirectory vcDirectory = this;
        synchronized (vcDirectory) {
            try {
                String string2 = this.getVcDirectoryXml();
                Document document = XMLUtil.parseXml((String)string2);
                NodeList nodeList = document.getElementsByTagName(SERVER_INFO_TYPE);
                boolean bl = false;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string3 = XMLUtil.getChildTagValue((Node)element, (String)SERVICE_URL);
                    if (!string.equals(string3)) continue;
                    bl = true;
                    document.getDocumentElement().removeChild(element);
                    break;
                }
                if (bl) {
                    String string4 = XMLUtil.xmlToString((Node)document);
                    this.saveVcDirectory(string4);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when registerting vCenter server", (Throwable)exception);
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerInfoTypeTags() {
        VcDirectory vcDirectory = this;
        synchronized (vcDirectory) {
            try {
                Object object;
                String string = this.getVcDirectoryXml();
                if (StringUtil.isNullOrEmpty((String)string)) {
                    return;
                }
                Document document = XMLUtil.parseXml((String)string);
                NodeList nodeList = document.getElementsByTagName("com.vmware.vsphere.client.usersession.ServerInfo");
                if (nodeList.getLength() == 0) {
                    return;
                }
                while (nodeList.getLength() > 0) {
                    object = (Element)nodeList.item(0);
                    String string2 = XMLUtil.getChildTagValue((Node)object, (String)SERVICE_URL);
                    String string3 = XMLUtil.getChildTagValue((Node)object, (String)SERVICE_GUID);
                    String string4 = XMLUtil.getChildTagValue((Node)object, (String)THUMBPRINT);
                    String string5 = XMLUtil.getChildTagValue((Node)object, (String)API_VERSION);
                    Element element = this.createServerInfoElement(document, string2, string3, string4, string5);
                    document.getDocumentElement().appendChild(element);
                    document.getDocumentElement().removeChild((Node)object);
                }
                object = XMLUtil.xmlToString((Node)document);
                this.saveVcDirectory((String)object);
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when updating VcDirectory xml tags", (Throwable)exception);
            }
        }
    }

    private synchronized void sanitizeVcDirectory() {
        try {
            Object object;
            String string = this.getVcDirectoryXml();
            if (StringUtil.isNullOrEmpty((String)string)) {
                return;
            }
            Document document = XMLUtil.parseXml((String)string);
            Element element = document.getDocumentElement();
            String string2 = element.getAttribute(VC_DIRECTORY_VERSION);
            if (!StringUtil.isNullOrEmpty((String)string2) && !string2.equals("5.0")) {
                return;
            }
            if (SystemUtils.IS_OS_LINUX) {
                object = document.getElementsByTagName(SERVER_INFO_TYPE);
                int n = 0;
                while (n < object.getLength()) {
                    Element element2 = (Element)object.item(n);
                    String string3 = XMLUtil.getChildTagValue((Node)element2, (String)SERVICE_URL);
                    if (string3.equalsIgnoreCase("localhost")) {
                        document.getDocumentElement().removeChild(element2);
                        continue;
                    }
                    ++n;
                }
            }
            element.setAttribute(VC_DIRECTORY_VERSION, "5.1");
            object = XMLUtil.xmlToString((Node)document);
            this.saveVcDirectory((String)object);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when creating version information of VcDirectory", (Throwable)exception);
        }
    }

    private void saveVcDirectory(String string) throws IOException {
        File file = new File(this.getVcDirectoryBaseDir(), this._fileName);
        try {
            FileUtil.writeTextFile((File)file, (String)string);
        }
        catch (IOException iOException) {
            _logger.error((Object)("Exception while saving vc directory" + iOException.toString()));
            throw iOException;
        }
        this._dirty = true;
    }

    private String getVcDirectoryXml() {
        File file;
        _logger.info((Object)"Reading VcDirectory file on the disk.");
        File file2 = new File(this.getVcDirectoryBaseDir());
        if (!file2.exists()) {
            _logger.info((Object)("VcDirectory directory not found. creating: " + file2.getAbsolutePath()));
            file2.mkdirs();
        }
        if (!(file = new File(file2, this._fileName)).exists()) {
            _logger.info((Object)("VcDirectory file not found: " + file.getAbsolutePath()));
            return null;
        }
        try {
            String string = FileUtil.readTextFile((File)file);
            return string;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when reading vc directory", (Throwable)exception);
            return null;
        }
    }

    private synchronized List<ServerInfoEx> loadVcDirectory() {
        if (!this._dirty && this._vcServers != null) {
            _logger.debug((Object)"Returning VcDirectory from the cache.");
            ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>(this._vcServers);
            return arrayList;
        }
        String string = this.getVcDirectoryXml();
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.info((Object)"No data in VcDirectory file.");
            return Collections.emptyList();
        }
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        NodeList nodeList = null;
        try {
            Document document = XMLUtil.parseXml((String)string);
            if (document == null) {
                _logger.info((Object)"VC directory was null");
                return Collections.emptyList();
            }
            nodeList = document.getElementsByTagName(SERVER_INFO_TYPE);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when reading vc directory file", (Throwable)exception);
        }
        if (nodeList == null) {
            _logger.debug((Object)"No VC node found in the VcDirectory file.");
            return Collections.emptyList();
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                Element element = (Element)nodeList.item(i);
                ServerInfoEx serverInfoEx = this.processVcNode(element);
                if (serverInfoEx != null) {
                    arrayList.add(serverInfoEx);
                }
                _logger.debug((Object)("Processed vc " + serverInfoEx.serviceUrl));
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when parsing vc node", (Throwable)exception);
            }
        }
        this._vcServers = arrayList;
        this._dirty = false;
        return arrayList;
    }

    private ServerInfoEx processVcNode(Element element) {
        String string;
        Object object;
        Object object2;
        ServerInfoEx serverInfoEx = null;
        if (element == null) {
            return serverInfoEx;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)SERVICE_URL);
        if (element2 == null) {
            return serverInfoEx;
        }
        String string2 = XMLUtil.getTagValue((Element)element2);
        if (string2 == null) {
            return serverInfoEx;
        }
        serverInfoEx = new ServerInfoEx();
        serverInfoEx.serviceUrl = string2;
        Element element3 = XMLUtil.getChildTag((Node)element, (String)SERVICE_GUID);
        if (element3 != null && !StringUtil.isNullOrEmpty((String)(object2 = XMLUtil.getTagValue((Element)element3)))) {
            serverInfoEx.serviceGuid = object2;
        }
        if ((object2 = XMLUtil.getChildTag((Node)element, (String)THUMBPRINT)) != null && !StringUtil.isNullOrEmpty((String)(object = XMLUtil.getTagValue((Element)object2)))) {
            serverInfoEx.thumbprint = object;
        }
        if ((object = XMLUtil.getChildTag((Node)element, (String)API_VERSION)) != null && !StringUtil.isNullOrEmpty((String)(string = XMLUtil.getTagValue((Element)object))) && string.equals("5.0")) {
            serverInfoEx.vmodlVersion = version7.class;
        }
        return serverInfoEx;
    }

    private String getVcDirectoryBaseDir() {
        String string = VC_DIRECTORY_FOLDER;
        String string2 = System.getProperty(PERSISTENCE_STORE_BASEDIR);
        if (string2 != null) {
            string = String.format("%s%s%s", string2, File.separator, VC_DIRECTORY_FOLDER);
        }
        return string;
    }
}

