/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.security.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.security.impl.LinkedGroupUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LookupServiceVcSource
implements VcSource {
    private static final Log _logger = LogFactory.getLog(LookupServiceVcSource.class);
    private LookupService _lookupService;
    private Map<String, String> _vcGuidByNodeId = null;

    public LookupServiceVcSource(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public List<ServerInfoEx> getVcs() {
        ArrayList<ServerInfoEx> arrayList = new ArrayList<ServerInfoEx>();
        ServiceRegistration.Info[] infoArray = LookupUtil.find((LookupService)this._lookupService, (ServiceRegistration.ServiceType)LookupUtil.VCENTER);
        if (infoArray == null || infoArray.length == 0) {
            _logger.warn((Object)"No VC's retrieved from LookupService");
            return arrayList;
        }
        ServiceRegistration.Info[] infoArray2 = LookupUtil.find((LookupService)this._lookupService, (ServiceRegistration.ServiceType)LookupUtil.IS);
        if (infoArray2 == null) {
            _logger.warn((Object)"No INV's retrieved from LookupService");
            return arrayList;
        }
        this.applyLocalUrl(infoArray2);
        return this.getVcsInternal(infoArray, infoArray2);
    }

    public String getServiceIdOfLocalVc() {
        String string = LookupUtil.getLocalHostLduGuid((LookupService)this._lookupService);
        if (string == null) {
            return "";
        }
        if (this._vcGuidByNodeId != null) {
            return this._vcGuidByNodeId.get(string);
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(LookupUtil.VCENTER);
        filter.setNodeId(string);
        ServiceRegistration.Info[] infoArray = this._lookupService.getServiceRegistrationInfos(filter);
        if (infoArray == null || infoArray.length == 0) {
            return "";
        }
        return infoArray[0].getServiceId();
    }

    private List<ServerInfoEx> getVcsInternal(ServiceRegistration.Info[] infoArray, ServiceRegistration.Info[] infoArray2) {
        ArrayList<ServiceEndpointEx> arrayList = new ArrayList<ServiceEndpointEx>();
        this._vcGuidByNodeId = new HashMap<String, String>();
        ArrayList<ServerInfoEx> arrayList2 = new ArrayList<ServerInfoEx>(infoArray.length);
        for (ServiceRegistration.Info object2 : infoArray) {
            ServerInfoEx serverInfoEx = this.createServerInfoEx(object2);
            if (serverInfoEx == null) continue;
            arrayList2.add(serverInfoEx);
            ServiceEndpointEx serviceEndpointEx = this.createServiceEndpoint(object2);
            if (serviceEndpointEx == null) continue;
            arrayList.add(serviceEndpointEx);
        }
        for (ServerInfoEx serverInfoEx : arrayList2) {
            if (!LinkedGroupUtils.is60VcOrLater(serverInfoEx.version)) continue;
            serverInfoEx.peers = LinkedGroupUtils.getServerInfosForVcPeers(serverInfoEx, arrayList2);
        }
        LinkedGroupUtils.addISEndpoints(this._lookupService, infoArray2, this._vcGuidByNodeId, arrayList);
        ServiceEndpointEx[] serviceEndpointExArray = arrayList.toArray(new ServiceEndpointEx[0]);
        for (ServerInfoEx serverInfoEx : arrayList2) {
            if (!LinkedGroupUtils.is60VcOrLater(serverInfoEx.version)) continue;
            serverInfoEx.endpoints = serviceEndpointExArray;
        }
        LinkedList linkedList = new LinkedList();
        ServerInfoEx serviceEndpointEx = null;
        String string = LookupUtil.getLocalHostId((LookupService)this._lookupService);
        for (ServerInfoEx serverInfoEx : arrayList2) {
            boolean bl = LinkedGroupUtils.is60VcOrLater(serverInfoEx.version);
            if (bl) {
                if (string != null && string.equals(serverInfoEx.nodeId)) {
                    serviceEndpointEx = serverInfoEx;
                    continue;
                }
                if (serviceEndpointEx != null) continue;
                serviceEndpointEx = serverInfoEx;
                continue;
            }
            linkedList.add(serverInfoEx);
        }
        if (serviceEndpointEx != null) {
            linkedList.addFirst(serviceEndpointEx);
        }
        LookupServiceVcSource.logDuplicateVcEndpoints(linkedList);
        return linkedList;
    }

    private static void logDuplicateVcEndpoints(List<ServerInfoEx> list) {
        for (ServerInfoEx serverInfoEx : list) {
            ServiceEndpointEx[] serviceEndpointExArray = serverInfoEx.endpoints;
            if (serviceEndpointExArray == null || serviceEndpointExArray.length == 0) continue;
            HashSet<String> hashSet = new HashSet<String>(serviceEndpointExArray.length);
            HashSet<String> hashSet2 = null;
            for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray) {
                String string;
                boolean bl;
                if (serviceEndpointEx.getServiceEndpointType() != ServiceEndpointType.VC || (bl = hashSet.add(string = serviceEndpointEx.getUrl()))) continue;
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<String>();
                }
                hashSet2.add(string);
            }
            if (hashSet2 == null) continue;
            _logger.warn((Object)("Duplicate VC URLs found: " + hashSet2));
        }
    }

    private ServerInfoEx createServerInfoEx(ServiceRegistration.Info info) {
        String string;
        ServiceRegistration.Endpoint endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)info, (String)"com.vmware.vim");
        if (endpoint == null) {
            String string2 = LookupUtil.getServiceAttribute((ServiceRegistration.Info)info, (String)"com.vmware.cis.cm.HostId");
            _logger.warn((Object)("Found no endpoint in VC service:" + string2));
            return null;
        }
        ServerInfoEx serverInfoEx = new ServerInfoEx();
        serverInfoEx.nodeId = info.getNodeId();
        serverInfoEx.version = info.getServiceVersion();
        serverInfoEx.serviceGuid = string = info.getServiceId();
        serverInfoEx.serviceUrl = endpoint.getUrl().toString();
        _logger.info((Object)String.format("Found vCenter Server %1s with id %2s from Lookup Service", serverInfoEx.serviceUrl, string));
        this.setThumprintAndCertificate(endpoint, serverInfoEx);
        this._vcGuidByNodeId.put(info.getNodeId(), string);
        return serverInfoEx;
    }

    private ServiceEndpointEx createServiceEndpoint(ServiceRegistration.Info info) {
        ServiceEndpointEx serviceEndpointEx = LinkedGroupUtils.is60VcOrLater(info.getServiceVersion()) ? LinkedGroupUtils.createVcServiceEndpoint(this._lookupService, info) : null;
        return serviceEndpointEx;
    }

    private void setThumprintAndCertificate(ServiceRegistration.Endpoint endpoint, ServerInfoEx serverInfoEx) {
        String[] stringArray = endpoint.getSslTrust();
        if (stringArray != null && stringArray.length > 0 && !StringUtil.isNullOrEmpty((String)stringArray[0])) {
            String string = stringArray[0];
            try {
                String string2;
                serverInfoEx.thumbprint = string2 = CertificateUtil.getThumbprint((String)string);
                serverInfoEx.sslTrustAnchor = string;
            }
            catch (Exception exception) {
                _logger.error((Object)("Error when extracting thumbprint from certificate for vc:" + serverInfoEx.serviceUrl));
            }
        }
    }

    private void applyLocalUrl(ServiceRegistration.Info[] infoArray) {
        String string = LookupUtil.getLocalHostLduGuid((LookupService)this._lookupService);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return;
        }
        for (ServiceRegistration.Info info : infoArray) {
            for (ServiceRegistration.Endpoint endpoint : info.getServiceEndpoints()) {
                this.applyLocalUrl(endpoint, info.getNodeId(), string);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Applied local URLs to serverInfos: %s ", ArrayUtils.toString((Object)infoArray)));
        }
    }

    private void applyLocalUrl(ServiceRegistration.Endpoint endpoint, String string, String string2) {
        ServiceRegistration.Attribute[] attributeArray;
        if (string2.equals(string) && (attributeArray = endpoint.getEndpointAttributes()) != null) {
            ServiceRegistration.EndpointType endpointType = endpoint.getEndpointType();
            for (ServiceRegistration.Attribute attribute : attributeArray) {
                if (!"cis.common.ep.localurl".equals(attribute.getKey())) continue;
                endpoint.setUrl(URI.create(attribute.getValue()));
                if (!"vapi.json.https".equals(endpointType.getProtocol())) continue;
                endpointType.setProtocol("vapi.json.http");
            }
        }
    }
}

