/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.flex.config.xml.AbstractMessageDestinationBeanDefinitionParser;
import org.springframework.flex.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsMessageDestinationBeanDefinitionParser
extends AbstractMessageDestinationBeanDefinitionParser {
    private static final String JMS_ADAPTER_CLASS_NAME = "org.springframework.flex.messaging.jms.JmsAdapter";
    private static final String CONNECTION_FACTORY_ATTR = "connection-factory";
    private static final String JMS_DESTINATION_ATTR = "jms-destination";
    private static final String TOPIC_NAME_ATTR = "topic-name";
    private static final String QUEUE_NAME_ATTR = "queue-name";
    private static final String DESTINATION_RESOLVER_ATTR = "destination-resolver";
    private static final String MESSAGE_CONVERTER_ATTR = "message-converter";
    private static final String TRANSACTION_MANAGER_ATTR = "transaction-manager";
    private static final String SERVICE_ADAPTER_PROPERTY = "serviceAdapter";
    private static final String CONNECTION_FACTORY_PROPERTY = "connectionFactory";
    private static final String DEFAULT_CONNECTION_FACTORY_REF = "connectionFactory";

    protected void parseAdapter(Element element, ParserContext parserContext, BeanDefinitionBuilder destinationBuilder) {
        BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)JMS_ADAPTER_CLASS_NAME);
        int count = ParsingUtils.countProvidedAttributeValues(element, JMS_DESTINATION_ATTR, QUEUE_NAME_ATTR, TOPIC_NAME_ATTR);
        if (count != 1) {
            parserContext.getReaderContext().error("exactly one of 'jms-destination', 'queue-name', or 'topic-name' is required", (Object)element);
            return;
        }
        String connectionFactoryId = element.getAttribute(CONNECTION_FACTORY_ATTR);
        connectionFactoryId = StringUtils.hasText((String)connectionFactoryId) ? connectionFactoryId : "connectionFactory";
        adapterBuilder.addPropertyReference("connectionFactory", connectionFactoryId);
        ParsingUtils.mapOptionalBeanRefAttributes(element, adapterBuilder, parserContext, JMS_DESTINATION_ATTR, DESTINATION_RESOLVER_ATTR, MESSAGE_CONVERTER_ATTR, TRANSACTION_MANAGER_ATTR);
        ParsingUtils.mapOptionalAttributes(element, parserContext, adapterBuilder, QUEUE_NAME_ATTR, TOPIC_NAME_ATTR);
        String serviceAdapterId = ParsingUtils.registerInfrastructureComponent(element, parserContext, adapterBuilder);
        destinationBuilder.addPropertyValue(SERVICE_ADAPTER_PROPERTY, (Object)serviceAdapterId);
    }
}

