/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.config.ConfigMap;
import flex.messaging.log.AbstractTarget;
import flex.messaging.log.LogEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLoggingTarget
extends AbstractTarget {
    protected String categoryPrefix = null;

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        this.categoryPrefix = properties.getPropertyAsString("categoryPrefix", null);
    }

    public void logEvent(LogEvent logevent) {
        String category = logevent.logger.getCategory();
        if (this.categoryPrefix != null) {
            category = this.categoryPrefix + "." + category;
        }
        Log log = LogFactory.getLog((String)category);
        switch (logevent.level) {
            case 1000: {
                if (!log.isFatalEnabled()) break;
                log.fatal((Object)logevent.message, logevent.throwable);
                break;
            }
            case 8: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)logevent.message, logevent.throwable);
                break;
            }
            case 6: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)logevent.message, logevent.throwable);
                break;
            }
            case 4: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)logevent.message, logevent.throwable);
                break;
            }
            case 2: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)logevent.message, logevent.throwable);
                break;
            }
            case 0: {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)logevent.message, logevent.throwable);
                break;
            }
        }
    }
}

