/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import flex.messaging.MessageBroker;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.flex.config.MessageBrokerConfigProcessor;
import org.springframework.flex.core.io.NumberConverter;
import org.springframework.flex.core.io.SpringPropertyProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAmfConversionServiceConfigProcessor
implements MessageBrokerConfigProcessor,
InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ConversionService conversionService;
    private boolean useDirectFieldAccess = false;

    public void afterPropertiesSet() throws Exception {
        this.conversionService = this.conversionService != null ? this.conversionService : this.getDefaultConversionService();
    }

    @Override
    public final MessageBroker processAfterStartup(MessageBroker broker) {
        this.registerAmfProxies(this.conversionService, this.useDirectFieldAccess);
        return broker;
    }

    @Override
    public final MessageBroker processBeforeStartup(MessageBroker broker) {
        return broker;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setUseDirectFieldAccess(boolean useDirectFieldAccess) {
        this.useDirectFieldAccess = useDirectFieldAccess;
    }

    protected void registerAmfProxies(ConversionService conversionService, boolean useDirectFieldAccess) {
        Set<Class<?>> typesToRegister = this.findTypesToRegister();
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Types detected for AMF serialization support: " + typesToRegister.toString()));
        }
        for (Class<?> type : typesToRegister) {
            this.registerPropertyProxy(SpringPropertyProxy.proxyFor(type, useDirectFieldAccess, conversionService));
        }
    }

    protected void registerPropertyProxy(SpringPropertyProxy proxy) {
        PropertyProxyRegistry.getRegistry().register(proxy.getBeanType(), (PropertyProxy)proxy);
    }

    protected abstract Set<Class<?>> findTypesToRegister();

    protected void configureConverters(ConverterRegistry registry) {
    }

    private ConversionService getDefaultConversionService() {
        GenericConversionService conversionService = new GenericConversionService();
        this.configureConverters((ConverterRegistry)conversionService);
        conversionService.addConverter((GenericConverter)new NumberConverter());
        return conversionService;
    }
}

