/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public final class AntPathRequestMatcher
implements RequestMatcher {
    private static final Log logger = LogFactory.getLog(AntPathRequestMatcher.class);
    private static final String MATCH_ALL = "/**";
    private final Matcher matcher;
    private final String pattern;

    public AntPathRequestMatcher(String pattern) {
        Assert.hasText((String)pattern, (String)"Pattern cannot be null or empty");
        if (pattern.equals(MATCH_ALL) || pattern.equals("**")) {
            pattern = MATCH_ALL;
            this.matcher = null;
        } else {
            this.matcher = (pattern = pattern.toLowerCase()).endsWith(MATCH_ALL) && pattern.indexOf(63) == -1 && pattern.indexOf("*") == pattern.length() - 2 ? new SubpathMatcher(pattern.substring(0, pattern.length() - 3)) : new SpringAntMatcher(pattern);
        }
        this.pattern = pattern;
    }

    public boolean matches(HttpServletRequest request) {
        if (this.pattern.equals(MATCH_ALL)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request '" + this.getRequestPath(request) + "' matched by universal pattern '/**'"));
            }
            return true;
        }
        String url = this.getRequestPath(request);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking match of request : '" + url + "'; against '" + this.pattern + "'"));
        }
        return this.matcher.matches(url);
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + request.getPathInfo();
        }
        url = url.toLowerCase();
        return url;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntPathRequestMatcher)) {
            return false;
        }
        AntPathRequestMatcher other = (AntPathRequestMatcher)obj;
        return this.pattern.equals(other.pattern);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ant [pattern='").append(this.pattern).append("'");
        sb.append("]");
        return sb.toString();
    }

    private static class SubpathMatcher
    implements Matcher {
        private final String subpath;
        private final int length;

        private SubpathMatcher(String subpath) {
            assert (!subpath.contains("*"));
            this.subpath = subpath;
            this.length = subpath.length();
        }

        public boolean matches(String path) {
            return path.startsWith(this.subpath) && (path.length() == this.length || path.charAt(this.length) == '/');
        }
    }

    private static class SpringAntMatcher
    implements Matcher {
        private static final AntPathMatcher antMatcher = new AntPathMatcher();
        private final String pattern;

        private SpringAntMatcher(String pattern) {
            this.pattern = pattern;
        }

        public boolean matches(String path) {
            return antMatcher.match(this.pattern, path);
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

