/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.FlexContext;
import flex.messaging.endpoints.Endpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointSecurityMetadataSource
implements SecurityMetadataSource {
    private Map<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
    private Map<String, Collection<ConfigAttribute>> endpointMap = new LinkedHashMap<String, Collection<ConfigAttribute>>();

    public EndpointSecurityMetadataSource(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap) {
        Assert.notNull(requestMap, (String)"requestMap cannot be null");
        this.requestMap = requestMap;
    }

    public EndpointSecurityMetadataSource(LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap, HashMap<String, Collection<ConfigAttribute>> endpointMap) {
        this(requestMap);
        Assert.notNull(endpointMap, (String)"endpointMap cannot be null");
        this.endpointMap = endpointMap;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be an Endpoint");
        }
        Endpoint endpoint = (Endpoint)object;
        Collection<ConfigAttribute> attributes = null;
        if (this.endpointMap.containsKey(endpoint.getId())) {
            attributes = this.endpointMap.get(endpoint.getId());
        } else {
            HttpServletRequest request = FlexContext.getHttpRequest();
            if (request != null) {
                for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : this.requestMap.entrySet()) {
                    if (!entry.getKey().matches(request)) continue;
                    return entry.getValue();
                }
            }
        }
        return attributes;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        ArrayList<ConfigAttribute> allAttributes = new ArrayList<ConfigAttribute>();
        for (Map.Entry<String, Collection<ConfigAttribute>> entry : this.endpointMap.entrySet()) {
            allAttributes.addAll(entry.getValue());
        }
        for (Map.Entry<String, Collection<ConfigAttribute>> entry : this.requestMap.entrySet()) {
            allAttributes.addAll(entry.getValue());
        }
        return Collections.unmodifiableCollection(allAttributes);
    }

    public boolean supports(Class<?> clazz) {
        return Endpoint.class.isAssignableFrom(clazz);
    }
}

