/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.ServiceFault;
import com.vmware.vim.binding.pbm.version.internal.versions;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.mks.util.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.request.DelegatingRequestContextProvider;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.OpIdContextHandler;
import com.vmware.vise.vim.commons.vmomi.response.ResultInterceptorImpl;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.context.VcSessionCookieContextProvider;
import com.vmware.vsphere.client.spbm.LocationLookupException;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.PbmServiceLocationLookup;
import com.vmware.vsphere.client.spbm.impl.PbmInvocationInterceptor;
import com.vmware.vsphere.client.spbm.impl.PbmServiceImpl;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PbmServiceFactoryImpl
implements PbmServiceFactory {
    private static final Log _logger = LogFactory.getLog(PbmServiceFactoryImpl.class);
    private Class<?> _versionClass;
    private PbmServiceLocationLookup _locationLookup;
    private ThreadPoolExecutor _threadPoolExecutor;
    private KeystoreService _keystoreService;
    private LookupService _lookupService;
    private FeatureStateService _featureStateService;

    public void setVersionClass(Class<?> versionClass) {
        this._versionClass = versionClass;
    }

    public void setLocationLookup(PbmServiceLocationLookup locationLookup) {
        this._locationLookup = locationLookup;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this._threadPoolExecutor = executor;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setLookupService(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public void setFeatureStateService(FeatureStateService featureStateService) {
        this._featureStateService = featureStateService;
    }

    @Override
    public PbmService getService(VcService vcService) throws LocationLookupException {
        Client client = this.createVlsiClient(vcService);
        return new PbmServiceImpl(client, vcService.getServiceGuid(), this._featureStateService);
    }

    private Client createVlsiClient(VcService vcService) throws LocationLookupException {
        HttpConfigurationImpl httpConfiguration = new HttpConfigurationImpl();
        if (this._keystoreService != null && VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) && PbmServiceFactoryImpl.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            httpConfiguration.setTrustStore(this._keystoreService.getKeyStore());
        } else {
            SslThumbprintVerifier sslThumbprintVerifier = new SslThumbprintVerifier();
            sslThumbprintVerifier.setThumbprint(vcService.getThumbprint());
            httpConfiguration.setThumbprintVerifier((ThumbprintVerifier)sslThumbprintVerifier);
        }
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setExecutor((Executor)this._threadPoolExecutor);
        httpClientConfiguration.setHttpConfiguration((HttpConfiguration)httpConfiguration);
        String sessionCookie = vcService.getConnectionInfo().getSessionCookie();
        VcSessionCookieContextProvider cookieProvider = new VcSessionCookieContextProvider(sessionCookie);
        DelegatingRequestContextProvider contextProvider = new DelegatingRequestContextProvider(new ManagedObjectContextHandler[]{cookieProvider, new OpIdContextHandler()});
        httpClientConfiguration.setRequestContextProvider((RequestContextProvider)contextProvider);
        httpClientConfiguration.setResultInterceptor((ResultInterceptor)new ResultInterceptorImpl());
        httpClientConfiguration.setInvocationInterceptor((InvocationInterceptor)new PbmInvocationInterceptor(vcService.getServiceGuid()));
        Client client = null;
        client = VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) ? Client.Factory.createClient((URI)this.lookupSpbmURI(vcService), (Class)versions.PBM_VERSION_NEWEST, (ClientConfiguration)httpClientConfiguration) : Client.Factory.createClient((URI)this.lookupSpbmURI(vcService), this._versionClass, (ClientConfiguration)httpClientConfiguration);
        return client;
    }

    private static boolean isVcFromStartupLinkedVcGroup(String vcServiceGuid) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return false;
        }
        LinkedVcGroup[] startupGroups = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (startupGroups == null) {
            return false;
        }
        for (LinkedVcGroup vcGroup : startupGroups) {
            if (vcGroup.getVcService(vcServiceGuid) == null) continue;
            return true;
        }
        return false;
    }

    private URI lookupSpbmURI(VcService vcService) throws LocationLookupException {
        _logger.debug((Object)"getting the URI of the SPBM endpoint for the provided VC from LS");
        if (VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) && PbmServiceFactoryImpl.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            try {
                ServiceRegistration.Info info;
                ServiceRegistration.Endpoint endpoint;
                ServiceRegistration.Info vcServiceInfo = this._lookupService.find(vcService.getServiceGuid());
                ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
                filter.setServiceType(LookupUtil.SMS);
                filter.setNodeId(vcServiceInfo.getNodeId());
                ServiceRegistration.Info[] infos = this._lookupService.getServiceRegistrationInfos(filter);
                if (infos != null && infos.length > 0 && (endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)(info = infos[0]), (String)"com.vmware.vim.pbm")) != null) {
                    return endpoint.getUrl();
                }
            }
            catch (ServiceFault | InvalidArgument | SecurityError e) {
                _logger.error((Object)e);
            }
        }
        return this._locationLookup.getPbmServiceLocation(vcService);
    }
}

