/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl;

import com.vmware.vim.binding.pbm.compliance.ComplianceResult;
import com.vmware.vim.binding.pbm.compliance.RollupComplianceResult;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.common.spbm.data.VirtualDiskStorageProfileAssignmentData;
import com.vmware.vsphere.client.common.spbm.data.VmStorageProfileAssignmentsData;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.impl.PbmServiceUnableToConnectException;
import com.vmware.vsphere.client.spbm.util.ManagedUtil;
import com.vmware.vsphere.client.spbm.util.PbmSessionUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmProfileAssignmentPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VmProfileAssignmentPropertyProviderAdapter.class);
    private static final String VM_STORAGE_PROFILE_ASSIGNMENTS = "vmStorageProfileAssignments";
    private static final String VM_SPBM_PROFILE_MISMATCH = "vmSpbmProfileMismatch";
    private static final String VM_COMPL_STATUS_EX = "pbmStorageComplStatusEx";
    private static final String VM_COMPL_STATUS_LABEL = "pbmStorageComplStatusLabel";
    private static final String OUT_OF_DATE_STATUS = "outOfDate";
    private static final String VM_COMPL_STATUS_EX_FOR_PROFILE = "pbmStorageComplStatusExForProfile";
    private static final String VM_LAST_CHECKED_DATE_FOR_PROFILE = "pbmStorageLastCheckedDateForProfile";
    private static final String[] SUPPORTED_PROPERTIES = new String[]{"vmStorageProfileAssignments", "vmSpbmProfileMismatch", "pbmStorageComplStatusEx", "pbmStorageComplStatusLabel", "pbmStorageComplStatusExForProfile", "pbmStorageLastCheckedDateForProfile"};
    private final PbmServiceFactory _pbmServiceFactory;
    private final ObjectReferenceService _objectReferenceService;

    public VmProfileAssignmentPropertyProviderAdapter(PbmServiceFactory pbmServiceFactory, DataServiceExtensionRegistry registry, ObjectReferenceService objectReferenceService) {
        this._pbmServiceFactory = pbmServiceFactory;
        this._objectReferenceService = objectReferenceService;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = SUPPORTED_PROPERTIES;
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ArrayList<VmSpbmProperties> vmSpbmProperties;
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        Map<String, Object> propertiesToRetrieve = this.getPropertiesToRetrieve(properties);
        boolean retrieveAssignments = propertiesToRetrieve.containsKey(VM_STORAGE_PROFILE_ASSIGNMENTS);
        ResultSet resultSet = new ResultSet();
        if (propertiesToRetrieve.isEmpty()) {
            resultSet.items = new ResultItem[0];
            return resultSet;
        }
        try {
            vmSpbmProperties = this.getVmSpbmProperties(objects, retrieveAssignments);
        }
        catch (Exception ex) {
            return this.createErrorResult(ex);
        }
        resultSet.items = new ResultItem[vmSpbmProperties.size()];
        for (int i = 0; i < vmSpbmProperties.size(); ++i) {
            resultSet.items[i] = this.newResultItem(vmSpbmProperties.get(i), propertiesToRetrieve);
        }
        return resultSet;
    }

    private ResultItem newResultItem(VmSpbmProperties vmSpbmProperties, Map<String, Object> propertiesToRetrieve) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = vmSpbmProperties.vm;
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        if (propertiesToRetrieve.containsKey(VM_STORAGE_PROFILE_ASSIGNMENTS)) {
            propertyValues.add(this.createPropValue(VM_STORAGE_PROFILE_ASSIGNMENTS, vmSpbmProperties.assignments, vmSpbmProperties.vm));
        }
        if (propertiesToRetrieve.containsKey(VM_SPBM_PROFILE_MISMATCH)) {
            PropertyValue propertyValue = this.createPropValue(VM_SPBM_PROFILE_MISMATCH, false, vmSpbmProperties.vm);
            if (vmSpbmProperties.rollupComplianceResult != null) {
                propertyValue.value = vmSpbmProperties.rollupComplianceResult.profileMismatch;
            }
            propertyValues.add(propertyValue);
        }
        if (propertiesToRetrieve.containsKey(VM_COMPL_STATUS_EX)) {
            propertyValues.add(this.createPropValue(VM_COMPL_STATUS_EX, vmSpbmProperties.getCopmlianceStatusEx(), vmSpbmProperties.vm));
        }
        if (propertiesToRetrieve.containsKey(VM_COMPL_STATUS_LABEL)) {
            propertyValues.add(this.createPropValue(VM_COMPL_STATUS_LABEL, vmSpbmProperties.getLocalizedComplianceStatusLabel(), vmSpbmProperties.vm));
        }
        if (propertiesToRetrieve.containsKey(VM_COMPL_STATUS_EX_FOR_PROFILE)) {
            propertyValues.add(this.createPropValue(VM_COMPL_STATUS_EX_FOR_PROFILE, this.getComplianceStatusLabelForProfile(vmSpbmProperties, propertiesToRetrieve.get(VM_COMPL_STATUS_EX_FOR_PROFILE)), vmSpbmProperties.vm));
        }
        if (propertiesToRetrieve.containsKey(VM_LAST_CHECKED_DATE_FOR_PROFILE)) {
            propertyValues.add(this.createPropValue(VM_LAST_CHECKED_DATE_FOR_PROFILE, this.getLastCheckedDateForProfile(vmSpbmProperties, propertiesToRetrieve.get(VM_LAST_CHECKED_DATE_FOR_PROFILE)), vmSpbmProperties.vm));
        }
        resultItem.properties = propertyValues.toArray(new PropertyValue[propertyValues.size()]);
        return resultItem;
    }

    private String getComplianceStatusLabelForProfile(VmSpbmProperties vmSpbmProperties, Object profileId) {
        if (profileId instanceof ProfileId && vmSpbmProperties.rollupComplianceResult != null && vmSpbmProperties.rollupComplianceResult.result != null) {
            String vmComplianceStatus = null;
            ProfileId profileIdParam = (ProfileId)profileId;
            for (ComplianceResult complianceResult : vmSpbmProperties.rollupComplianceResult.result) {
                String complianceStatus;
                if (!PbmUtil.areProfileIdsEqual(profileIdParam, complianceResult.profile)) continue;
                String string = complianceStatus = complianceResult.mismatch ? OUT_OF_DATE_STATUS : complianceResult.complianceStatus;
                if (vmComplianceStatus == null) {
                    vmComplianceStatus = complianceStatus;
                    continue;
                }
                if (VmProfileAssignmentPropertyProviderAdapter.getComplianceStatusPriority(complianceStatus) <= VmProfileAssignmentPropertyProviderAdapter.getComplianceStatusPriority(vmComplianceStatus)) continue;
                vmComplianceStatus = complianceStatus;
            }
            return vmComplianceStatus;
        }
        return "";
    }

    private String getLastCheckedDateForProfile(VmSpbmProperties vmSpbmProperties, Object profileId) {
        if (profileId instanceof ProfileId && vmSpbmProperties.rollupComplianceResult != null && vmSpbmProperties.rollupComplianceResult.result != null) {
            ProfileId profileIdParam = (ProfileId)profileId;
            Calendar oldestCheckTime = null;
            for (ComplianceResult complianceResult : vmSpbmProperties.rollupComplianceResult.result) {
                if (!PbmUtil.areProfileIdsEqual(profileIdParam, complianceResult.profile)) continue;
                if (oldestCheckTime == null) {
                    oldestCheckTime = complianceResult.checkTime;
                    continue;
                }
                if (complianceResult.checkTime == null || oldestCheckTime.compareTo(complianceResult.checkTime) >= 0) continue;
                oldestCheckTime = complianceResult.checkTime;
            }
            if (oldestCheckTime != null) {
                return FormatUtil.getDateTimeFormatted(oldestCheckTime);
            }
        }
        return "";
    }

    private Map<String, Object> getPropertiesToRetrieve(PropertySpec[] propertySpecArray) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (propertySpecArray == null) {
            return result;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            if (propertySpec.parameters != null) {
                for (ParameterSpec parameterSpec : propertySpec.parameters) {
                    if (parameterSpec.propertyName == null) continue;
                    parameters.put(parameterSpec.propertyName, this.getPropertyParameterValue(parameterSpec));
                }
            }
            for (String string : propertySpec.propertyNames) {
                if (!ArrayUtil.contains((Object)string, (Object[])SUPPORTED_PROPERTIES).booleanValue()) continue;
                result.put(string, parameters.get(string));
            }
        }
        return result;
    }

    private Object getPropertyParameterValue(ParameterSpec parameterSpec) {
        if (VM_COMPL_STATUS_EX_FOR_PROFILE.equals(parameterSpec.propertyName) || VM_LAST_CHECKED_DATE_FOR_PROFILE.equals(parameterSpec.propertyName)) {
            if (parameterSpec.parameter instanceof String) {
                URI profileUri = (URI)this._objectReferenceService.getReference((String)parameterSpec.parameter, true);
                return ManagedUtil.uriToProfileId(profileUri);
            }
            if (parameterSpec.parameter instanceof URI) {
                return ManagedUtil.uriToProfileId((URI)parameterSpec.parameter);
            }
        }
        return parameterSpec.parameter;
    }

    private ArrayList<VmSpbmProperties> getVmSpbmProperties(Object[] vms, boolean populateProfileAssignments) throws Exception {
        try {
            ArrayList<VmSpbmProperties> result = new ArrayList<VmSpbmProperties>();
            Map<String, ArrayList<ManagedObjectReference>> vmsByGuid = ManagedUtil.groupMoRefsByVcGuid(vms);
            if (vmsByGuid.size() == 0) {
                return result;
            }
            for (String vcGuid : vmsByGuid.keySet()) {
                PbmService service = PbmSessionUtil.getService(vcGuid, this._pbmServiceFactory);
                ManagedObjectReference[] vmRefs = vmsByGuid.get(vcGuid).toArray(new ManagedObjectReference[0]);
                this.addVmSpbmPropertiesToResults(service, vmRefs, result, populateProfileAssignments);
            }
            return result;
        }
        catch (PbmServiceUnableToConnectException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
        catch (ExecutionException ex) {
            _logger.error((Object)"Failed to retrieve VmStorageRollupComplianceResult: ", (Throwable)ex);
            throw PbmUtil.getMethodFault(ex);
        }
    }

    private void addVmSpbmPropertiesToResults(PbmService service, ManagedObjectReference[] vmRefs, ArrayList<VmSpbmProperties> result, boolean populateProfileAssignments) throws Exception {
        RollupComplianceResult[] complResults = PbmUtil.getRollupComplianceResult(service, vmRefs);
        Hashtable<String, RollupComplianceResult> complResultsMap = new Hashtable<String, RollupComplianceResult>();
        if (complResults != null) {
            for (RollupComplianceResult complResult : complResults) {
                if (complResult.entity == null) continue;
                complResultsMap.put(complResult.entity.getKey(), complResult);
            }
        }
        Map<String, Profile> profilesMap = null;
        if (populateProfileAssignments) {
            profilesMap = PbmUtil.getProfilesFromRollupComplianceResult(service, complResults);
        }
        for (ManagedObjectReference vm : vmRefs) {
            VmStorageProfileAssignmentsData vmAssignmentsData = new VmStorageProfileAssignmentsData();
            vmAssignmentsData.vm = vm;
            RollupComplianceResult rollupComplianceResult = (RollupComplianceResult)complResultsMap.get(vm.getValue());
            if (populateProfileAssignments) {
                this.populateVmStorageProfileAssignments(profilesMap, rollupComplianceResult, vmAssignmentsData);
            }
            result.add(new VmSpbmProperties(vm, vmAssignmentsData, rollupComplianceResult));
        }
    }

    private void populateVmStorageProfileAssignments(Map<String, Profile> profilesMap, RollupComplianceResult rollupComplianceResult, VmStorageProfileAssignmentsData profileAssignmentsData) throws Exception {
        if (rollupComplianceResult == null || rollupComplianceResult.result == null) {
            profileAssignmentsData.diskAssignments = new VirtualDiskStorageProfileAssignmentData[0];
            return;
        }
        ArrayList<VirtualDiskStorageProfileAssignmentData> diskAssignments = new ArrayList<VirtualDiskStorageProfileAssignmentData>();
        for (ComplianceResult complianceResult : rollupComplianceResult.result) {
            if (complianceResult.profile == null) continue;
            if (ManagedUtil.isVirtualDisk(complianceResult.entity)) {
                VirtualDiskStorageProfileAssignmentData diskAssignment = new VirtualDiskStorageProfileAssignmentData();
                diskAssignment.diskId = complianceResult.entity.key;
                diskAssignment.profile = profilesMap.get(complianceResult.profile.uniqueId);
                diskAssignment.complianceResult = complianceResult;
                diskAssignments.add(diskAssignment);
                continue;
            }
            if (ManagedUtil.isVmHome(complianceResult.entity)) {
                profileAssignmentsData.homeStorageProfile = profilesMap.get(complianceResult.profile.uniqueId);
                profileAssignmentsData.homeComplianceResult = complianceResult;
                continue;
            }
            _logger.error((Object)("Unsupported ObjectType in RollupComplianceResult: " + complianceResult.entity.objectType));
        }
        profileAssignmentsData.diskAssignments = diskAssignments.toArray(new VirtualDiskStorageProfileAssignmentData[0]);
    }

    private ResultSet createErrorResult(Exception fault) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = fault;
        return resultSet;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private static int getComplianceStatusPriority(String compliance) {
        if (OUT_OF_DATE_STATUS.equals(compliance) || ComplianceResult.ComplianceStatus.outOfDate.toString().equals(compliance)) {
            return 500;
        }
        if (ComplianceResult.ComplianceStatus.nonCompliant.toString().equals(compliance)) {
            return 400;
        }
        if (ComplianceResult.ComplianceStatus.unknown.toString().equals(compliance)) {
            return 300;
        }
        if (ComplianceResult.ComplianceStatus.compliant.toString().equals(compliance)) {
            return 200;
        }
        if (ComplianceResult.ComplianceStatus.notApplicable.toString().equals(compliance)) {
            return 100;
        }
        return 0;
    }

    private class VmSpbmProperties {
        public VmStorageProfileAssignmentsData assignments;
        public RollupComplianceResult rollupComplianceResult;
        public ManagedObjectReference vm;

        public VmSpbmProperties(ManagedObjectReference vm, VmStorageProfileAssignmentsData vmAssignment, RollupComplianceResult rollupComplianceResult) {
            this.vm = vm;
            this.rollupComplianceResult = rollupComplianceResult;
            this.assignments = vmAssignment;
        }

        public String getCopmlianceStatusEx() {
            if (this.rollupComplianceResult == null) {
                return null;
            }
            if (this.rollupComplianceResult.profileMismatch) {
                return VmProfileAssignmentPropertyProviderAdapter.OUT_OF_DATE_STATUS;
            }
            return this.rollupComplianceResult.overallComplianceStatus;
        }

        public String getLocalizedComplianceStatusEx() {
            String complStatusEx = this.getCopmlianceStatusEx();
            if (complStatusEx != null && !complStatusEx.isEmpty()) {
                return PbmUtil.getLocalizedString("complianceStatus." + complStatusEx, new String[0]);
            }
            return PbmUtil.getLocalizedString("complianceStatus.none", new String[0]);
        }

        public String getLocalizedComplianceStatusLabel() {
            String formattedDate;
            String localizedComplStatus = this.getLocalizedComplianceStatusEx();
            if (this.rollupComplianceResult != null && this.rollupComplianceResult.oldestCheckTime != null && (formattedDate = FormatUtil.getDateTimeFormatted((Object)this.rollupComplianceResult.oldestCheckTime)) != null && !formattedDate.isEmpty()) {
                localizedComplStatus = PbmUtil.getLocalizedString("complianceStatusAndLastChecked.format", localizedComplStatus, formattedDate);
            }
            return localizedComplStatus;
        }
    }
}

