/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl.formatters;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vim.binding.pbm.capability.ConstraintInstance;
import com.vmware.vim.binding.pbm.capability.PropertyInstance;
import com.vmware.vim.binding.pbm.capability.PropertyMetadata;
import com.vmware.vim.binding.pbm.capability.TypeInfo;
import com.vmware.vim.binding.pbm.capability.provider.LineOfServiceInfo;
import com.vmware.vim.binding.pbm.capability.types.BuiltinGenericTypesEnum;
import com.vmware.vim.binding.pbm.capability.types.DiscreteSet;
import com.vmware.vim.binding.pbm.capability.types.Range;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.pbm.profile.SubProfileCapabilityConstraints;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.ProfileContentFormatter;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.profile.content.CategoryData;
import com.vmware.vsphere.client.spbm.data.profile.content.MessageItem;
import com.vmware.vsphere.client.spbm.data.profile.content.ProfileContent;
import com.vmware.vsphere.client.spbm.data.profile.content.PropertyData;
import com.vmware.vsphere.client.spbm.data.profile.content.SectionData;
import com.vmware.vsphere.client.spbm.impl.formatters.FormatterUtil;
import com.vmware.vsphere.client.spbm.util.MetadataUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import com.vmware.vsphere.client.spbm.util.RuleSetUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileContentFormatterImpl
implements ProfileContentFormatter {
    @Override
    public ProfileContent formatProfileContent(Profile profile, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> nestedProfilesMap, PbmService pbmService) {
        if (this.isDsp(profile)) {
            return this.formatDspContent(profile, namespaceMetadata);
        }
        ArrayList<SectionData> profileSections = new ArrayList<SectionData>();
        profileSections.add(this.createGeneralSection(profile.name, profile.description));
        if (profile instanceof CapabilityBasedProfile) {
            CapabilityBasedProfile capabilityProfile = (CapabilityBasedProfile)profile;
            if (capabilityProfile.constraints != null && capabilityProfile.constraints instanceof SubProfileCapabilityConstraints) {
                profileSections.addAll(this.getProfileRuleSetSections((SubProfileCapabilityConstraints)capabilityProfile.constraints, namespaceMetadata, nestedProfilesMap, pbmService));
            }
        }
        return ProfileContent.newInstance(profileSections);
    }

    private boolean isDsp(Profile profile) {
        if (profile instanceof CapabilityBasedProfile) {
            return CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY.toString().equals(((CapabilityBasedProfile)profile).profileCategory);
        }
        return false;
    }

    private ProfileContent formatDspContent(Profile profile, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        FormatResult formatResult = new FormatResult();
        CategoryData profileContent = this.getDataServiceCategoryContent(null, false, profile, namespaceMetadata, formatResult);
        SectionData sectionData = SectionData.newInstance(null, profileContent);
        if (formatResult.hasMissingMetadata) {
            sectionData.messages = new MessageItem[]{MessageItem.newWarning(PbmUtil.getLocalizedString("profile.content.missingMetadataWarning", new String[0]))};
        }
        return ProfileContent.newInstance(Arrays.asList(sectionData));
    }

    private List<SectionData> getProfileRuleSetSections(SubProfileCapabilityConstraints subProfileCapabilityConstraints, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> nestedProfilesMap, PbmService pbmService) {
        ArrayList<SectionData> ruleSetSections = new ArrayList<SectionData>();
        if (subProfileCapabilityConstraints.subProfiles == null) {
            return ruleSetSections;
        }
        List<SubProfileCapabilityConstraints.SubProfile> normalizedSubProfiles = FormatterUtil.getNormalizedSubProfiles(subProfileCapabilityConstraints.subProfiles, namespaceMetadata, nestedProfilesMap, pbmService.isFeatureSupported("dataService"));
        for (SubProfileCapabilityConstraints.SubProfile subProfile : normalizedSubProfiles) {
            FormatResult formatResult = new FormatResult();
            ArrayList<CategoryData> subProfileCategories = new ArrayList<CategoryData>();
            if (pbmService.isFeatureSupported("dataService")) {
                List<CapabilityGroup> capabilityGroups = this.groupCapabilitiesByLineOfService(subProfile.capability, namespaceMetadata, nestedProfilesMap, formatResult);
                for (CapabilityGroup capabilityGroup : capabilityGroups) {
                    CategoryData capabilityGroupContent = this.getCapabilityCategoryContent(capabilityGroup, namespaceMetadata, nestedProfilesMap, formatResult);
                    if (capabilityGroupContent == null) continue;
                    subProfileCategories.add(capabilityGroupContent);
                }
            } else {
                List<PropertyData> capabilityContent = this.getSubProfileCapabilities(subProfile, namespaceMetadata, formatResult);
                subProfileCategories.add(CategoryData.newInstance(null, false, capabilityContent));
            }
            SectionData subProfileContent = SectionData.newInstance(subProfile.name, subProfileCategories);
            if (formatResult.hasMissingMetadata) {
                subProfileContent.messages = new MessageItem[]{MessageItem.newWarning(PbmUtil.getLocalizedString("profile.content.missingMetadataWarning", new String[0]))};
            }
            ruleSetSections.add(subProfileContent);
        }
        return ruleSetSections;
    }

    private List<PropertyData> getSubProfileCapabilities(SubProfileCapabilityConstraints.SubProfile subProfile, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, FormatResult formatResult) {
        ArrayList<PropertyData> capabilityContent = new ArrayList<PropertyData>();
        if (subProfile.capability != null) {
            for (CapabilityInstance capabilityInstance : subProfile.capability) {
                PropertyData propertyData = this.getCapabilityContent(capabilityInstance, namespaceMetadata, formatResult);
                if (propertyData == null) continue;
                capabilityContent.add(propertyData);
            }
        }
        return capabilityContent;
    }

    private List<CapabilityGroup> groupCapabilitiesByLineOfService(CapabilityInstance[] capabilityInstances, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> nestedProfilesMap, FormatResult formatResult) {
        ArrayList<CapabilityGroup> capabilityGroups = new ArrayList<CapabilityGroup>();
        HashMap<String, CapabilityGroup> capabilityGroupsIndex = new HashMap<String, CapabilityGroup>();
        if (capabilityInstances != null) {
            for (CapabilityInstance capabilityInstance : capabilityInstances) {
                String namespaceLineOfService;
                if ("http://www.vmware.com/storage/tag".equals(capabilityInstance.id.namespace)) {
                    namespaceLineOfService = LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString();
                } else {
                    NamespaceCapabilityMetadata capabilityNamespace = FormatterUtil.getCapabilityInstanceNamespaceMetadata(namespaceMetadata, nestedProfilesMap, capabilityInstance);
                    if (capabilityNamespace == null) {
                        formatResult.hasMissingMetadata = true;
                        continue;
                    }
                    namespaceLineOfService = MetadataUtil.getNamespaceLineOfService(capabilityNamespace);
                    if (namespaceLineOfService == null) {
                        formatResult.hasMissingMetadata = true;
                        continue;
                    }
                }
                if (!capabilityGroupsIndex.containsKey(namespaceLineOfService)) {
                    CapabilityGroup capabilityGroup = new CapabilityGroup(namespaceLineOfService);
                    capabilityGroups.add(capabilityGroup);
                    capabilityGroupsIndex.put(namespaceLineOfService, capabilityGroup);
                }
                ((CapabilityGroup)capabilityGroupsIndex.get(namespaceLineOfService)).addCapabilityInstance(capabilityInstance);
            }
        }
        return capabilityGroups;
    }

    private CategoryData getCapabilityCategoryContent(CapabilityGroup capabilityGroup, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, Map<String, Profile> nestedProfilesMap, FormatResult formatResult) {
        if (capabilityGroup.isDataServiceReference()) {
            Profile dataServiceProfile = nestedProfilesMap.get(capabilityGroup.capabilityInstances.get((int)0).id.id);
            if (dataServiceProfile == null) {
                formatResult.hasMissingMetadata = true;
                return null;
            }
            return this.getDataServiceCategoryContent(this.getDataServiceCategoryHeader(capabilityGroup.lineOfService, dataServiceProfile.name), true, dataServiceProfile, namespaceMetadata, formatResult);
        }
        String localizedLineOfService = FormatterUtil.getLocalizedLineOfService(capabilityGroup.lineOfService);
        String customCategoryHeader = LineOfServiceInfo.LineOfServiceEnum.PERSISTENCE.toString().equals(capabilityGroup.lineOfService) ? localizedLineOfService : PbmUtil.getLocalizedString("profile.content.category.header", localizedLineOfService, PbmUtil.getLocalizedString("profile.content.category.customLabel", new String[0]));
        ArrayList<PropertyData> customCategoryProperties = new ArrayList<PropertyData>();
        String vendorNamespace = capabilityGroup.getCapabilitiesVendorNamespace();
        if (vendorNamespace != null && namespaceMetadata.containsKey(vendorNamespace)) {
            String localizedNamespace = MetadataUtil.getLocalizedNamespaceTitle(namespaceMetadata.get(vendorNamespace));
            customCategoryProperties.add(PropertyData.newInstance(FormatterUtil.getProviderLabel(capabilityGroup.lineOfService), localizedNamespace));
        }
        for (CapabilityInstance capabilityInstance : capabilityGroup.capabilityInstances) {
            PropertyData propertyData = this.getCapabilityContent(capabilityInstance, namespaceMetadata, formatResult);
            if (propertyData == null) continue;
            customCategoryProperties.add(propertyData);
        }
        return CategoryData.newInstance(customCategoryHeader, true, customCategoryProperties);
    }

    private String getDataServiceCategoryHeader(String lineOfService, String profileName) {
        return PbmUtil.getLocalizedString("profile.content.category.header", FormatterUtil.getLocalizedLineOfService(lineOfService), profileName);
    }

    private CategoryData getDataServiceCategoryContent(String categoryHeader, boolean collapsable, Profile dataServiceProfile, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, FormatResult formatResult) {
        ArrayList<PropertyData> profileProperties = new ArrayList<PropertyData>();
        profileProperties.add(PropertyData.newInstance(PbmUtil.getLocalizedString("profile.content.general.name", new String[0]), dataServiceProfile.name));
        profileProperties.add(PropertyData.newInstance(PbmUtil.getLocalizedString("profile.content.general.description", new String[0]), dataServiceProfile.description));
        SubProfileCapabilityConstraints.SubProfile subProfile = RuleSetUtil.getFirstSubProfile(dataServiceProfile);
        String dataServiceProfileNamespace = RuleSetUtil.getSubProfileVendorNamespace(subProfile);
        if (subProfile != null && namespaceMetadata.containsKey(dataServiceProfileNamespace)) {
            String localizedNamespace = MetadataUtil.getLocalizedNamespaceTitle(namespaceMetadata.get(dataServiceProfileNamespace));
            profileProperties.add(PropertyData.newInstance(PbmUtil.getLocalizedString("profile.content.category.providerLabel", new String[0]), localizedNamespace));
            profileProperties.addAll(this.getSubProfileCapabilities(subProfile, namespaceMetadata, formatResult));
        } else {
            formatResult.hasMissingMetadata = true;
        }
        return CategoryData.newInstance(categoryHeader, collapsable, profileProperties);
    }

    private PropertyData getCapabilityContent(CapabilityInstance capabilityInstance, Map<String, NamespaceCapabilityMetadata> namespaceMetadata, FormatResult formatResult) {
        String capabilityTitle;
        if (capabilityInstance == null || capabilityInstance.constraint == null || capabilityInstance.constraint.length == 0) {
            return null;
        }
        NamespaceCapabilityMetadata capabilityNamespace = namespaceMetadata.get(capabilityInstance.id.namespace);
        CapabilityMetadata capabilityMetadata = null;
        if (capabilityNamespace != null) {
            capabilityMetadata = MetadataUtil.getCapabilityMetadata(capabilityNamespace.capabilityMetadata, capabilityInstance.id);
        }
        if ("http://www.vmware.com/storage/tag".equals(capabilityInstance.id.namespace)) {
            return this.getTagCapabilityContent(capabilityInstance, capabilityMetadata);
        }
        if (capabilityMetadata == null) {
            formatResult.hasMissingMetadata = true;
            return null;
        }
        boolean hasMultipleNestedProperties = RuleSetUtil.hasMultipleNestedProperties(capabilityMetadata);
        if (hasMultipleNestedProperties || capabilityMetadata.propertyMetadata == null || capabilityMetadata.propertyMetadata.length == 0) {
            capabilityTitle = FormatterUtil.getCapabilityLabel(capabilityMetadata);
        } else {
            PropertyMetadata propertyMetadata = capabilityMetadata.propertyMetadata[0];
            capabilityTitle = FormatterUtil.getPropertyMetadataLabel(propertyMetadata);
        }
        ArrayList<String> formattedPropertyValues = new ArrayList<String>();
        ArrayList<PropertyData> formattedNestedProperties = new ArrayList<PropertyData>();
        for (ConstraintInstance constraintInstance : capabilityInstance.constraint) {
            for (PropertyInstance propertyInstance : constraintInstance.propertyInstance) {
                if (propertyInstance.value == null) continue;
                PropertyMetadata propertyMetadata = MetadataUtil.getPropertyMetadata(capabilityMetadata.propertyMetadata, propertyInstance.id);
                if (propertyMetadata == null) {
                    formatResult.hasMissingMetadata = true;
                    return null;
                }
                List<String> formattedValues = "VSAN".equals(capabilityInstance.id.namespace) && "cacheReservation".equals(capabilityInstance.id.id) ? this.getVsanCacheReservationProperty(propertyInstance, propertyMetadata) : this.getPropertyValue(propertyInstance, propertyMetadata);
                if (hasMultipleNestedProperties) {
                    formattedNestedProperties.add(PropertyData.newInstance(FormatterUtil.getPropertyMetadataLabel(propertyMetadata), formattedValues));
                    continue;
                }
                formattedPropertyValues.addAll(formattedValues);
            }
        }
        if (hasMultipleNestedProperties) {
            return PropertyData.newInstanceWithNestedProperties(capabilityTitle, formattedNestedProperties);
        }
        return PropertyData.newInstance(capabilityTitle, formattedPropertyValues);
    }

    private List<String> getVsanCacheReservationProperty(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata) {
        String formattedValue = FormatterUtil.getVsanCacheReservationPropertyValue(propertyInstance);
        if (formattedValue != null) {
            return Collections.singletonList(formattedValue);
        }
        return this.getPropertyValue(propertyInstance, propertyMetadata);
    }

    private List<String> getPropertyValue(PropertyInstance propertyInstance, PropertyMetadata propertyMetadata) {
        ArrayList<String> result = new ArrayList<String>();
        if (RuleSetUtil.hasGenericValue(propertyInstance, propertyMetadata)) {
            String genericTypeName = RuleSetUtil.getGenericTypeName(propertyMetadata);
            if (BuiltinGenericTypesEnum.VMW_RANGE.toString().equals(genericTypeName)) {
                DiscreteSet allowedValues = MetadataUtil.tryGetAllowedValueAsSet(propertyMetadata);
                Range range = (Range)propertyInstance.value;
                String formattedMinValue = FormatterUtil.getPropertyValue(range.min, propertyMetadata.type, allowedValues, false);
                String formattedMaxValue = FormatterUtil.getPropertyValue(range.max, propertyMetadata.type, allowedValues, false);
                result.add(PbmUtil.getLocalizedString("profile.content.range.minLabel", formattedMinValue));
                result.add(PbmUtil.getLocalizedString("profile.content.range.maxLabel", formattedMaxValue));
                return result;
            }
            if (BuiltinGenericTypesEnum.VMW_SET.toString().equals(genericTypeName)) {
                DiscreteSet set = (DiscreteSet)propertyInstance.value;
                DiscreteSet allowedValues = MetadataUtil.tryGetAllowedValueAsSet(propertyMetadata);
                return FormatterUtil.getDiscreteSetValues(set, allowedValues, propertyMetadata.type, false);
            }
            return result;
        }
        TypeInfo typeInfo = propertyMetadata.type;
        DiscreteSet allowedValues = MetadataUtil.tryGetAllowedValueAsSet(propertyMetadata);
        result.add(FormatterUtil.getPropertyValue(propertyInstance.value, typeInfo, allowedValues, false));
        return result;
    }

    private PropertyData getTagCapabilityContent(CapabilityInstance capabilityInstance, CapabilityMetadata capabilityMetadata) {
        String capabilityName = "";
        ArrayList<String> tagValues = new ArrayList<String>();
        for (ConstraintInstance constraintInstance : capabilityInstance.constraint) {
            if (constraintInstance == null || constraintInstance.propertyInstance == null) continue;
            for (PropertyInstance propertyInstance : constraintInstance.propertyInstance) {
                if (propertyInstance == null || propertyInstance.value == null || !(propertyInstance.value instanceof DiscreteSet)) continue;
                PropertyMetadata propertyMetadata = null;
                if (capabilityMetadata != null) {
                    propertyMetadata = MetadataUtil.getPropertyMetadata(capabilityMetadata.propertyMetadata, propertyInstance.id);
                }
                capabilityName = FormatterUtil.getTagCapabilityLabel(propertyMetadata, propertyInstance);
                List<String> formattedTagValues = FormatterUtil.getTagValues(propertyInstance, propertyMetadata);
                tagValues.addAll(formattedTagValues);
            }
        }
        if (capabilityName != null && !tagValues.isEmpty()) {
            return PropertyData.newInstance(capabilityName, tagValues);
        }
        return null;
    }

    private SectionData createGeneralSection(String profileName, String profileDescription) {
        return SectionData.newInstance(PbmUtil.getLocalizedString("profile.content.general", new String[0]), CategoryData.newInstance(null, false, PropertyData.newInstance(PbmUtil.getLocalizedString("profile.content.general.name", new String[0]), profileName), PropertyData.newInstance(PbmUtil.getLocalizedString("profile.content.general.description", new String[0]), profileDescription)));
    }

    private static class CapabilityGroup {
        String lineOfService;
        List<CapabilityInstance> capabilityInstances;

        void addCapabilityInstance(CapabilityInstance capabilityInstance) {
            this.capabilityInstances.add(capabilityInstance);
        }

        String getCapabilitiesVendorNamespace() {
            for (CapabilityInstance capabilityInstance : this.capabilityInstances) {
                if (!MetadataUtil.isVendorNamespace(capabilityInstance.id.namespace)) continue;
                return capabilityInstance.id.namespace;
            }
            return null;
        }

        boolean isDataServiceReference() {
            return this.capabilityInstances.size() == 1 && MetadataUtil.isDataServiceReferenceCapability(this.capabilityInstances.get(0));
        }

        CapabilityGroup(String lineOfService) {
            this.lineOfService = lineOfService;
            this.capabilityInstances = new ArrayList<CapabilityInstance>();
        }
    }

    private static class FormatResult {
        boolean hasMissingMetadata;

        private FormatResult() {
        }
    }
}

