/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.pbm.ServerObjectRef;
import com.vmware.vim.binding.pbm.profile.CapabilityBasedProfile;
import com.vmware.vim.binding.pbm.profile.ProfileId;
import com.vmware.vim.binding.pbm.profile.ResourceType;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class ManagedUtil {
    public static final String VM_TYPE = "VirtualMachine";
    public static final String DATASTORE_TYPE = "Datastore";
    public static final String TASK_TYPE = "Task";
    public static final String STORAGE_POD_TYPE = "StoragePod";
    public static final String STORAGE_RESOURCE_TYPE = "STORAGE";
    public static final String COMPUTE_RESOURCE_TYPE = "COMPUTE";
    public static final String NETWORKING_RESOURCE_TYPE = "NETWORKING";
    public static final String STORAGE_PBM_REQUIREMENT_PROFILE_TYPE = "PbmRequirementStorageProfile";
    public static final String COMPUTE_PBM_REQUIREMENT_PROFILE_TYPE = "PbmRequirementComputeProfile";
    public static final String NETWORK_PBM_REQUIREMENT_PROFILE_TYPE = "PbmRequirementNetworkProfile";
    public static final String STORAGE_PBM_CAPABILITY_PROFILE_TYPE = "PbmCapabilityStorageProfile";
    public static final String COMPUTE_PBM_CAPABILITY_PROFILE_TYPE = "PbmCapabilityComputeProfile";
    public static final String NETWORK_PBM_CAPABILITY_PROFILE_TYPE = "PbmCapabilityNetworkProfile";
    public static final String STORAGE_PBM_DATA_SERVICE_PROFILE_TYPE = "PbmDataServiceStorageProfile";
    public static final int PROFILE_UID_INDEX = 0;
    public static final int PROFILE_TYPE_ID_INDEX = 1;
    public static final int PROFILE_VC_SCOPE_INDEX = 2;
    private static final String VIRTUAL_CENTER_TYPE = "Folder";
    private static final String VIRTUAL_CENTER_VALUE = "group-d1";

    public static boolean isProfileObject(Object object) {
        if (object instanceof URI) {
            String uriType = QueryUtil.getReferenceType((Object)object);
            return uriType != null && (STORAGE_PBM_CAPABILITY_PROFILE_TYPE.equals(uriType) || STORAGE_PBM_REQUIREMENT_PROFILE_TYPE.equals(uriType) || COMPUTE_PBM_CAPABILITY_PROFILE_TYPE.equals(uriType) || COMPUTE_PBM_REQUIREMENT_PROFILE_TYPE.equals(uriType) || NETWORK_PBM_CAPABILITY_PROFILE_TYPE.equals(uriType) || NETWORK_PBM_REQUIREMENT_PROFILE_TYPE.equals(uriType) || STORAGE_PBM_DATA_SERVICE_PROFILE_TYPE.equals(uriType));
        }
        return false;
    }

    public static String getProfileType(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory) {
        if (STORAGE_RESOURCE_TYPE.equals(resourceType.resourceType)) {
            if (CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.equals((Object)profileCategory)) {
                return STORAGE_PBM_REQUIREMENT_PROFILE_TYPE;
            }
            if (CapabilityBasedProfile.ProfileCategoryEnum.RESOURCE.equals((Object)profileCategory)) {
                return STORAGE_PBM_CAPABILITY_PROFILE_TYPE;
            }
            if (CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY.equals((Object)profileCategory)) {
                return STORAGE_PBM_DATA_SERVICE_PROFILE_TYPE;
            }
        } else if (COMPUTE_RESOURCE_TYPE.equals(resourceType.resourceType)) {
            if (CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.equals((Object)profileCategory)) {
                return COMPUTE_PBM_REQUIREMENT_PROFILE_TYPE;
            }
            if (CapabilityBasedProfile.ProfileCategoryEnum.RESOURCE.equals((Object)profileCategory)) {
                return COMPUTE_PBM_CAPABILITY_PROFILE_TYPE;
            }
        } else if (NETWORKING_RESOURCE_TYPE.equals(resourceType.resourceType)) {
            if (CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT.equals((Object)profileCategory)) {
                return NETWORK_PBM_REQUIREMENT_PROFILE_TYPE;
            }
            if (CapabilityBasedProfile.ProfileCategoryEnum.RESOURCE.equals((Object)profileCategory)) {
                return NETWORK_PBM_CAPABILITY_PROFILE_TYPE;
            }
        }
        return "";
    }

    public static ResourceType getResourceTypeByProfileType(String profileType) {
        ResourceType rt = new ResourceType();
        if (STORAGE_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType) || STORAGE_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType) || STORAGE_PBM_DATA_SERVICE_PROFILE_TYPE.equals(profileType)) {
            rt.resourceType = STORAGE_RESOURCE_TYPE;
        } else if (COMPUTE_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType) || COMPUTE_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType)) {
            rt.resourceType = COMPUTE_RESOURCE_TYPE;
        } else if (NETWORK_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType) || NETWORK_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType)) {
            rt.resourceType = NETWORKING_RESOURCE_TYPE;
        }
        return rt;
    }

    public static CapabilityBasedProfile.ProfileCategoryEnum getProfileCategory(String profileType) {
        if (STORAGE_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType) || NETWORK_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType) || COMPUTE_PBM_CAPABILITY_PROFILE_TYPE.equals(profileType)) {
            return CapabilityBasedProfile.ProfileCategoryEnum.RESOURCE;
        }
        if (STORAGE_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType) || NETWORK_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType) || COMPUTE_PBM_REQUIREMENT_PROFILE_TYPE.equals(profileType)) {
            return CapabilityBasedProfile.ProfileCategoryEnum.REQUIREMENT;
        }
        if (STORAGE_PBM_DATA_SERVICE_PROFILE_TYPE.equals(profileType)) {
            return CapabilityBasedProfile.ProfileCategoryEnum.DATA_SERVICE_POLICY;
        }
        return null;
    }

    public static ResourceType getResourceTypeByUri(URI profile) {
        String profileType = ManagedUtil.getProfileTypeByUri(profile);
        return ManagedUtil.getResourceTypeByProfileType(profileType);
    }

    public static String getProfileTypeByUri(URI profile) {
        return DefaultUriSchemeUtil.getType((URI)profile);
    }

    public static URI buildProfileUri(ResourceType resourceType, CapabilityBasedProfile.ProfileCategoryEnum profileCategory, String vcServiceGuid, ProfileId profileId) {
        return DefaultUriSchemeUtil.createUri((String)ManagedUtil.getProfileType(resourceType, profileCategory), (String[])new String[]{profileId.uniqueId, resourceType.resourceType, vcServiceGuid});
    }

    public static String getVcGuid(URI profileUri) {
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)profileUri);
        return segments[2];
    }

    public static ProfileId uriToProfileId(URI profileUri) {
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)profileUri);
        ProfileId result = new ProfileId();
        result.uniqueId = segments[0];
        return result;
    }

    public static String getProfileUid(URI profileUri) {
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)profileUri);
        if (segments.length > 0) {
            return segments[0];
        }
        return null;
    }

    public static ManagedObjectReference serverObjectRefToManagedObjectRef(ServerObjectRef soRef, String serverGuid) {
        return ManagedUtil.buildMoRef(soRef.getKey(), ManagedUtil.soRefTypeToMoRefType(soRef.getObjectType()), serverGuid);
    }

    public static ServerObjectRef managedObjectRefToServerObjectRef(ManagedObjectReference moRef) {
        ServerObjectRef soRef = new ServerObjectRef();
        soRef.key = moRef.getValue();
        soRef.objectType = ManagedUtil.moRefTypeToSoRefType(moRef.getType());
        return soRef;
    }

    public static ServerObjectRef[] managedObjectRefToServerObjectRef(ManagedObjectReference[] moRefs) {
        ServerObjectRef[] result = new ServerObjectRef[moRefs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ManagedUtil.managedObjectRefToServerObjectRef(moRefs[i]);
        }
        return result;
    }

    public static ManagedObjectReference[] filterMoRefByType(ManagedObjectReference[] moRefsToFilter, String typeToFilter) {
        if (moRefsToFilter == null) {
            return null;
        }
        if (typeToFilter == null) {
            return new ManagedObjectReference[0];
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference moRef : moRefsToFilter) {
            if (moRef == null || !typeToFilter.equals(moRef.getType())) continue;
            result.add(moRef);
        }
        return result.toArray(new ManagedObjectReference[0]);
    }

    public static String moRefTypeToSoRefType(String moRefType) {
        if (VM_TYPE.equals(moRefType)) {
            return ServerObjectRef.ObjectType.virtualMachine.toString();
        }
        if (DATASTORE_TYPE.equals(moRefType)) {
            return ServerObjectRef.ObjectType.datastore.toString();
        }
        return moRefType;
    }

    public static String soRefTypeToMoRefType(String soRefType) {
        if (ServerObjectRef.ObjectType.virtualMachine.toString().equals(soRefType)) {
            return VM_TYPE;
        }
        if (ServerObjectRef.ObjectType.datastore.toString().equals(soRefType)) {
            return DATASTORE_TYPE;
        }
        return soRefType;
    }

    public static boolean isVirtualDisk(ServerObjectRef soRef) {
        return soRef != null && ServerObjectRef.ObjectType.virtualDiskId.toString().equals(soRef.objectType);
    }

    public static boolean isVmHome(ServerObjectRef soRef) {
        return soRef != null && ServerObjectRef.ObjectType.virtualMachine.toString().equals(soRef.objectType);
    }

    public static ManagedObjectReference serverObjectRefToVmMor(ServerObjectRef soRef, String vcGuid) {
        if (soRef == null) {
            return null;
        }
        if (ManagedUtil.isVmHome(soRef)) {
            return ManagedUtil.serverObjectRefToManagedObjectRef(soRef, vcGuid);
        }
        if (ManagedUtil.isVirtualDisk(soRef)) {
            String[] diskArtifacts = soRef.key.split(":");
            if (diskArtifacts.length != 2) {
                return null;
            }
            return ManagedUtil.buildMoRef(diskArtifacts[0], VM_TYPE, vcGuid);
        }
        return null;
    }

    public static ServerObjectRef vmObjectIdToServerObjectRef(String vmObjectId, String vcGuid) {
        if (vmObjectId == null) {
            return null;
        }
        ServerObjectRef result = new ServerObjectRef();
        result.key = vmObjectId;
        result.serverUuid = vcGuid;
        result.objectType = vmObjectId.indexOf(":") >= 0 ? ServerObjectRef.ObjectType.virtualDiskId.toString() : ServerObjectRef.ObjectType.virtualMachine.toString();
        return result;
    }

    public static ProfileId[] uriListToProfileId(List<URI> profileUri) {
        if (profileUri == null || profileUri.size() == 0) {
            return new ProfileId[0];
        }
        ProfileId[] result = new ProfileId[profileUri.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ManagedUtil.uriToProfileId(profileUri.get(i));
        }
        return result;
    }

    public static Map<String, List<URI>> getProfilesByServerGuid(URI[] profileURIs) {
        HashMap<String, List<URI>> map = new HashMap<String, List<URI>>();
        if (profileURIs == null) {
            return map;
        }
        for (URI uri : profileURIs) {
            String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)uri);
            String serverGuid = segments[2];
            if (!map.containsKey(serverGuid)) {
                map.put(serverGuid, new ArrayList());
            }
            List list = (List)map.get(serverGuid);
            list.add(uri);
        }
        return map;
    }

    public static ManagedObjectReference buildVcMoRef(String serverGuid) {
        return ManagedUtil.buildMoRef(VIRTUAL_CENTER_VALUE, VIRTUAL_CENTER_TYPE, serverGuid);
    }

    public static ManagedObjectReference buildMoRef(String value, String type, String serverGuid) {
        ManagedObjectReference moRef = new ManagedObjectReference(type, value, serverGuid);
        return moRef;
    }

    public static Map<String, ArrayList<ManagedObjectReference>> groupMoRefsByVcGuid(Object[] moRefs) {
        Hashtable<String, ArrayList<ManagedObjectReference>> result = new Hashtable<String, ArrayList<ManagedObjectReference>>();
        if (moRefs == null || moRefs.length == 0) {
            return result;
        }
        for (int i = 0; i < moRefs.length; ++i) {
            if (!(moRefs[i] instanceof ManagedObjectReference)) continue;
            ManagedObjectReference moRef = (ManagedObjectReference)moRefs[i];
            String vcGuid = moRef.getServerGuid();
            if (!result.containsKey(vcGuid)) {
                result.put(vcGuid, new ArrayList());
            }
            result.get(vcGuid).add(moRef);
        }
        return result;
    }
}

