/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.folder.FolderInfo;
import com.vmware.vsphere.client.folder.FolderRemovalSpec;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(FolderMutationProvider.class);
    private static final String RESOURCE_BUNDLE_NAME = "FolderService";
    private DataService _dataService;

    public FolderMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult add(FolderInfo spec) {
        Validate.notNull((Object)((Object)spec));
        Validate.notNull((Object)spec.name);
        OperationResult opResult = new OperationResult();
        try {
            Folder folder = this.getParentFolder(spec);
            String escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            ManagedObjectReference newFolder = folder.createFolder(escapedName);
            opResult.entity = spec.parent;
            opResult.result = newFolder;
            QueryUtil.waitUntilSearchable((DataService)this._dataService, (Object)newFolder, (String[])new String[]{"parent"});
        }
        catch (Exception e) {
            _logger.error((Object)"Error when creating folder", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult remove(ManagedObjectReference folderRef, FolderRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = folderRef;
        try {
            Folder folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)folderRef);
            if (folder == null) {
                String errorMessage = this.getLocalizedString("error.invalidFolder");
                throw new IllegalArgumentException(errorMessage);
            }
            TypeName[] types = folder.getChildType();
            Boolean isVmFolder = false;
            for (TypeName type2 : types) {
                String wsdlName = ((TypeNameImpl)type2).getWsdlName();
                if (!wsdlName.equals(VirtualMachine.class.getSimpleName())) continue;
                isVmFolder = true;
                break;
            }
            opResult.task = isVmFolder.booleanValue() ? (spec.deleteFromDisk != null && spec.deleteFromDisk.booleanValue() ? folder.destroy() : folder.unregisterAndDestroy()) : folder.destroy();
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private Folder getParentFolder(FolderInfo fInfo) throws Exception {
        ManagedObject mo = ManagedObjectUtil.getManagedObject((ManagedObjectReference)fInfo.parent);
        Folder folder = null;
        String errorMessage = null;
        if (mo instanceof Datacenter) {
            if (!this.validateFolderType(fInfo.folderType)) {
                errorMessage = this.getLocalizedString("error.invalidFolderType");
                throw new IllegalArgumentException(errorMessage);
            }
            folder = this.getRootFolder((Datacenter)mo, fInfo.folderType);
        } else if (mo instanceof Folder) {
            folder = (Folder)mo;
        }
        if (folder == null) {
            errorMessage = this.getLocalizedString("error.invalidFolderParent");
            throw new IllegalArgumentException(errorMessage);
        }
        return folder;
    }

    private Folder getRootFolder(Datacenter dc, String folderType) throws Exception {
        if (dc == null) {
            return null;
        }
        ManagedObjectReference folderMOR = null;
        if (folderType.equals("VirtualMachineFolder")) {
            folderMOR = dc.getVmFolder();
        } else if (folderType.equals("HostFolder")) {
            folderMOR = dc.getHostFolder();
        } else if (folderType.equals("NetworkFolder")) {
            folderMOR = dc.getNetworkFolder();
        } else if (folderType.equals("DatastoreFolder")) {
            folderMOR = dc.getDatastoreFolder();
        }
        return (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)folderMOR);
    }

    private boolean validateFolderType(String folderType) {
        if (folderType == null || folderType.length() == 0) {
            return false;
        }
        return folderType.equals("VirtualMachineFolder") || folderType.equals("HostFolder") || folderType.equals("NetworkFolder") || folderType.equals("DatastoreFolder");
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }
}

