/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.folder.FolderUtils;
import com.vmware.vsphere.client.folder.keyServers.KmipRetrieveServerCertificateSpec;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterKmipPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VCenterKmipPropertyProvider.class);
    private final TaskMonitor _taskMonitor;

    public VCenterKmipPropertyProvider(TaskMonitor taskMonitor) {
        this._taskMonitor = taskMonitor;
    }

    @type(value="Folder")
    public KmipClusterInfo[] getKmipClusters(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        return cryptoManagerKmip.listKmipServers(null);
    }

    @type(value="Folder")
    public boolean getDefaultKmsClusterExists(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return false;
        }
        KmipClusterInfo[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
        if (kmipClusterInfos != null) {
            for (KmipClusterInfo kmipClusterInfo : kmipClusterInfos) {
                if (!kmipClusterInfo.useAsDefault) continue;
                return true;
            }
        }
        return false;
    }

    @type(value="Folder")
    public OperationResult getKmipClustersStatus(ManagedObjectReference vcRef, Object[] infos) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KmipClusterInfo[] clustersInfo = (KmipClusterInfo[])Arrays.copyOf(infos, infos.length, KmipClusterInfo[].class);
        OperationResult opResult = new OperationResult();
        opResult.entity = vcRef;
        try {
            opResult.task = cryptoManagerKmip.retrieveKmipServersStatus(clustersInfo);
        }
        catch (Exception exp) {
            _logger.error((Object)"Error retrieving kmip clusters and servers status.", (Throwable)MixedUtil.getMethodFault((Throwable)exp));
            opResult.error = MixedUtil.getMethodFault((Throwable)exp);
        }
        return opResult;
    }

    @type(value="Folder")
    public CryptoManagerKmip.ServerCertInfo getKmipServerTrustedCertificate(ManagedObjectReference vcRef, KmipRetrieveServerCertificateSpec spec) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(spec.clusterName);
        return cryptoManagerKmip.retrieveKmipServerCert(clusterId, spec.serverInfo);
    }

    @type(value="Folder")
    public String getKmipCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCsr(clusterId);
        if (StringUtil.isNullOrEmpty((String)certificate)) {
            certificate = cryptoManagerKmip.generateClientCsr(clusterId);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateClientCsr(clusterId);
    }

    @type(value="Folder")
    public String getKmipClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCert(clusterId);
        if (StringUtil.isNullOrEmpty((String)certificate)) {
            certificate = cryptoManagerKmip.generateSelfSignedClientCert(clusterId);
            cryptoManagerKmip.updateSelfSignedClientCert(clusterId, certificate);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateSelfSignedClientCert(clusterId);
    }
}

