/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.cmc;

import com.vmware.ph.ConfigirationException;
import com.vmware.ph.VcConfiguration;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceScope;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.UserDataMetadata;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionConfiguration {
    private static final String KEY_LAST_COLLECTION_TIME = "vmware.vsphere.cis.cmc.lastcollectiontime";
    private static final String KEY_COLLECTION_ENABLED_AFTER_VC55U2 = "VirtualCenter.DataCollector.Enabled";
    private static final String DEV_OVERRIDE_LAST_COLLECTION_TIME = "dev.usageDataCollector.forceCollectAlways";
    private static final Logger logger = LoggerFactory.getLogger(CollectionConfiguration.class);
    private final PersistenceService _persistenceService;
    private final ConfigurationService _configurationService;

    public CollectionConfiguration(ConfigurationService configurationService, PersistenceService persistenceService) {
        this._configurationService = configurationService;
        this._persistenceService = persistenceService;
    }

    public static boolean wasCollectionEnabled(VcService vcService) {
        VcConfiguration vcConfiguration = new VcConfiguration(vcService);
        Object value = vcConfiguration.getVcConfigObject(KEY_COLLECTION_ENABLED_AFTER_VC55U2);
        return Boolean.TRUE.equals(value);
    }

    public long getLastCollectionTime(CollectionPeriod period) {
        boolean devOverride = this.getConfigFlag(DEV_OVERRIDE_LAST_COLLECTION_TIME);
        String propertyKey = this.getKeyLastCollectionTime(period);
        logger.debug("Trying to retreive userData from the persistence service with the following query {}, null, {}", (Object)propertyKey, (Object)PersistenceScope.DEFAULT);
        OperationResult retrieve = this._persistenceService.getUserData(propertyKey, null, PersistenceScope.DEFAULT);
        if (retrieve == null) {
            String msg = "PersistenceService returned no OperationResult.";
            logger.trace(msg);
            throw new IllegalStateException(msg);
        }
        if (retrieve.error != null) {
            String msg = "Error rertrieving last collection time: " + retrieve.error.getMessage();
            logger.debug(msg, (Throwable)retrieve.error);
            throw new ConfigirationException(msg, (Throwable)retrieve.error);
        }
        UserData userData = retrieve.result instanceof UserData ? (UserData)retrieve.result : null;
        Object value = userData != null ? userData.value : null;
        logger.debug("PersistenceService returned: {}", value);
        if (value instanceof Number) {
            return devOverride ? 0L : ((Number)value).longValue();
        }
        if (retrieve.result != null) {
            logger.warn("Failed to unpack persisted value for lastCollection time due to type mismatch: expected Number, got {}", value);
        }
        return 0L;
    }

    public void setLastCollectionTime(CollectionPeriod period, long time) {
        logger.debug("Storing last " + period + " collection time: {} ...", (Object)time);
        UserDataMetadata metadata = new UserDataMetadata();
        metadata.uid = this.getKeyLastCollectionTime(period);
        UserData data = new UserData();
        data.contentType = UserData.ContentType.CONTENT_TYPE_BINARY;
        data.metadata = metadata;
        data.value = time;
        OperationResult store = this._persistenceService.setUserData(data, false, PersistenceScope.DEFAULT);
        if (store.error != null) {
            String msg = "Error storing last collection time: " + store.error.getMessage();
            logger.debug(msg, (Throwable)store.error);
            throw new ConfigirationException(msg, (Throwable)store.error);
        }
        logger.debug("Successfully stored last " + period + " collection time: {}", (Object)time);
    }

    String getKeyLastCollectionTime(CollectionPeriod period) {
        if (period == CollectionPeriod.WEEKLY) {
            return KEY_LAST_COLLECTION_TIME;
        }
        return "vmware.vsphere.cis.cmc.lastcollectiontime." + period.toString().toLowerCase();
    }

    private boolean getConfigFlag(String flagName) {
        Object[] truths = new String[]{"yes", "on", "true"};
        String flagValue = this._configurationService.getProperty(flagName);
        return ArrayUtils.contains((Object[])truths, (Object)StringUtils.lowerCase((String)flagValue));
    }
}

