/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.cmc;

import com.vmware.ph.ConfigirationException;
import com.vmware.ph.ScheduleConfiguration;
import com.vmware.ph.ceip.authentication.DsSessionSimulator;
import com.vmware.ph.ceip.authentication.DsSessionSimulatorImpl;
import com.vmware.ph.ceip.authentication.InitializationException;
import com.vmware.ph.ceip.authentication.SessionSimulationException;
import com.vmware.ph.ceip.authentication.solutionuser.SolutionUserAuthenticationConfig;
import com.vmware.ph.common.net.ProxySettingsProvider;
import com.vmware.ph.config.ceip.CeipConfigProvider;
import com.vmware.ph.phservice.CollectionPeriod;
import com.vmware.ph.phservice.CollectorOutcome;
import com.vmware.ph.phservice.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.collector.core.impl.CollectorImpl;
import com.vmware.ph.phservice.collector.vcenter.VcenterTelemetryDataProvidersConnection;
import com.vmware.ph.phservice.provider.common.DataProvidersConnection;
import com.vmware.ph.phservice.provider.vimcommon.VimContext;
import com.vmware.ph.phservice.provider.vimcommon.VimContextBuilder;
import com.vmware.ph.phservice.proxy.VcProxySettingsProvider;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.sso.client.exception.SsoRuntimeException;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vsphere.client.ceip.util.Utils;
import com.vmware.vsphere.client.telemetry.cmc.CollectionConfiguration;
import com.vmware.vsphere.client.telemetry.cmc.DefaultPlatformClientFactory;
import com.vmware.vsphere.client.telemetry.cmc.PayloadAuditPersisterProviderImpl;
import com.vmware.vsphere.client.telemetry.cmc.schedule.ScheduleCalculator;
import java.net.URI;
import java.security.Key;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectorAction
implements Callable<CollectorOutcome> {
    private static final String MSG_COLLECTION_START = "Collection process: started";
    private static final String MSG_COLLECTION_COMPLETED = "Collection process: completed";
    private static final Logger logger = LoggerFactory.getLogger(CollectorAction.class);
    private static final String ERROR_SOURCE_DS = "Data";
    private static final String ERROR_SOURCE_SSO = "SSO";
    private static final String ERROR_REASON_INIT = "configuration initialization";
    private static final String ERROR_REASON_LOGIN = "acquire token";
    private static final String ERROR_REASON_PEER_SERVICE = "call to peer service";
    private static final String ERROR_REASON_CREATE_SESSION = "session creation";
    private static final String PROP_COLLECTOR_ID = "cmc.collector_id";
    private static final String DEFAULT_COLLECTOR_ID = "vSphere.6_7";
    private static final URI PROXY_AUTODISCOVERY_CONNECTION_TEST_URI = URI.create("https://vcsa.vmware.com/ph/api/v1/server_time");
    private static final int PROXY_AUTODISCOVERY_FRESH_PERIOD_IN_MS = (int)TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private final CeipConfigProvider _ceipConfigProvider;
    private final DsSessionSimulator _sessionSimulator;
    private final SolutionUserAuthenticationConfig _readOnlyauthConfig;
    private final SolutionUserAuthenticationConfig _nonReadOnlyAuthConfig;
    private final ConfigurationService _configurationService;
    private final KeystoreService _keystoreService;
    private final LookupService _lookupService;
    private final CollectionCoordinator _collectionCoordinator;

    public CollectorAction(DefaultPlatformClientFactory platformClientFactory, CeipConfigProvider ceipConfigProvider, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig readOnlyAuthConfig, SolutionUserAuthenticationConfig nonReadOnlyAuthConfig, KeystoreService keystoreService, ConfigurationService configurationService, LookupService lookupService) {
        this(new CollectionCoordinator(platformClientFactory), ceipConfigProvider, sessionSimulator, readOnlyAuthConfig, nonReadOnlyAuthConfig, keystoreService, configurationService, lookupService);
    }

    CollectorAction(CollectionCoordinator collectionCoordinator, CeipConfigProvider ceipConfigProvider, DsSessionSimulator sessionSimulator, SolutionUserAuthenticationConfig readOnlyAuthConfig, SolutionUserAuthenticationConfig nonReadOnlyAuthConfig, KeystoreService keystoreService, ConfigurationService configurationService, LookupService lookupService) {
        this._collectionCoordinator = collectionCoordinator;
        this._ceipConfigProvider = ceipConfigProvider;
        this._sessionSimulator = sessionSimulator;
        this._readOnlyauthConfig = readOnlyAuthConfig;
        this._nonReadOnlyAuthConfig = nonReadOnlyAuthConfig;
        this._keystoreService = keystoreService;
        this._configurationService = configurationService;
        this._lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CollectorOutcome call() {
        logger.debug("Starting the collection action.");
        HttpServletRequest request = null;
        try {
            VcService targetVc;
            block11: {
                CollectorOutcome collectorOutcome;
                targetVc = null;
                try {
                    logger.debug("open a VC session for retrieving CEIP status.");
                    request = this._sessionSimulator.simulate(this._readOnlyauthConfig, "collector_action_solution_user_actor_simulation");
                    this._collectionCoordinator.recordFirstBootTime(System.currentTimeMillis());
                    targetVc = this.findTargetVcService();
                    logger.info("VcService successfully found. Proceeding with data collection.");
                    boolean collectorEnabled = this._ceipConfigProvider.isCeipEnabled();
                    if (collectorEnabled) break block11;
                    logger.info("Skipping collection because usage data collector is not enabled.");
                    collectorOutcome = CollectorOutcome.PASSED;
                }
                catch (Throwable throwable) {
                    logger.debug("Closing the session opened for checking CEIP status.");
                    this._sessionSimulator.close(request);
                    throw throwable;
                }
                logger.debug("Closing the session opened for checking CEIP status.");
                this._sessionSimulator.close(request);
                return collectorOutcome;
            }
            logger.debug("Closing the session opened for checking CEIP status.");
            this._sessionSimulator.close(request);
            String vcServiceUrl = targetVc.getServiceUrl();
            CollectionPeriod failedCollection = null;
            CollectorOutcome outcome = this.attemptCollection(CollectionPeriod.DAILY, vcServiceUrl);
            if (outcome == CollectorOutcome.PASSED) {
                outcome = this.attemptCollection(CollectionPeriod.WEEKLY, vcServiceUrl);
                if (outcome != CollectorOutcome.PASSED) {
                    failedCollection = CollectionPeriod.WEEKLY;
                }
            } else {
                failedCollection = CollectionPeriod.DAILY;
            }
            if (failedCollection != null) {
                logger.info("{} collection completed with error.", (Object)failedCollection);
            }
            return outcome;
        }
        catch (InitializationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_INIT, (Exception)((Object)e));
            return CollectorOutcome.LOCAL_ERROR;
        }
        catch (DsSessionSimulatorImpl.ServiceInitializationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_PEER_SERVICE, (Exception)((Object)e));
            return CollectorOutcome.LOCAL_ERROR;
        }
        catch (SsoRuntimeException e) {
            this.logPeerServiceError(ERROR_SOURCE_SSO, ERROR_REASON_LOGIN, (Exception)((Object)e));
            return CollectorOutcome.LOCAL_ERROR;
        }
        catch (SessionSimulationException e) {
            this.logPeerServiceError(ERROR_SOURCE_DS, ERROR_REASON_CREATE_SESSION, (Exception)((Object)e));
            return CollectorOutcome.LOCAL_ERROR;
        }
    }

    private CollectorOutcome attemptCollection(CollectionPeriod period, String vcServiceUri) {
        try {
            CollectorOutcome outcome;
            boolean timeToFire = this._collectionCoordinator.isItTimeToFire(period);
            if (timeToFire) {
                logger.info("It is time to run the " + period + " data collection.");
                outcome = this.performCollectionUsingCustomTCCL(period, vcServiceUri);
                this._collectionCoordinator.setLastCollectionTime(period, System.currentTimeMillis());
            } else {
                logger.info("Data collector doesn't yet need to run.");
                outcome = CollectorOutcome.PASSED;
            }
            return outcome;
        }
        catch (ConfigirationException e) {
            logger.warn("Error reading schedule configuration: " + e.getMessage(), (Throwable)e);
            return CollectorOutcome.LOCAL_ERROR;
        }
        catch (NoPermission e) {
            logger.error("Collector solution user lacks the required permissions to set default vCenter configuration.", (Throwable)e);
            return CollectorOutcome.LOCAL_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectorOutcome performCollectionUsingCustomTCCL(CollectionPeriod period, String vcServiceUri) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            CollectorOutcome collectorOutcome = this.performCollection(period, vcServiceUri);
            return collectorOutcome;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectorOutcome performCollection(CollectionPeriod period, String vcServiceUri) {
        String lookupSdk = this._lookupService.getServiceUrl();
        VcenterTelemetryDataProvidersConnection dataProvidersConnection = null;
        CollectorImpl collector = null;
        try {
            VimContext vimContextWithReadOnlyUser = this.createVimContext(this._readOnlyauthConfig, lookupSdk, vcServiceUri);
            VimContext vimContextWithNonReadOnlyUser = this.createVimContext(this._nonReadOnlyAuthConfig, lookupSdk, vcServiceUri);
            dataProvidersConnection = new VcenterTelemetryDataProvidersConnection(vimContextWithReadOnlyUser, vimContextWithNonReadOnlyUser);
            PayloadAuditPersisterProviderImpl payloadAuditPersisterProvider = new PayloadAuditPersisterProviderImpl();
            VcProxySettingsProvider proxySettingsProvider = new VcProxySettingsProvider((long)PROXY_AUTODISCOVERY_FRESH_PERIOD_IN_MS, PROXY_AUTODISCOVERY_CONNECTION_TEST_URI);
            String collectorId = this.getCollectorId();
            Properties properties = this.preparePropertiesForCollector(collectorId);
            collector = new CollectorImpl((DataProvidersConnection)dataProvidersConnection, null, null, (PayloadAuditPersisterProvider)payloadAuditPersisterProvider, (ProxySettingsProvider)proxySettingsProvider, properties, dataProvidersConnection.getReadOnlyVcClientProvider(), period);
            logger.info(MSG_COLLECTION_START);
            collector.run();
            logger.info(MSG_COLLECTION_COMPLETED);
            CollectorOutcome collectorOutcome = CollectorOutcome.PASSED;
            return collectorOutcome;
        }
        catch (RuntimeException e) {
            logger.info(MSG_COLLECTION_COMPLETED);
            logger.error("Error executing data collection: " + e.getMessage(), (Throwable)e);
            CollectorOutcome collectorOutcome = CollectorOutcome.LOCAL_ERROR;
            return collectorOutcome;
        }
        finally {
            if (collector != null) {
                collector.close();
            }
            if (dataProvidersConnection != null) {
                dataProvidersConnection.close();
            }
        }
    }

    private VimContext createVimContext(SolutionUserAuthenticationConfig authConfig, String lookupSdk, String vcServiceUri) {
        VimContextBuilder vimContextBuilder = VimContextBuilder.forVim((URI)URI.create(lookupSdk), (KeyStore)this._keystoreService.getKeyStore());
        vimContextBuilder.withVcSdkUri(URI.create(vcServiceUri)).withSsoSolutionUser(authConfig.getSolutionCertificate(), (Key)authConfig.getSolutionKey());
        return vimContextBuilder.build();
    }

    String getCollectorId() {
        String value = this._configurationService.getProperty(PROP_COLLECTOR_ID);
        if (value == null) {
            value = DEFAULT_COLLECTOR_ID;
        }
        return value;
    }

    Properties preparePropertiesForCollector(String collectorId) {
        HashMap<String, String> webClientProperties = new HashMap<String, String>(this._configurationService.getConfiguration().configParams);
        webClientProperties.put(PROP_COLLECTOR_ID, collectorId);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)webClientProperties);
        return properties;
    }

    private VcService findTargetVcService() {
        logger.info("findTargetVcService taking it from VimSessionUtil.getLinkedVcGroupRegistry()");
        LinkedVcGroupRegistry vcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        return Utils.getVcService((LinkedVcGroupRegistry)vcGroupRegistry);
    }

    private void logPeerServiceError(String sourceService, String reason, Exception e) {
        logger.error("{} Service error while running usage data collector: {} failed.", new Object[]{sourceService, reason, e});
    }

    static class CollectionCoordinator {
        private final DefaultPlatformClientFactory _platformClientFactory;
        private final ScheduleCalculator _scheduleCalc;
        private final SimpleDateFormat _formatter;

        public CollectionCoordinator(DefaultPlatformClientFactory platformClientFactory) {
            this(platformClientFactory, new ScheduleCalculator());
        }

        CollectionCoordinator(DefaultPlatformClientFactory platformClientFactory, ScheduleCalculator scheduleCalc) {
            this._platformClientFactory = platformClientFactory;
            this._scheduleCalc = scheduleCalc;
            this._formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this._formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void recordFirstBootTime(long firstBootTime) {
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            try {
                if (collectionConfiguration.getLastCollectionTime(CollectionPeriod.DAILY) == 0L) {
                    collectionConfiguration.setLastCollectionTime(CollectionPeriod.DAILY, firstBootTime);
                }
                if (collectionConfiguration.getLastCollectionTime(CollectionPeriod.WEEKLY) == 0L) {
                    collectionConfiguration.setLastCollectionTime(CollectionPeriod.WEEKLY, firstBootTime);
                }
            }
            catch (Exception e) {
                logger.error("Error reading/writing lastCollectionTime during startup.", (Throwable)e);
            }
        }

        public boolean isItTimeToFire(CollectionPeriod period) {
            ScheduleConfiguration scheduleConfig = this._platformClientFactory.createScheduleConfiguration();
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            String schedule = this.retrieveValidSchedule(scheduleConfig);
            long lastCollectionTime = collectionConfiguration.getLastCollectionTime(period);
            long now = System.currentTimeMillis();
            boolean timeToFire = this._scheduleCalc.isItTimeToFire(period, lastCollectionTime, now, schedule);
            logger.info("Collector " + period + " configuration: timeToFime = " + timeToFire + " ; schedule =  " + schedule + " ; lastCollectionTime = " + this.toUtcTimeString(lastCollectionTime) + " ; now = " + this.toUtcTimeString(now));
            return timeToFire;
        }

        public void setLastCollectionTime(CollectionPeriod period, long currentTimeMillis) {
            CollectionConfiguration collectionConfiguration = this._platformClientFactory.createCollectionConfiguration();
            collectionConfiguration.setLastCollectionTime(period, currentTimeMillis);
        }

        private String retrieveValidSchedule(ScheduleConfiguration scheduleConfig) throws ConfigirationException {
            boolean scheduleIsValid;
            String schedule = scheduleConfig.getSchedule();
            boolean bl = scheduleIsValid = !StringUtils.isEmpty((String)schedule) && this._scheduleCalc.validateScheduleAndBuildCallendar(schedule, false) != null;
            if (!scheduleIsValid) {
                String newSchedule = this._scheduleCalc.generateRandomSchedule();
                scheduleConfig.setSchedule(newSchedule);
                logger.info("The data collection was enabled but the configured schedule `{}' was not valud. Created new schedule: {}", (Object)schedule, (Object)newSchedule);
                schedule = newSchedule;
            }
            return schedule;
        }

        private String toUtcTimeString(long time) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTimeInMillis(time);
            return this._formatter.format(c.getTime());
        }
    }
}

