/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.cmc;

import com.vmware.ph.client.common.audit.AuditFilePayloadPersister;
import com.vmware.ph.common.audit.AuditFileConfig;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.ph.phservice.PayloadAuditPersisterProvider;
import com.vmware.ph.phservice.StorageUtils;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public class PayloadAuditPersisterProviderImpl
implements PayloadAuditPersisterProvider {
    private static final String AUDIT_TARGET_FILENAME = "cmc.audit";
    private static final int AUDIT_FILE_MAX_SIZE_BYTES = 0xA00000;
    private static final int AUDIT_FILE_MAX_HISTORY = 5;
    private static final String CEIP_DIRECTORY = "ceip";
    private static final String AUDIT_DIRECTORY = "audit";

    public PayloadAuditPersister getPayloadAuditPersister() {
        AuditFileConfig auditFile = this.getAuditFile();
        return new AuditFilePayloadPersister(auditFile);
    }

    private AuditFileConfig getAuditFile() {
        String filePath = this.getAuditFilePath();
        AuditFileConfig auditFile = new AuditFileConfig(filePath, true, 0xA00000, 5);
        return auditFile;
    }

    private String getAuditFilePath() {
        String vsphereClientStorageDirectory = StorageUtils.getStorageDirectory();
        File ceipDirectory = new File(vsphereClientStorageDirectory, CEIP_DIRECTORY);
        File auditDirectory = new File(ceipDirectory, AUDIT_DIRECTORY);
        return FilenameUtils.concat((String)auditDirectory.getAbsolutePath(), (String)AUDIT_TARGET_FILENAME);
    }
}

