/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ovf.impl;

import com.vmware.ovf.impl.OvfPropertyProvider;
import com.vmware.ovf.model.ComputeResourceData;
import com.vmware.ovf.model.HostConnectionStateDataModel;
import com.vmware.vcenter.ovf.CapabilityTypes;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.DisabledOperationsManager;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeployOvfPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DeployOvfPropertyProvider.class);
    private static final String RESOURCE_POOL = "resourcePool";
    private static final String IMPORT_VAPP_METHOD_NAME = "ImportVApp";
    private static final String VAPP_IMPORT_PRIVILEGE_NAME = "VApp.Import";
    private static final String PARENT_RELATIONSHIP = "parent";
    private static final String OWNER_RELATIONSHIP = "owner";
    private static final String DRS_ENABLED = "drsEnabled";
    private static final String ENVIRONMENT_BROWSER = "environmentBrowser";
    private final LegacyAuthorizationService _authService;
    private final DisabledOperationsManager _disabledOpManager;
    private final DataFetchCommand _dataFetchService;
    private final QueryExecutor _queryExecutor;
    private final OvfPropertyProvider _ovfPropertyProvider;

    public DeployOvfPropertyProvider(LegacyAuthorizationService authorizationService, DisabledOperationsManager disabledOpManager, DataFetchCommand dataFetchService, QueryExecutor queryExecutor, OvfPropertyProvider ovfPropertyProvider) {
        this._authService = authorizationService;
        this._disabledOpManager = disabledOpManager;
        this._dataFetchService = dataFetchService;
        this._queryExecutor = queryExecutor;
        this._ovfPropertyProvider = ovfPropertyProvider;
    }

    @type(value="Folder,ClusterComputeResource,ResourcePool,VirtualApp,Datacenter,HostSystem")
    public boolean getDeployOvfAvailable(ManagedObjectReference target) {
        try {
            if (target == null) {
                _logger.error((Object)"getDeployOvfAvailable: target is null!");
                throw MixedUtil.getInvalidEntityFault();
            }
            if (this.isValidContainerType(target)) {
                return true;
            }
            ComputeResourceData data = this.getComputeResourceData(target);
            Boolean isDeployOvfAvailable = this.hostStateIsCorrect(target, data) && this.isImportVappAvailable(data) && this.hasVappImportPrivilege(data);
            CapabilityTypes.CapabilityInfo capabilityInfo = this._ovfPropertyProvider.getCapabilitiesForOvf(target);
            return isDeployOvfAvailable != false && capabilityInfo.getImportOva();
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            return true;
        }
    }

    private boolean isValidContainerType(ManagedObjectReference target) {
        boolean isValidContainerType = false;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Datacenter.class)) {
            isValidContainerType = true;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, Folder.class)) {
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
            if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)target)) {
                isValidContainerType = true;
            }
        }
        return isValidContainerType;
    }

    private boolean hasVappImportPrivilege(ComputeResourceData data) throws Exception {
        if (data == null) {
            _logger.error((Object)"ComputeResourceData is null!");
            return false;
        }
        if (data.resourcePool == null) {
            _logger.error((Object)"ComputeResourceData.resourcePool is null!");
            return false;
        }
        boolean hasPrivileges = this._authService.checkPrivileges(new ManagedObjectReference[]{data.resourcePool}, new String[]{VAPP_IMPORT_PRIVILEGE_NAME});
        if (!hasPrivileges) {
            _logger.info((Object)"No VApp.Import privileges on resource pool!");
        }
        return hasPrivileges;
    }

    private boolean isImportVappAvailable(ComputeResourceData data) throws Exception {
        if (data == null) {
            _logger.error((Object)"ComputeResourceData is null!");
            return false;
        }
        if (data.resourcePool == null) {
            _logger.error((Object)"ComputeResourceData.resourcePool is null!");
            return false;
        }
        boolean isAvailable = this._disabledOpManager.checkDisabledOperations(new ManagedObjectReference[]{data.resourcePool}, new String[]{IMPORT_VAPP_METHOD_NAME});
        if (!isAvailable) {
            _logger.info((Object)"ImportVApp operation is disabled!");
            return false;
        }
        return true;
    }

    private boolean hostStateIsCorrect(ManagedObjectReference target, ComputeResourceData data) {
        if (data == null) {
            _logger.error((Object)"ComputeResourceData is null!");
            return false;
        }
        if (!this.hasAtLeastOneHostConnected(data)) {
            _logger.info((Object)"No hosts are in valid state!");
            return false;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, HostSystem.class) && data.isClusterDrsEnabled != null && !data.isClusterDrsEnabled.booleanValue() && !this.isHostInNonDrsClusterInCorrectState(target)) {
            _logger.info((Object)"Host in non-DRS cluster is in invalid state!");
            return false;
        }
        return true;
    }

    private boolean hasAtLeastOneHostConnected(ComputeResourceData data) {
        return data.environmentBrowser != null;
    }

    private boolean isHostInNonDrsClusterInCorrectState(ManagedObjectReference host) {
        Collection connectionStates = this._dataFetchService.execute(HostConnectionStateDataModel.class, new Object[]{host});
        for (HostConnectionStateDataModel hostConnectionStateDataModel : connectionStates) {
            if (hostConnectionStateDataModel.inMaintenanceMode || !HostSystem.ConnectionState.connected.equals((Object)hostConnectionStateDataModel.connectionState)) continue;
            return true;
        }
        return false;
    }

    private ComputeResourceData getComputeResourceData(ManagedObjectReference target) throws Exception {
        if (!this.targetIsValidType(target)) {
            _logger.error((Object)"target is of invalid type!");
            throw new IllegalArgumentException("target is of invalid type: " + target.getType() + " !");
        }
        PropertyValue[] values = this.queryProperties(target);
        return this.buildComputeResourceDataObject(target, values);
    }

    private boolean targetIsValidType(ManagedObjectReference target) {
        return ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class);
    }

    private PropertyValue[] queryProperties(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ClusterComputeResource.class)) {
            values = this.queryPropertiesForCluster(target);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, HostSystem.class)) {
            values = this.queryPropertiesForHost(target);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class)) {
            values = this.queryPropertiesForResourcePoolOrVapp(target);
        }
        return values;
    }

    private PropertyValue[] queryPropertiesForCluster(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getProperties((Object)target, new String[]{RESOURCE_POOL, ENVIRONMENT_BROWSER});
        return values;
    }

    private PropertyValue[] queryPropertiesForHost(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getPropertiesForRelatedObjects((Object)target, PARENT_RELATIONSHIP, null, new String[]{RESOURCE_POOL, DRS_ENABLED, ENVIRONMENT_BROWSER});
        return values;
    }

    private PropertyValue[] queryPropertiesForResourcePoolOrVapp(ManagedObjectReference target) throws Exception {
        PropertyValue[] values = this._queryExecutor.getPropertiesForRelatedObjects((Object)target, OWNER_RELATIONSHIP, ComputeResource.class.getSimpleName(), new String[]{RESOURCE_POOL, ENVIRONMENT_BROWSER});
        return values;
    }

    private ComputeResourceData buildComputeResourceDataObject(ManagedObjectReference target, PropertyValue[] values) {
        if (values == null) {
            _logger.info((Object)"No ComputeResourceData was extracted with the given MOR!");
            return null;
        }
        ComputeResourceData data = new ComputeResourceData();
        for (PropertyValue propertyValue : values) {
            if (RESOURCE_POOL.equals(propertyValue.propertyName)) {
                data.resourcePool = ManagedObjectUtil.isOfType((ManagedObjectReference)target, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)target, VirtualApp.class) ? target : (ManagedObjectReference)propertyValue.value;
            }
            if (DRS_ENABLED.equals(propertyValue.propertyName)) {
                data.isClusterDrsEnabled = (Boolean)propertyValue.value;
            }
            if (!ENVIRONMENT_BROWSER.equals(propertyValue.propertyName)) continue;
            data.environmentBrowser = (ManagedObjectReference)propertyValue.value;
        }
        return data;
    }
}

