/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.ovf.impl;

import com.vmware.ovf.OvfException;
import com.vmware.ovf.util.OvfServiceUtil;
import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vcenter.ovf.Capability;
import com.vmware.vcenter.ovf.CapabilityTypes;
import com.vmware.vim.binding.vim.OvfManager;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OvfPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(OvfPropertyProvider.class);
    private final Capability _ovfCapability;

    public OvfPropertyProvider(Capability ovfCapability) {
        this._ovfCapability = ovfCapability;
    }

    @type(value="Folder,ClusterComputeResource,ResourcePool,VirtualApp,VirtualMachine,Datacenter,HostSystem")
    public CapabilityTypes.CapabilityInfo getCapabilitiesForOvf(ManagedObjectReference serverObjectRef) {
        try {
            return this._ovfCapability.get(serverObjectRef.getServerGuid());
        }
        catch (OperationNotFound ex) {
            _logger.warn((Object)String.format("CLS Capability interface not found on VC: %s\nReturning a CapabilityInfo with all features disabled.", serverObjectRef));
            CapabilityTypes.CapabilityInfo capabilityInfo = new CapabilityTypes.CapabilityInfo();
            capabilityInfo.setImportOva(false);
            capabilityInfo.setExportOva(false);
            return capabilityInfo;
        }
        catch (Exception ex) {
            _logger.warn((Object)String.format("Error: %s, while checking CLS Capability interface on VC: %s\nReturning a CapabilityInfo with all features disabled.", ex.getMessage(), serverObjectRef), (Throwable)ex);
            CapabilityTypes.CapabilityInfo capabilityInfo = new CapabilityTypes.CapabilityInfo();
            capabilityInfo.setImportOva(false);
            capabilityInfo.setExportOva(false);
            return capabilityInfo;
        }
    }

    @type(value="ClusterComputeResource,HostSystem,ResourcePool,VirtualApp,VirtualMachine")
    public String getSslThumbprintForOvfTool(ManagedObjectReference moRef) throws MethodFault, OvfException {
        if (moRef == null) {
            _logger.error((Object)"moRef is null");
            throw MixedUtil.getInvalidEntityFault();
        }
        String serviceGuid = null;
        try {
            serviceGuid = moRef.getServerGuid();
            VcService vcService = VimSessionUtil.getService((String)serviceGuid);
            String thumbprint = vcService.getThumbprint();
            return thumbprint;
        }
        catch (Exception ex) {
            String serviceGuidToLog = serviceGuid == null ? "null" : serviceGuid;
            _logger.error((Object)("Unable to get service thumbprint. moRef=" + moRef + ", serviceGuid=" + serviceGuidToLog), (Throwable)ex);
            String message = OvfServiceUtil.getLocalizedString("error.sslThumbprint");
            OvfException ovfEx = new OvfException(message, ex);
            throw ovfEx;
        }
    }

    @type(value="ClusterComputeResource,HostSystem,ResourcePool,VirtualApp,VirtualMachine")
    public String getViSessionTicket(ManagedObjectReference moRef) throws MethodFault, OvfException {
        if (moRef == null) {
            _logger.error((Object)"moRef is null");
            throw MixedUtil.getInvalidEntityFault();
        }
        String serviceGuid = null;
        try {
            serviceGuid = moRef.getServerGuid();
            VcService vcService = VimSessionUtil.getService((String)serviceGuid);
            ServiceInstanceContent sic = vcService.getServiceInstanceContent();
            ManagedObjectReference sessionManagerRef = sic.getSessionManager();
            SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sessionManagerRef);
            String ticket = sessionManager.acquireCloneTicket();
            return ticket;
        }
        catch (Exception ex) {
            String serviceGuidToLog = serviceGuid == null ? "null" : serviceGuid;
            _logger.error((Object)("Unable to acquire clone ticket. moRef=" + moRef + ", serviceGuid=" + serviceGuidToLog), (Throwable)ex);
            String message = OvfServiceUtil.getLocalizedString("error.viSessionTicket");
            OvfException ovfEx = new OvfException(message, ex);
            throw ovfEx;
        }
    }

    @type(value="ClusterComputeResource,HostSystem,ResourcePool,VirtualApp,VirtualMachine")
    public String getViLocator(ManagedObjectReference moRef) throws MethodFault, OvfException {
        if (moRef == null) {
            _logger.error((Object)"moRef is null");
            throw MixedUtil.getInvalidEntityFault();
        }
        try {
            String host = OvfPropertyProvider.getVcHost(moRef);
            String locator = OvfPropertyProvider.getViLocator(host, moRef);
            return locator;
        }
        catch (Exception ex) {
            _logger.error((Object)("Unable to get VI locator. moRef=" + moRef), (Throwable)ex);
            String message = OvfServiceUtil.getLocalizedString("error.viLocator");
            OvfException ovfEx = new OvfException(message, ex);
            throw ovfEx;
        }
    }

    @type(value="VirtualApp,VirtualMachine")
    public boolean getHasImageFiles(ManagedObjectReference moRef) throws MethodFault, OvfException {
        if (moRef == null) {
            _logger.error((Object)"moRef is null");
            throw MixedUtil.getInvalidEntityFault();
        }
        try {
            VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
            ManagedObjectReference ovfManagerRef = vcService.getServiceInstanceContent().getOvfManager();
            OvfManager ovfManager = (OvfManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)ovfManagerRef);
            OvfManager.CreateDescriptorParams params = new OvfManager.CreateDescriptorParams();
            OvfManager.CreateDescriptorResult result = ovfManager.createDescriptor(moRef, params);
            boolean includeImageFiles = result.includeImageFiles;
            return includeImageFiles;
        }
        catch (Exception ex) {
            _logger.error((Object)("Unable to get includeImageFiles boolean. moRef=" + moRef), (Throwable)ex);
            String message = OvfServiceUtil.getLocalizedString("error.hasImageFiles");
            OvfException ovfEx = new OvfException(message, ex);
            throw ovfEx;
        }
    }

    private static String getVcHost(ManagedObjectReference moRef) throws URISyntaxException {
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        String serviceUrl = vcService.getServiceUrl();
        URI uri = new URI(serviceUrl);
        String host = uri.getHost();
        _logger.info((Object)("Got VC host: " + host + " for moref: " + moRef.toString()));
        if (MixedUtil.isLocalhost((String)host)) {
            _logger.info((Object)("Host from service URL: " + serviceUrl + " is localhost. Trying VIM API service endpoint"));
            ServiceDirectory.ServiceEndpoint se = VcServiceUtil.getServiceEndpoint((String)moRef.getServerGuid(), (ServiceDirectory.ServiceProtocol)ServiceDirectory.ServiceProtocol.vimApi, null);
            if (se != null) {
                uri = URI.create(se.url);
                host = uri.getHost();
                _logger.info((Object)("Got VC host: " + host + " from VIM API service endpoint"));
            }
        }
        return host;
    }

    private static String getViLocator(String host, ManagedObjectReference moRef) {
        StringBuffer buffer = new StringBuffer("vi://");
        buffer.append(host);
        buffer.append("/?moref=vim.");
        buffer.append(moRef.getType());
        buffer.append(":");
        buffer.append(moRef.getValue());
        return buffer.toString();
    }
}

