/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.compatibility.impl;

import com.vmware.vise.extensionfw.compatibility.impl.VersionInterval;
import com.vmware.vise.util.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VersionRange {
    private String _value;
    private List<VersionInterval> _intervals;

    public VersionRange(String string) {
        this._value = string;
        this.init();
    }

    boolean contains(Version version) {
        for (VersionInterval versionInterval : this._intervals) {
            boolean bl = versionInterval.contains(version);
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    private void init() {
        this._intervals = new ArrayList<VersionInterval>();
        if (this._value == null || this._value.isEmpty()) {
            this._intervals.add(new VersionInterval(null, null));
            return;
        }
        Pattern pattern = Pattern.compile("(?<interval>(\\[|\\()[^\\]\\)]*(\\]|\\)))|(?<version>[\\d\\.]+)");
        Matcher matcher = pattern.matcher(this._value);
        while (matcher.find()) {
            String string = matcher.group("interval");
            if (string != null) {
                this.initInterval(string);
                continue;
            }
            String string2 = matcher.group("version");
            if (string2 == null) continue;
            this.initVersion(string2);
        }
    }

    private void initInterval(String string) {
        String[] stringArray = string.split(",");
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        this._intervals.add(new VersionInterval(string2, string3));
    }

    private void initVersion(String string) {
        this._intervals.add(new VersionInterval(string, string));
    }

    public String toString() {
        return this._value;
    }
}

