/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.RemotePluginProcessor;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionObjectParser {
    private static final Log _logger = LogFactory.getLog(ExtensionObjectParser.class);
    private static final boolean _isH5Client = BuildProperties.isH5Client();
    private static final Pattern RESOURCE_REG_EX = Pattern.compile("#\\{(\\w+)([\\.-]\\w+)*:?(\\w+)([\\.-]\\w+)*\\}");
    private static final Pattern RESOURCE_REG_EX_NO_BUNDLE_NAME = Pattern.compile("#\\{(\\w+)([\\.-]\\w+)*\\}");
    private static final String TOKEN_PREFIX = "#{";
    private static final String TOKEN_SUFFIX = "}";
    static I18nManager i18nManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> parse(ExtensionPointInfo extensionPointInfo, ExtensionInfo[] extensionInfoArray, ClassLoaderService classLoaderService, ConcurrentHashMap<String, Object> concurrentHashMap, boolean bl, Map<String, Object> map) {
        Object object = new ArrayList();
        Unmarshaller unmarshaller = null;
        String string = extensionPointInfo.getObjectType();
        for (ExtensionInfo extensionInfo : extensionInfoArray) {
            String string2 = extensionInfo.getId();
            if (concurrentHashMap != null && concurrentHashMap.containsKey(string2)) {
                object.add(concurrentHashMap.get(string2));
                continue;
            }
            PluginInfo pluginInfo = ExtensionManager.getInstance().getPluginInfo(extensionInfo.getPluginRef());
            PluginPackageInfo pluginPackageInfo = ExtensionManager.getInstance().getPluginPackageInfo(pluginInfo.getPackageRef());
            String string3 = ExtensionObjectParser.resolveObjectXml(extensionInfo, pluginInfo.getDefaultBundle(), bl);
            if (pluginPackageInfo != null && pluginPackageInfo.isRemotePlugin()) {
                string3 = RemotePluginProcessor.changeURLInObjectXml(pluginPackageInfo, string3, map);
            }
            try (StringReader stringReader = null;){
                Object object2;
                Object object3;
                stringReader = new StringReader(string3);
                if (unmarshaller == null) {
                    try {
                        object3 = classLoaderService.loadClass(string);
                        object2 = JAXBContext.newInstance((Class[])new Class[]{object3});
                        unmarshaller = object2.createUnmarshaller();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Error when creating jaxb unmarshaller for type " + string), (Throwable)exception);
                    }
                    if (unmarshaller == null) {
                        object3 = object;
                        return object3;
                    }
                }
                object3 = unmarshaller.unmarshal((Source)new StreamSource(stringReader));
                ExtensionObjectParser.fillValues(object3, extensionInfo);
                if (!(concurrentHashMap == null || pluginPackageInfo != null && pluginPackageInfo.isRemotePlugin() || (object2 = concurrentHashMap.putIfAbsent(string2, object3)) == null)) {
                    object3 = object2;
                }
                object.add(object3);
            }
        }
        return object;
    }

    private static void fillValues(Object object, ExtensionInfo extensionInfo) {
        if (!(object instanceof IUID)) {
            return;
        }
        IUID iUID = (IUID)object;
        iUID.setUid(extensionInfo.getId());
    }

    private static String resolveObjectXml(ExtensionInfo extensionInfo, String string, boolean bl) {
        String string2 = extensionInfo.getObjectXmlStr();
        try {
            Matcher matcher = bl ? RESOURCE_REG_EX.matcher(string2) : RESOURCE_REG_EX_NO_BUNDLE_NAME.matcher(string2);
            HashSet<String> hashSet = new HashSet<String>();
            while (matcher.find()) {
                _logger.debug((Object)("Token matched - " + matcher.group()));
                hashSet.add(matcher.group());
            }
            for (String string3 : hashSet) {
                String string4 = ExtensionObjectParser.resolvePropertyName(string3, string, bl);
                if (_isH5Client) {
                    string4 = ExtensionObjectParser.convertH5Icons(extensionInfo, string, string4, string3);
                }
                if (StringUtil.isNullOrEmpty((String)string4)) continue;
                string2 = string2.replace(string3, StringEscapeUtils.escapeXml((String)string4));
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when resolving xml for extension - " + extensionInfo.getId()));
        }
        return string2;
    }

    private static String convertH5Icons(ExtensionInfo extensionInfo, String string, String string2, String string3) {
        String string4 = extensionInfo.getObjectXmlStr();
        if ((string4.contains("<icon>" + string3) || string4.contains("<dialogIcon>" + string3)) && string3.startsWith(TOKEN_PREFIX)) {
            if ((string3 = string3.substring(TOKEN_PREFIX.length(), string3.length() - TOKEN_SUFFIX.length())).indexOf(":") < 0) {
                string3 = string + ":" + string3;
            }
            string2 = string3.replace(":", "-").replace(".", "-");
            _logger.debug((Object)("Icon converted in " + extensionInfo.getId() + ": " + string2));
        }
        return string2;
    }

    private static String resolvePropertyName(String string, String string2, boolean bl) {
        if (!bl) {
            int n = string.indexOf(TOKEN_PREFIX) + TOKEN_PREFIX.length();
            string = TOKEN_PREFIX + string2 + ":" + string.substring(n);
            return string;
        }
        if (string.startsWith(TOKEN_PREFIX)) {
            string = string.substring(TOKEN_PREFIX.length(), string.length() - TOKEN_SUFFIX.length());
        }
        String string3 = string2;
        String string4 = null;
        int n = string.indexOf(":");
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        } else {
            string4 = string;
        }
        if (i18nManager != null) {
            Locale locale = ResourceUtil.getLocale();
            Map map = i18nManager.getResourceMap(locale);
            Map map2 = (Map)map.get(string3);
            if (map2 == null || map2.isEmpty()) {
                _logger.warn((Object)("No or empty resource map is found for the bundle '" + string3 + "'"));
                return string4;
            }
            return (String)map2.get(string4);
        }
        throw new IllegalStateException("No i18nManager setup.");
    }
}

