/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.CombinedExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginPackageStateInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ExtensionServiceImpl
implements ExtensionService {
    private final ExtensionManager _em = ExtensionManager.getInstance();

    public ExtensionServiceImpl(ServiceRegistry serviceRegistry, ClassLoaderService classLoaderService) {
        this._em.setServiceRegistry(serviceRegistry);
        this._em.setClassLoaderService(classLoaderService);
    }

    @Override
    public <T> List<T> getExtensionObjects(String string, Map<String, Object> map, boolean bl) {
        return this._em.getExtensionObjects(string, map, bl);
    }

    @Override
    public <T> List<T> getExtensionObjects(List<ExtensionInfo> list, Map<String, Object> map, boolean bl) {
        return this._em.getExtensionObjects(list, map, bl);
    }

    @Override
    public <T> T getExtensionObject(ExtensionInfo extensionInfo, Map<String, Object> map, boolean bl) {
        return this._em.getExtensionObject(extensionInfo, map, bl);
    }

    @Override
    public ExtensionPointInfo getExtensionPointInfo(String string) {
        return this._em.getExtensionPointInfo(string);
    }

    @Override
    public ExtensionInfo getExtensionInfo(String string) {
        return this._em.getExtensionInfo(string);
    }

    @Override
    public CombinedExtensionPointInfo[] getAllCombinedExtensionPointInfos() {
        return this._em.getAllCombinedExtensionPointInfos();
    }

    @Override
    public CombinedExtensionPointInfo getCombinedInfoByPointId(String string) throws Exception {
        ExtensionPointInfo extensionPointInfo = this.getExtensionPointInfo(string);
        if (extensionPointInfo == null) {
            return null;
        }
        ExtensionInfo[] extensionInfoArray = this.getExtensionInfos(string);
        CombinedExtensionPointInfo combinedExtensionPointInfo = new CombinedExtensionPointInfo();
        combinedExtensionPointInfo.setPoint(extensionPointInfo);
        combinedExtensionPointInfo.setExtensions(extensionInfoArray);
        return combinedExtensionPointInfo;
    }

    @Override
    public CombinedExtensionPointInfo getCombinedInfoByExtensionIds(String[] stringArray) throws Exception {
        if (stringArray == null) {
            return null;
        }
        String string = null;
        for (String string2 : stringArray) {
            ExtensionInfo extensionInfo = this.getExtensionInfo(string2);
            if (extensionInfo == null) continue;
            string = extensionInfo.getExtendedPointIds()[0];
            break;
        }
        if (string == null) {
            return null;
        }
        return this.getCombinedInfoByPointId(string);
    }

    @Override
    public ExtensionInfo[] getExtensionInfos(String string) {
        return this._em.getExtensionInfos(string);
    }

    @Override
    public PluginInfo getPluginInfo(IdVersionPair idVersionPair) throws Exception {
        return this._em.getPluginInfo(idVersionPair);
    }

    @Override
    public PluginInfo[] getPluginInfos() throws Exception {
        return this._em.getPluginInfos();
    }

    @Override
    public PluginPackageInfo getPluginPackageInfo(IdVersionPair idVersionPair) throws Exception {
        return this._em.getPluginPackageInfo(idVersionPair);
    }

    @Override
    public PluginPackageInfo[] getPluginPackageInfos() throws Exception {
        return this._em.getPluginPackageInfos();
    }

    @Override
    public void setPackageStates(PluginPackageStateInfo[] pluginPackageStateInfoArray) throws Exception {
        this._em.setPackageStates(pluginPackageStateInfoArray);
    }

    @Override
    public PluginPackageInfo[] getAllPluginPackageInfos() throws Exception {
        return this._em.getAllPluginPackageInfos();
    }

    @Override
    public PluginPackageInfo[] getAllKnownPluginPackageInfos() throws Exception {
        return this._em.getAllKnownPluginPackageInfos();
    }

    @Override
    public PluginPackageInfo[] getDisabledPluginPackageInfos() throws Exception {
        return this._em.getDisabledPluginPackageInfos();
    }

    @Override
    public ExtensionInfo[][] getExtensionHosts(String string) throws Exception {
        return this._em.getExtensionHosts(string);
    }

    @Override
    public Set<IdVersionPair> addPluginPackages(PluginPackageInfo[] pluginPackageInfoArray) throws Exception {
        return this._em.addPluginPackages(pluginPackageInfoArray);
    }

    @Override
    public void updateExtensionObject(String string, Callable<String> callable) throws Exception {
        this._em.updateExtensionObject(string, callable);
    }

    @Override
    public Set<IdVersionPair> deployNewPackages() {
        return this._em.deployNewPackages();
    }

    @Override
    public void undeployPackage(IdVersionPair idVersionPair) {
        this._em.undeployPackage(idVersionPair);
    }

    @Override
    public List<ExtensionInfo> runRemoteFilters(List<ExtensionInfo> list, List<Object> list2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, list2});
        if (list.isEmpty()) {
            throw new IllegalArgumentException("extensionInfos cannot be empty");
        }
        if (list2.isEmpty()) {
            throw new IllegalArgumentException("objects cannot be empty");
        }
        return this._em.runRemoteFilters(list, list2);
    }
}

