/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.ExtensionObjectParser;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.LocalizationMessageSource;
import com.vmware.vise.util.i18n.ResourceInfo;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class I18nManagerImpl
implements I18nManager {
    private static final Log _logger = LogFactory.getLog(I18nManagerImpl.class);
    private final ExtensionService _extensionService;
    private Map<String, Map<String, Map<String, String>>> _resourcesByBundleByLocales = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
    private Map<String, List<IdVersionPair>> _processedPluginsByLocale = new ConcurrentHashMap<String, List<IdVersionPair>>();
    private ConcurrentHashMap<String, ReentrantLock> _locksByLocale = new ConcurrentHashMap();

    public I18nManagerImpl(ExtensionService extensionService) {
        this._extensionService = extensionService;
        this._locksByLocale.put(ResourceUtil.DEFAULT_LOCALE.toString(), new ReentrantLock());
    }

    public void initialize() {
        ExtensionObjectParser.i18nManager = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResources(Locale locale) {
        locale = this.getLocale(locale);
        String string = locale.toString();
        ReentrantLock reentrantLock = this.getLock(string);
        reentrantLock.lock();
        try {
            this.loadResourcesInternal(locale);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> getResourceMap(Locale locale) {
        locale = this.getLocale(locale);
        String string = locale.toString();
        ReentrantLock reentrantLock = this.getLock(string);
        reentrantLock.lock();
        Map<String, Map<String, String>> map = null;
        try {
            this.loadResourcesInternal(locale);
            map = this._resourcesByBundleByLocales.get(string);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        finally {
            reentrantLock.unlock();
        }
        return map;
    }

    private void loadResourcesInternal(Locale locale) throws Exception {
        locale = this.getLocale(locale);
        String string = locale.toString();
        PluginInfo[] pluginInfoArray = this._extensionService.getPluginInfos();
        List<IdVersionPair> list = null;
        if (this._resourcesByBundleByLocales.containsKey(string) && !this.checkIfResourcesStale(pluginInfoArray, list = this._processedPluginsByLocale.get(string))) {
            return;
        }
        Map<String, Map<String, String>> map = this._resourcesByBundleByLocales.get(string);
        if (map == null) {
            map = new HashMap<String, Map<String, String>>();
            this._resourcesByBundleByLocales.put(string, map);
            list = new ArrayList<IdVersionPair>();
            this._processedPluginsByLocale.put(string, list);
        }
        for (PluginInfo pluginInfo : pluginInfoArray) {
            if (list.contains(pluginInfo.getPluginRef())) continue;
            this.loadResourcesForPlugin(pluginInfo, locale, list, map);
        }
    }

    private void loadResourcesForPlugin(PluginInfo pluginInfo, Locale locale, List<IdVersionPair> list, Map<String, Map<String, String>> map) {
        String[] stringArray;
        this.processPluginResourceInfo(pluginInfo);
        if (pluginInfo.getResourceInfo() == null || pluginInfo.getResourceInfo().resourceBundleNames == null) {
            list.add(pluginInfo.getPluginRef());
            return;
        }
        String string = null;
        PluginPackageInfo pluginPackageInfo = null;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(pluginInfo.getPackageRef());
        }
        catch (Exception exception) {
            _logger.error((Object)("No plugin package ref found for " + pluginInfo.getId()), (Throwable)exception);
        }
        String[] stringArray2 = null;
        if (pluginPackageInfo != null && pluginPackageInfo.isRemotePlugin()) {
            string = this.getBaseBundleUrlForRemotePlugin(pluginPackageInfo, pluginInfo);
            stringArray2 = pluginPackageInfo.getSslThumbprints();
        } else {
            string = I18nManagerImpl.getBaseBundleUrl(pluginInfo);
        }
        for (String string2 : stringArray = pluginInfo.getResourceInfo().resourceBundleNames) {
            String string3 = string + string2;
            LocalizationMessageSource localizationMessageSource = new LocalizationMessageSource(stringArray2, string3);
            localizationMessageSource.setFallbackToSystemLocale(false);
            Properties properties = localizationMessageSource.getProperties(locale);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
            map.put(string2, hashMap);
        }
        list.add(pluginInfo.getPluginRef());
    }

    private ReentrantLock getLock(String string) {
        ReentrantLock reentrantLock;
        ReentrantLock reentrantLock2 = this._locksByLocale.get(string);
        if (reentrantLock2 == null && (reentrantLock = this._locksByLocale.putIfAbsent(string, reentrantLock2 = new ReentrantLock())) != null) {
            reentrantLock2 = reentrantLock;
        }
        return reentrantLock2;
    }

    private static String getBaseBundleUrl(PluginInfo pluginInfo) {
        String string;
        String string2 = pluginInfo.getManifestUrl().toString();
        String string3 = string = string2.replace("plugin.xml", "");
        string3 = I18nManagerImpl.addBaseUrlOfResourceInfo(pluginInfo, string3);
        return string3;
    }

    private boolean checkIfResourcesStale(PluginInfo[] pluginInfoArray, List<IdVersionPair> list) {
        for (PluginInfo pluginInfo : pluginInfoArray) {
            if (list.contains(pluginInfo.getPluginRef())) continue;
            return true;
        }
        return false;
    }

    private Locale getLocale(Locale locale) {
        if (locale == null) {
            return ResourceUtil.DEFAULT_LOCALE;
        }
        return locale;
    }

    private void processPluginResourceInfo(PluginInfo pluginInfo) {
        if (pluginInfo.getResourceInfo() != null) {
            return;
        }
        this.parsePluginResourceXml(pluginInfo.getResourceXml(), pluginInfo);
    }

    private void parsePluginResourceXml(Document document, PluginInfo pluginInfo) {
        if (document == null) {
            return;
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ResourceInfo.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            ResourceInfo resourceInfo = (ResourceInfo)unmarshaller.unmarshal((Source)new DOMSource(document));
            if (pluginInfo.getDefaultBundle() != null && (ArrayUtil.isNullOrEmpty((Object[])resourceInfo.resourceBundleNames) || resourceInfo.resourceBundleNames[0].matches("[\\s]*"))) {
                resourceInfo.resourceBundleNames = new String[]{pluginInfo.getDefaultBundle()};
                if (resourceInfo.baseUrl == null) {
                    resourceInfo.baseUrl = "locales/";
                }
                _logger.info((Object)("Converted plugin " + pluginInfo.getId() + " to use resource bundle " + pluginInfo.getDefaultBundle()));
            }
            pluginInfo.setResourceInfo(resourceInfo);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when parsing resource xml for plugin - " + pluginInfo.getId()), (Throwable)exception);
        }
    }

    private String getBaseBundleUrlForRemotePlugin(PluginPackageInfo pluginPackageInfo, PluginInfo pluginInfo) {
        ConcurrentMap<String, Object> concurrentMap = pluginPackageInfo.getMetadata();
        Map map = (Map)concurrentMap.get("pluginRegistrationUrlByServer");
        String string = (String)map.values().iterator().next() + "/";
        string = I18nManagerImpl.addBaseUrlOfResourceInfo(pluginInfo, string);
        return string;
    }

    private static String addBaseUrlOfResourceInfo(PluginInfo pluginInfo, String string) {
        ResourceInfo resourceInfo = pluginInfo.getResourceInfo();
        if (!StringUtil.isNullOrEmpty((String)resourceInfo.baseUrl)) {
            string = string + resourceInfo.baseUrl;
            if (!resourceInfo.baseUrl.endsWith("/")) {
                string = string + "/";
            }
        }
        return string;
    }
}

