/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleDeployer;
import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.impl.DeploymentEventLogger;
import com.vmware.vise.extensionfw.impl.PackageDependency;
import com.vmware.vise.extensionfw.impl.PackageDeployData;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Version;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PackagesDeployer {
    private static final int PRODUCTION_DEPLOYMENT_TIMEOUT = 20;
    private static final TimeUnit PRODUCTION_DEPLOYMENT_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final String PACKAGE_CLIENT_DEPENDENCY = "com.vmware.vsphere.client";
    private static final Log _logger = LogFactory.getLog(PackagesDeployer.class);
    protected int deploymentTimeout = 20;
    protected TimeUnit deploymentTimeoutUnit = PRODUCTION_DEPLOYMENT_TIMEOUT_UNIT;
    protected CompletionService<Boolean> completionService;
    private final List<PackageDeployData> _deployData;
    private final BundleDeployer _bundleDeployer;
    private final Set<IdVersionPair> _deployedPackages;
    private final Set<IdVersionPair> _deployedBundles;
    private final DeploymentEventLogger _eventLogger;

    public static Set<IdVersionPair> deploy(ExecutorService executorService, BundleDeployer bundleDeployer, List<PackageDeployData> list, Set<IdVersionPair> set, Set<IdVersionPair> set2, DeploymentEventLogger deploymentEventLogger) {
        PackagesDeployer packagesDeployer = new PackagesDeployer(executorService, bundleDeployer, list, set, set2, deploymentEventLogger);
        return packagesDeployer.deploy();
    }

    protected PackagesDeployer(ExecutorService executorService, BundleDeployer bundleDeployer, List<PackageDeployData> list, Set<IdVersionPair> set, Set<IdVersionPair> set2, DeploymentEventLogger deploymentEventLogger) {
        this.completionService = new ExecutorCompletionService<Boolean>(executorService);
        this._bundleDeployer = bundleDeployer;
        this._deployData = list;
        this._deployedPackages = set;
        this._deployedBundles = set2;
        this._eventLogger = deploymentEventLogger;
    }

    protected Set<IdVersionPair> deploy() {
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        Collection<PackageDeployData> collection = this.reducePackagesToDeploy();
        IdentityHashMap<Future<Boolean>, IdVersionPair> identityHashMap = new IdentityHashMap<Future<Boolean>, IdVersionPair>();
        while (!collection.isEmpty()) {
            Collection<PackageDeployData> collection2 = this.extractReadyPackages(collection);
            if (collection2.isEmpty() && identityHashMap.isEmpty()) {
                this.logUnsatisfiedDependencies(collection);
                collection.clear();
                continue;
            }
            collection.removeAll(collection2);
            Map<Future<Boolean>, IdVersionPair> object = this.enquePackageDeployments((Iterable<PackageDeployData>)collection2);
            identityHashMap.putAll(object);
            if (identityHashMap.isEmpty()) continue;
            try {
                Future<Boolean> future = this.waitForCompletedDeployment();
                if (future == null) {
                    _logger.error((Object)("Package deployer timed out waiting for " + PackagesDeployer.buildPackageListString(identityHashMap.values())));
                    this.cancelPendingDeployments(identityHashMap);
                    continue;
                }
                IdVersionPair idVersionPair = (IdVersionPair)identityHashMap.get(future);
                identityHashMap.remove(future);
                this.processDeploymentCompletion(future, idVersionPair, hashSet);
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)("Package deployment interrupted for " + PackagesDeployer.buildPackageListString(identityHashMap.values())), (Throwable)interruptedException);
                this.cancelPendingDeployments(identityHashMap);
            }
        }
        for (Map.Entry entry : identityHashMap.entrySet()) {
            this.processDeploymentCompletion((Future)entry.getKey(), (IdVersionPair)entry.getValue(), hashSet);
        }
        return hashSet;
    }

    private Collection<PackageDeployData> reducePackagesToDeploy() {
        LinkedList<PackageDeployData> linkedList = new LinkedList<PackageDeployData>();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>(this._deployData.size());
        for (PackageDeployData packageDeployData : this._deployData) {
            if (this.shouldDeployPackage(packageDeployData)) {
                boolean bl;
                boolean bl2 = bl = !hashSet.add(packageDeployData.getPackageRef());
                if (bl) {
                    PackagesDeployer.logDebug("Plugin package '%s' already queued for deployment.", packageDeployData.getPackageRef());
                    continue;
                }
                linkedList.add(packageDeployData);
                continue;
            }
            PackagesDeployer.logDebug("Plugin package '%s' already deployed.", packageDeployData.getPackageRef());
        }
        return linkedList;
    }

    private Collection<PackageDeployData> extractReadyPackages(Collection<PackageDeployData> collection) {
        ArrayList<PackageDeployData> arrayList = new ArrayList<PackageDeployData>(collection.size());
        for (PackageDeployData packageDeployData : collection) {
            Collection<PackageDependency> collection2 = this.extractUnsatisfiedPackageDependencies(packageDeployData);
            if (!collection2.isEmpty()) continue;
            arrayList.add(packageDeployData);
        }
        return arrayList;
    }

    private Collection<PackageDependency> extractUnsatisfiedPackageDependencies(PackageDeployData packageDeployData) {
        assert (packageDeployData != null);
        assert (packageDeployData.getPackageInfo() != null);
        assert (packageDeployData.getManifest() != null);
        assert (packageDeployData.getManifest().dependencies != null);
        ArrayList<PackageDependency> arrayList = new ArrayList<PackageDependency>(packageDeployData.getManifest().dependencies.size());
        for (PackageDependency packageDependency : packageDeployData.getManifest().dependencies) {
            if (this.isDependencySatisfied(packageDependency)) continue;
            arrayList.add(packageDependency);
        }
        return arrayList;
    }

    private void logUnsatisfiedDependencies(Collection<PackageDeployData> collection) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("Could not resolve dependencies for plugins packages: ");
        for (PackageDeployData packageDeployData : collection) {
            stringBuilder.append("[ ");
            stringBuilder.append(packageDeployData.getPackageRef());
            stringBuilder.append(" requires: ");
            for (PackageDependency packageDependency : this.extractUnsatisfiedPackageDependencies(packageDeployData)) {
                if (!bl) {
                    bl = !PACKAGE_CLIENT_DEPENDENCY.equals(packageDependency.id);
                }
                stringBuilder.append("[ ");
                stringBuilder.append(packageDependency.id);
                stringBuilder.append(" ");
                stringBuilder.append(packageDependency.matchPolicy);
                stringBuilder.append(" ");
                stringBuilder.append(packageDependency.version);
                stringBuilder.append(" ]; ");
            }
            stringBuilder.append("]; ");
        }
        if (bl) {
            _logger.error((Object)stringBuilder.toString());
        } else {
            _logger.info((Object)stringBuilder.toString());
        }
    }

    private Map<Future<Boolean>, IdVersionPair> enquePackageDeployments(Iterable<PackageDeployData> iterable) {
        HashMap<Future<Boolean>, IdVersionPair> hashMap = new HashMap<Future<Boolean>, IdVersionPair>();
        for (PackageDeployData packageDeployData : iterable) {
            PackagesDeployer.logDebug("Enqueueing deployment of package %s", packageDeployData.getPackageRef());
            try {
                Future<Boolean> future = this.completionService.submit(new PackageDeployTask(packageDeployData));
                hashMap.put(future, packageDeployData.getPackageRef());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                _logger.error((Object)String.format("Could not enqueue deployment of package " + packageDeployData.getPackageRef(), new Object[0]));
            }
        }
        return hashMap;
    }

    private Future<Boolean> waitForCompletedDeployment() throws InterruptedException {
        return this.completionService.poll(this.deploymentTimeout, this.deploymentTimeoutUnit);
    }

    private void cancelPendingDeployments(Map<Future<Boolean>, IdVersionPair> map) {
        for (Future<Boolean> future : map.keySet()) {
            future.cancel(true);
        }
        map.clear();
    }

    private static String buildPackageListString(Iterable<IdVersionPair> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IdVersionPair idVersionPair : iterable) {
            stringBuilder.append(idVersionPair);
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    private void processDeploymentCompletion(Future<Boolean> future, IdVersionPair idVersionPair, Set<IdVersionPair> set) {
        boolean bl = this.processDeploymentResult(idVersionPair, future);
        if (bl) {
            set.add(idVersionPair);
            this._deployedPackages.add(idVersionPair);
        }
    }

    private boolean processDeploymentResult(IdVersionPair idVersionPair, Future<Boolean> future) {
        PackagesDeployer.logDebug("Processing deployment result for '%s'.", idVersionPair);
        boolean bl = false;
        try {
            bl = future.get(this.deploymentTimeout, this.deploymentTimeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            _logger.error((Object)String.format("Deployment of plugin package '%s' failed.", idVersionPair), (Throwable)exception);
            bl = false;
        }
        if (bl) {
            _logger.info((Object)String.format("Processed deployment success for plugin package '%s'.", idVersionPair));
        } else {
            _logger.info((Object)String.format("Processed deployment failure for plugin package '%s'.", idVersionPair));
        }
        return bl;
    }

    private boolean shouldDeployPackage(PackageDeployData packageDeployData) {
        return !this._deployedPackages.contains(packageDeployData.getPackageRef());
    }

    private boolean deployPlugin(PackageDeployData packageDeployData) {
        IdVersionPair idVersionPair = packageDeployData.getPackageRef();
        this._eventLogger.info(DeploymentEventLogger.Event.PACKAGE_DEPLOY_BEGIN, idVersionPair.getId(), idVersionPair.getVersion());
        boolean bl = packageDeployData.getPackageInfo().isRemotePlugin() ? this.deployRemotePlugin(packageDeployData) : this.deployInternalPlugin(packageDeployData, packageDeployData.getBundlesInfo());
        if (bl) {
            this._eventLogger.info(DeploymentEventLogger.Event.PACKAGE_DEPLOY_END, idVersionPair.getId(), idVersionPair.getVersion());
        } else {
            this._eventLogger.error(DeploymentEventLogger.Event.PACKAGE_DEPLOY_FAIL, idVersionPair.getId(), idVersionPair.getVersion());
        }
        return bl;
    }

    private boolean deployRemotePlugin(PackageDeployData packageDeployData) {
        File file = packageDeployData.getPackageDir();
        File file2 = Paths.get(file.toString(), "plugin.xml").toFile();
        if (!file2.exists()) {
            return false;
        }
        try {
            ExtensionManager.getInstance().addPlugin(file2.toURI().toURL(), null, packageDeployData.getPackageRef(), null);
            return true;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error processing script plugin package - " + packageDeployData.getPackageInfo().getId()), (Throwable)exception);
            return false;
        }
    }

    private boolean deployInternalPlugin(PackageDeployData packageDeployData, List<BundleInfo> list) {
        ArrayList<BundleInfo> arrayList = new ArrayList<BundleInfo>(list.size());
        for (BundleInfo bundleInfo : list) {
            IdVersionPair idVersionPair = bundleInfo.getBundleRef();
            if (!this._deployedBundles.add(idVersionPair)) continue;
            arrayList.add(bundleInfo);
        }
        try {
            this._bundleDeployer.deploy(arrayList);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error deploying one of more bundles for the plugin package " + packageDeployData.getPackageDir()), (Throwable)exception);
            return false;
        }
        return true;
    }

    protected boolean isDependencySatisfied(PackageDependency packageDependency) {
        if (packageDependency == null) {
            throw new IllegalArgumentException("Parameter dependency is required.");
        }
        return this.matchDependency(this._deployedPackages, packageDependency);
    }

    private static void logDebug(String string, Object object) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format(string, object));
        }
    }

    private boolean matchDependency(Set<IdVersionPair> set, PackageDependency packageDependency) {
        for (IdVersionPair idVersionPair : set) {
            if (!this.matchDependency(idVersionPair, packageDependency)) continue;
            return true;
        }
        return false;
    }

    private boolean matchDependency(IdVersionPair idVersionPair, PackageDependency packageDependency) {
        Version version;
        Version version2;
        if (!packageDependency.id.equals(idVersionPair.getId())) {
            return false;
        }
        if (packageDependency.version == null) {
            return true;
        }
        try {
            version2 = new Version(idVersionPair.getVersion());
            version = new Version(packageDependency.version);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return false;
        }
        String string = packageDependency.matchPolicy;
        if (string.equals("equal")) {
            return version2.major == version.major && version2.minor == version.minor && version2.revision >= version.revision;
        }
        boolean bl = false;
        int n = version2.compareTo(version);
        if (string.equals("greaterOrEqual")) {
            bl = n >= 0;
        } else if (string.equals("greaterThan")) {
            bl = n > 0;
        } else if (string.equals("lessOrEqual")) {
            bl = n <= 0;
        } else if (string.equals("lessThan")) {
            bl = n < 0;
        }
        return bl;
    }

    private class PackageDeployTask
    implements Callable<Boolean> {
        private final PackageDeployData _deployData;

        public PackageDeployTask(PackageDeployData packageDeployData) {
            this._deployData = packageDeployData;
        }

        @Override
        public Boolean call() {
            IdVersionPair idVersionPair = this._deployData.getPackageRef();
            _logger.info((Object)String.format("Deploying plugin package '%s'.", idVersionPair));
            boolean bl = PackagesDeployer.this.deployPlugin(this._deployData);
            if (bl) {
                _logger.info((Object)String.format("Deployed plugin package '%s'.", idVersionPair));
            }
            return bl;
        }
    }
}

