/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.PluginDependencyType;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.extensionfw.impl.PluginManifest;
import com.vmware.vise.extensionfw.impl.RelationViewExtensionInfoCreator;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PluginManifestParser {
    private final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private boolean _useH5MetadataParser;
    private final RelationViewExtensionInfoCreator _relationViewExtensionInfoCreator;
    private static final Log _logger = LogFactory.getLog(PluginManifestParser.class);
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Pattern COLUMN_TAIL_PATTERN = Pattern.compile("</com.vmware.ui.lists.ColumnDataSourceInfo>.*", 32);
    private static final Pattern ACTION_TAIL_PATTERN = Pattern.compile("</com.vmware.actionsfw.ActionSpec>.*", 32);
    private static final Pattern PROP_PATTERN = Pattern.compile("<requestedProperties>(.*)<");
    private static final Pattern SORT_PATTERN = Pattern.compile("<sortProperty>(.*)<");
    private static final Pattern UID_PATTERN = Pattern.compile("<uid>(.*)<");
    private static final Pattern ACTIONURL_PATTERN = Pattern.compile("<actionUrl>(.*)<");
    private static final Pattern DIALOGTITLE_PATTERN = Pattern.compile("<dialogTitle>(.*)<");
    private static final Pattern DIALOGSIZE_PATTERN = Pattern.compile("<dialogSize>(.*)<");
    private static final Pattern DIALOGICON_PATTERN = Pattern.compile("<dialogIcon>(.*)<");
    private static final Pattern PLUGIN_ACTION_URL = Pattern.compile("<url>(.*)<");
    private static final Pattern MODAL_PATTERN = Pattern.compile("<modal>((.|" + LINE_SEPARATOR + ")*)</modal>");
    private static final Pattern MODAL_TITLE_PATTERN = Pattern.compile("<title>(.*)<");
    private static final Pattern MODAL_SIZE_PATTERN = Pattern.compile("<size>(.*)<");
    private static final Pattern MODAL_CLOSABLE_PATTERN = Pattern.compile("<closable>(.*)<");

    public PluginManifestParser(boolean bl) {
        this._useH5MetadataParser = bl;
        this._relationViewExtensionInfoCreator = new RelationViewExtensionInfoCreator();
    }

    public PluginManifest getPluginManifest(URL uRL, String string, String string2, Map<String, String> map, Set<PluginDependencyType> set, boolean bl) throws IOException {
        Element element;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this._builderFactorySource.createDocumentBuilder();
            document = documentBuilder.parse(uRL.toString());
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        PluginManifest pluginManifest = new PluginManifest();
        String string3 = XMLUtil.getAttribute((Element)element, (String)"id");
        if (string3 != null) {
            string = string3;
        }
        if (string == null) {
            throw new IOException("The plugin manifest at " + uRL + " should specify a plugin id attribute.");
        }
        IdVersionPair idVersionPair = new IdVersionPair(string, string2);
        String string4 = XMLUtil.getAttribute((Element)element, (String)"type");
        if (string4 != null) {
            pluginManifest.pluginType = string4;
        }
        pluginManifest.pluginId = string;
        pluginManifest.securityPolicyURI = XMLUtil.getAttribute((Element)element, (String)"securityPolicyUri");
        pluginManifest.moduleURI = XMLUtil.getAttribute((Element)element, (String)"moduleUri");
        if (this._useH5MetadataParser && pluginManifest.moduleURI != null && !this.hasHtmlViewOrAction(element)) {
            _logger.warn((Object)("Ignoring plugin " + string + " because it doesn't contain any HTML view or action"));
            return null;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"resources");
        if (element2 != null) {
            Document document2 = documentBuilder.newDocument();
            document2.appendChild(document2.importNode(element2, true));
            pluginManifest.resourceXml = document2;
        }
        pluginManifest.defaultBundle = XMLUtil.getAttribute((Element)element, (String)"defaultBundle");
        pluginManifest.extensionPoints = this.getExtensionPointInfos(element, idVersionPair);
        pluginManifest.extensions = this.getExtensionInfos(element, idVersionPair, document, map, bl);
        pluginManifest.templateInfos = this.getTemplateInfos(element, idVersionPair);
        pluginManifest.templateInstanceInfos = this.getTemplateInstanceInfos(element, idVersionPair);
        pluginManifest.exportedClasses = this.getExportedClasses(element);
        pluginManifest.dependencies = this.getDependencies(XMLUtil.getChildTag((Node)element, (String)"dependencies"), set);
        pluginManifest.metadata = PackageManifestParser.parseMetadata(element);
        return pluginManifest;
    }

    private boolean hasHtmlViewOrAction(Element element) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extension");
        for (Element element2 : list) {
            String string = XMLUtil.xmlToString((Node)element2);
            if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
                return true;
            }
            if (!string.contains("com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate")) continue;
            return true;
        }
        return false;
    }

    public List<ExtensionPointInfo> getExtensionPointInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extensionPoint");
        ArrayList<ExtensionPointInfo> arrayList = new ArrayList<ExtensionPointInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The extensionPoint tag should specify an id attribute.");
            }
            String string2 = null;
            Element element3 = XMLUtil.getChildTag((Node)element2, (String)"objectType");
            if (element3 != null) {
                string2 = XMLUtil.getAttribute((Element)element3, (String)"class");
            }
            if (string2 == null) {
                throw new IOException("The extension-point " + string + " should specify an objectType tag with a class attribute.");
            }
            ExtensionPointInfo extensionPointInfo = new ExtensionPointInfo();
            extensionPointInfo.setId(string);
            extensionPointInfo.setPluginRef(idVersionPair);
            extensionPointInfo.setObjectType(string2);
            arrayList.add(extensionPointInfo);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<ExtensionInfo> getExtensionInfos(Element element, IdVersionPair idVersionPair, Document document, Map<String, String> map, boolean bl) throws IOException {
        Object object;
        List list = XMLUtil.getChildTags((Node)element, (String)"extension");
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>(list.size());
        HashMap<Object, Element> hashMap = new HashMap<Object, Element>();
        for (Element element2 : list) {
            List<Pair<String, String>> list2;
            boolean bl2;
            String string;
            String string2;
            String[] stringArray;
            block29: {
                Element element3;
                object = XMLUtil.getAttribute((Element)element2, (String)"id");
                if (object == null) {
                    throw new IOException("The extension tag should specify an extension id.");
                }
                stringArray = this.getTagValues(element2, "extendedPoint");
                if (stringArray == null) {
                    throw new IOException("The extension tag should specify an extendedPoint tag.");
                }
                if (this._useH5MetadataParser) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        string2 = stringArray[i];
                        if (!string2.endsWith(".html")) continue;
                        stringArray[i] = string2.substring(0, string2.lastIndexOf(".html"));
                    }
                }
                if ((element3 = XMLUtil.getChildTag((Node)element2, (String)"object")) == null) {
                    throw new IOException("The extension tag should have a nested object tag.");
                }
                string2 = XMLUtil.getAttribute((Element)element3, (String)"type");
                element3.removeAttribute("type");
                string = XMLUtil.xmlToString((Node)element3);
                bl2 = true;
                list2 = null;
                if (this._useH5MetadataParser) {
                    if (bl || map != null && !this.isCoreVsphereClientPackageId(map) && "plugin".equalsIgnoreCase(element.getTagName())) {
                        string = string.replaceAll("(<contentSpec>)", "<contentSpec><sandbox>true</sandbox>");
                    }
                    if (string.contains("<componentClass")) {
                        if ((string = this.convertComponentClassXml(string, (String)object, idVersionPair)) == null) {
                            _logger.warn((Object)("Ignoring Flex view id " + (String)object + " in plugin " + idVersionPair.getId()));
                            continue;
                        }
                    } else if (string.contains("com.vmware.ui.lists.ColumnContainer")) {
                        bl2 = false;
                        list2 = this.convertColumnContainerXml(string, (String)object);
                    } else if (stringArray[0].equals("vise.actions.specs")) {
                        string = this.convertActionsSpecs(string, (String)object);
                    } else {
                        if (stringArray[0].equals("vise.actions.sets")) {
                            bl2 = false;
                            if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate")) {
                                string = this.convertRootPath(string, "<actionUrl>", (String)object, idVersionPair);
                                list2 = this.convertActionSet(string, (String)object);
                                stringArray = new String[]{"vise.actions.specs"};
                                break block29;
                            } else {
                                _logger.warn((Object)("Ignoring Flex actions set id " + (String)object + " in plugin " + idVersionPair.getId()));
                                continue;
                            }
                        }
                        if (stringArray[0].equals("vsphere.core.menus.solutionMenus")) {
                            string = this.convertSolutionMenus(string, (String)object, idVersionPair);
                            stringArray = new String[]{"vise.menus.context.solutionMenus"};
                        } else if (stringArray[0].equals("vise.relateditems.specs")) {
                            string = this.convertRelatedItems(string);
                            hashMap.put(object, element3);
                        } else if (string.contains("<viewOpenedUponFocus")) {
                            string = this.convertViewOpenedUponFocus(document, element3);
                        } else if (stringArray[0].contains("manageCategories")) {
                            stringArray = new String[]{stringArray[0].replace("manageCategories", "manage.settingsCategories")};
                        }
                    }
                }
            }
            if (bl2) {
                ExtensionInfo extensionInfo = this.createExtensionInfo(element2, (String)object, stringArray, idVersionPair, string2, string);
                this.addMetadata(extensionInfo, document, element2, map);
                arrayList.add(extensionInfo);
                continue;
            }
            for (Pair pair : list2) {
                String string3 = (String)pair.first;
                String string4 = (String)pair.second;
                ExtensionInfo extensionInfo = this.createExtensionInfo(element2, string3, stringArray, idVersionPair, string2, string4);
                this.addMetadata(extensionInfo, document, element2, map);
                arrayList.add(extensionInfo);
            }
        }
        if (!hashMap.isEmpty() && this._useH5MetadataParser && !bl && this.isVSphereClientModulePackageId(map)) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = this._relationViewExtensionInfoCreator.createRelationViewExtensionInfos((String)entry.getKey(), (Element)entry.getValue(), idVersionPair, map, document);
                arrayList.addAll((Collection<ExtensionInfo>)object);
            }
        }
        return arrayList;
    }

    private boolean isCoreVsphereClientPackageId(Map<String, String> map) {
        String string = map.get("pluginPackageId");
        if (string instanceof String) {
            String string2 = string;
            return ArrayUtil.contains((Object)string2, (Object[])PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS);
        }
        return false;
    }

    private boolean isVSphereClientModulePackageId(Map<String, String> map) {
        String string;
        if (map == null) {
            return false;
        }
        String string2 = map.get("pluginPackageId");
        return string2 instanceof String && ("com.vmware.vsphere.client".equals(string = string2) || "com.vmware.vsphere.client.html".equals(string));
    }

    private ExtensionInfo createExtensionInfo(Element element, String string, String[] stringArray, IdVersionPair idVersionPair, String string2, String string3) throws IOException {
        String[] stringArray2 = this.getTagValues(element, "hostedPoint");
        ExtensionInfo extensionInfo = new ExtensionInfo();
        extensionInfo.setId(string);
        extensionInfo.setExtendedPointIds(stringArray);
        extensionInfo.setHostedPointsIds(stringArray2);
        extensionInfo.setPluginRef(idVersionPair);
        extensionInfo.setObjectType(string2);
        extensionInfo.setObjectXmlStr(string3);
        extensionInfo.setPrecedingIds(this.getPrecedingExtensions(element));
        return extensionInfo;
    }

    private void addMetadata(ExtensionInfo extensionInfo, Document document, Element element, Map<String, String> map) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"metadata");
        if (map != null) {
            if (element2 == null) {
                element2 = document.createElement("metadata");
            }
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Element element3 = document.createElement(string);
                Text text = document.createTextNode((String)entry.getValue());
                element3.appendChild(text);
                element2.appendChild(element3);
            }
        }
        if (element2 != null) {
            String string = XMLUtil.xmlToString((Node)element2);
            extensionInfo.setMetadataXmlStr(string);
        }
    }

    private String convertSolutionMenus(String string, String string2, IdVersionPair idVersionPair) {
        string = string.replaceAll("<children>", "<type>MENU</type>\n  <children>");
        string = string.replaceAll("<Array>", "");
        string = string.replaceAll("</Array>", "");
        string = string.replaceAll("com.vmware.actionsfw.ActionMenuItemSpec", "object");
        string = string.replaceAll("<type>action</type>", "<type>ACTION</type>");
        string = string.replaceAll("<type>separator</type>", "<type>SEPARATOR</type>");
        return string;
    }

    private String convertRelatedItems(String string) {
        String string2 = "com.vmware.ui.relateditems.model.RelationSpec";
        if (!string.contains(string2)) {
            return string;
        }
        string = string.replaceAll("<relationSpecs>", "");
        string = string.replaceAll("</relationSpecs>", "");
        string = string.replaceAll(string2, "relationSpecs");
        return string;
    }

    private String convertComponentClassXml(String string, String string2, IdVersionPair idVersionPair) {
        if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
            string = string.replaceAll("componentClass", "contentSpec");
            string = string.replaceAll("<object>[\\s]*<root>", "");
            string = string.replaceAll("</root>[\\s]*</object>", "<sandbox>true</sandbox>");
            string = this.convertRootPath(string, "<url>", string2, idVersionPair);
        } else if (string.contains("<componentClass")) {
            return null;
        }
        return string;
    }

    private String convertRootPath(String string, String string2, String string3, IdVersionPair idVersionPair) {
        String string4 = string2 + "/ui/";
        String string5 = string2 + "/vsphere-client/";
        if (string.contains(string5)) {
            string = string.replaceAll(string5, string4);
        } else if (string.contains(string4)) {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' should not hard-code URL path '/ui/' in extension: " + string3 + ",\n it should either be a relative path (plugin-name/...), or start with /vsphere-client/plugin-name for Flex client compatibility."));
        } else {
            _logger.warn((Object)("Plugin '" + idVersionPair.getId() + "' is missing URL path '/vsphere-client/' in extension: " + string3 + ",\n this is required for Flex client compatibility."));
        }
        return string;
    }

    private List<Pair<String, String>> convertActionSet(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.actionsfw.ActionSpec>");
        for (int i = 1; i < stringArray.length; ++i) {
            String string3 = ACTION_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            Matcher matcher = UID_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <uid> is missing, in extension " + string2));
                continue;
            }
            String string4 = matcher.group(1);
            ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
            matcher = ACTIONURL_PATTERN.matcher(string3);
            if (!matcher.find()) {
                _logger.error((Object)("Skipping ActionSpec because <actionUrl> is missing, in extension " + string2));
                continue;
            }
            arrayList2.add(new Pair((Object)"actionUrl", (Object)matcher.group(1)));
            matcher = DIALOGTITLE_PATTERN.matcher(string3);
            if (matcher.find()) {
                arrayList2.add(new Pair((Object)"dialogTitle", (Object)matcher.group(1)));
            }
            if ((matcher = DIALOGSIZE_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"dialogSize", (Object)matcher.group(1)));
            }
            if ((matcher = DIALOGICON_PATTERN.matcher(string3)).find()) {
                arrayList2.add(new Pair((Object)"dialogIcon", (Object)matcher.group(1)));
            }
            string3 = string3 + "\n<additionalData>";
            for (Pair pair : arrayList2) {
                string3 = string3 + "\n<entry><key>" + (String)pair.first + "</key>";
                string3 = string3 + "\n<value>" + (String)pair.second + "</value></entry>";
            }
            string3 = string3 + "\n</additionalData>";
            string3 = string3 + "\n<invoker>com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate</invoker>";
            string3 = string3.replaceAll("conditionalProperty>", "availabilityProperty>");
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private List<Pair<String, String>> convertColumnContainerXml(String string, String string2) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        String[] stringArray = string.split("<com.vmware.ui.lists.ColumnDataSourceInfo>");
        int n = 1;
        for (int i = 1; i < stringArray.length; ++i) {
            Matcher matcher;
            String string3 = COLUMN_TAIL_PATTERN.matcher(stringArray[i]).replaceAll("");
            if (string3.contains("<String>")) {
                string3 = string3.replaceAll("<requestedProperties>[\\s]*<String>(.*)</String>[\\s]*<", "<requestedProperties>$1<");
            }
            if ((matcher = SORT_PATTERN.matcher(string3 = (matcher = PROP_PATTERN.matcher(string3)).find() && "name".equals(matcher.group(1)) ? string3.replace("<requestedProperties>name</requestedProperties>", "<requestedProperties>id</requestedProperties>\n<requestedProperties>primaryIconId</requestedProperties>\n<requestedProperties>name</requestedProperties>\n<requestedProperties>labelIds</requestedProperties>\n<columnRenderer>object-name</columnRenderer>") : string3.replace("</requestedProperties>", "</requestedProperties>\n<columnRenderer>text</columnRenderer>"))).find() && "name".equals(matcher.group(1))) {
                string3 = string3 + "\n<width>250</width>";
                string3 = string3 + "\n<sortedByDefault>true</sortedByDefault>";
            }
            string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<object>" + string3 + "\n</object>";
            String string4 = string2 + '_' + n++;
            arrayList.add((Pair<String, String>)new Pair((Object)string4, (Object)string3));
        }
        return arrayList;
    }

    private String[] getTagValues(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = XMLUtil.getTagValue((Element)element2);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    private Set<String> getPrecedingExtensions(Element element) {
        NodeList nodeList = element.getElementsByTagName("precedingExtension");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getTagValue((Element)element2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private List<TemplateInfo> getTemplateInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"template");
        ArrayList<TemplateInfo> arrayList = new ArrayList<TemplateInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The template tag should specify a template id.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"inheritedTemplate");
            String string3 = XMLUtil.xmlToString((Node)element2);
            TemplateVariableInfo[] templateVariableInfoArray = this.getTemplateVariableInfos(element2);
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setId(string);
            templateInfo.setInheritedTemplateId(string2);
            templateInfo.setPluginRef(idVersionPair);
            templateInfo.setVariableInfos(templateVariableInfoArray);
            templateInfo.setTemplateXmlStr(string3);
            arrayList.add(templateInfo);
        }
        return arrayList;
    }

    private List<TemplateInstanceInfo> getTemplateInstanceInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"templateInstance");
        ArrayList<TemplateInstanceInfo> arrayList = new ArrayList<TemplateInstanceInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The templateInstance tag should specify an id attribute.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"templateId");
            if (string2 == null) {
                throw new IOException("The templateInstance tag should specify a templateId child node.");
            }
            Pair<String, String>[] pairArray = this.getTemplateInstanceVariables(element2);
            String[] stringArray = this.getTagValues(element2, "excludedExtension");
            TemplateInstanceInfo templateInstanceInfo = new TemplateInstanceInfo();
            templateInstanceInfo.setId(string);
            templateInstanceInfo.setTemplateId(string2);
            templateInstanceInfo.setPluginRef(idVersionPair);
            templateInstanceInfo.setVariableNameValues(pairArray);
            templateInstanceInfo.setExcludedExtensionIds(stringArray);
            arrayList.add(templateInstanceInfo);
        }
        return arrayList;
    }

    private List<String> getExportedClasses(Element element) {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"export");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element.getElementsByTagName("class");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"name");
            arrayList.add(string);
        }
        return arrayList;
    }

    protected PluginDependency[] getDependencies(Element element, Set<PluginDependencyType> set) throws IOException {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName("dependency");
        int n = nodeList.getLength();
        ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"type");
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"uri");
            if (string == null) {
                throw new IOException("The dependency tag should specify a type attributes.");
            }
            PluginDependencyType pluginDependencyType = PluginDependencyType.fromString(string);
            if (set != null && !set.contains((Object)pluginDependencyType)) {
                throw new IOException("The dependency type '" + string + "' is not supported for this plugin.");
            }
            if (string2 == null) {
                throw new IOException("The dependency tag should specify a uri attributes.");
            }
            PluginDependency pluginDependency = new PluginDependency(string.toLowerCase(), string2);
            arrayList.add(pluginDependency);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PluginDependency[0]);
    }

    private TemplateVariableInfo[] getTemplateVariableInfos(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<TemplateVariableInfo> arrayList = new ArrayList<TemplateVariableInfo>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            boolean bl = XMLUtil.getBooleanAttribute((Element)element2, (String)"required", (boolean)true);
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"defaultValue");
            TemplateVariableInfo templateVariableInfo = new TemplateVariableInfo(string);
            templateVariableInfo.setRequired(bl);
            templateVariableInfo.setDefaultValue(string2);
            arrayList.add(templateVariableInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new TemplateVariableInfo[0]);
    }

    private Pair<String, String>[] getTemplateInstanceVariables(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"value");
            Pair pair = new Pair((Object)string, (Object)string2);
            arrayList.add(pair);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Pair[0]);
    }

    private String convertViewOpenedUponFocus(Document document, Element element) throws IOException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !(element2 = (Element)nodeList.item(i)).getNodeName().equals("viewOpenedUponFocus") || (string = XMLUtil.getAttribute((Element)element2, (String)"className")) == null || !string.equals("com.vmware.ui.objectnavigator.views.CategoryNodeTreeView")) continue;
            element2.removeAttribute("className");
            Element element3 = document.createElement("url");
            element3.appendChild(document.createTextNode("resources/ui/views/objectnavigator/CategoryNodeTreeView.html"));
            element2.appendChild(element3);
        }
        return XMLUtil.xmlToString((Node)element);
    }

    private String convertActionsSpecs(String string, String string2) throws IOException {
        Matcher matcher = MODAL_PATTERN.matcher(string);
        if (matcher.find()) {
            String string3;
            String string4 = matcher.group(1);
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            Matcher matcher2 = PLUGIN_ACTION_URL.matcher(string4);
            if (!matcher2.find()) {
                _logger.error((Object)("Missing <url> inside <modal> in extension: " + string2));
                return string;
            }
            arrayList.add(new Pair((Object)"url", (Object)matcher2.group(1)));
            matcher2 = MODAL_TITLE_PATTERN.matcher(string4);
            if (matcher2.find()) {
                arrayList.add(new Pair((Object)"title", (Object)matcher2.group(1)));
            }
            if ((matcher2 = MODAL_SIZE_PATTERN.matcher(string4)).find() && this.isModalSizeValid(string3 = matcher2.group(1), string2)) {
                arrayList.add(new Pair((Object)"size", (Object)string3));
            }
            if ((matcher2 = MODAL_CLOSABLE_PATTERN.matcher(string4)).find()) {
                arrayList.add(new Pair((Object)"closable", (Object)matcher2.group(1)));
            }
            string3 = LINE_SEPARATOR + "<pluginData>";
            for (Pair pair : arrayList) {
                string3 = string3 + LINE_SEPARATOR + "<entry><key>" + (String)pair.first + "</key>";
                string3 = string3 + LINE_SEPARATOR + "<value>" + (String)pair.second + "</value></entry>";
            }
            string3 = string3 + LINE_SEPARATOR + "<entry><key>headless</key>";
            string3 = string3 + LINE_SEPARATOR + "<value>false</value></entry>";
            string3 = string3 + LINE_SEPARATOR + "</pluginData>";
            string3 = string3 + LINE_SEPARATOR + "<invoker>com.vmware.vsphere.client.pluginActions</invoker>";
            string = string.replaceAll(MODAL_PATTERN.toString(), string3);
        } else {
            Matcher matcher3 = PLUGIN_ACTION_URL.matcher(string);
            if (matcher3.find()) {
                String string5 = LINE_SEPARATOR + "<pluginData>";
                string5 = string5 + LINE_SEPARATOR + "<entry><key>url</key>";
                string5 = string5 + LINE_SEPARATOR + "<value>" + matcher3.group(1) + "</value></entry>";
                string5 = string5 + LINE_SEPARATOR + "<entry><key>headless</key>";
                string5 = string5 + LINE_SEPARATOR + "<value>true</value></entry>";
                string5 = string5 + LINE_SEPARATOR + "</pluginData>";
                string5 = string5 + LINE_SEPARATOR + "<invoker>com.vmware.vsphere.client.pluginActions</invoker>";
                string = string.replaceAll(PLUGIN_ACTION_URL.toString(), string5);
            } else {
                _logger.warn((Object)("Action extension " + string2 + " specifies neither a <modal> tag for a modal dialog, nor a <url> tag for a headless action."));
            }
        }
        return string;
    }

    private boolean isModalSizeValid(String string, String string2) {
        boolean bl = false;
        try {
            String[] stringArray = string.split(",");
            if (stringArray.length == 2) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                if (n > 0 && n2 > 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            _logger.warn((Object)("Wrong format of the <size> property in extension" + string2 + ". The correct format is <size>int,int</size>"));
        }
        return bl;
    }
}

