/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelationViewExtensionInfoCreator {
    private static final Log _logger = LogFactory.getLog(RelationViewExtensionInfoCreator.class);

    public List<ExtensionInfo> createRelationViewExtensionInfos(String string, Element element, IdVersionPair idVersionPair, Map<String, String> map, Document document) throws IOException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, element, idVersionPair, document});
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        RelationObjectInfo relationObjectInfo = new RelationObjectInfo(element, document);
        if (relationObjectInfo.getRelationSpecs().isEmpty() || relationObjectInfo.getRelationsViewId() == null || relationObjectInfo.getTypeValue() == null) {
            return arrayList;
        }
        Map<String, Element> map2 = this.createObjectElements(relationObjectInfo.getRelationSpecs(), document);
        if (map2.isEmpty()) {
            return arrayList;
        }
        Element element2 = this.createMetadataElement(relationObjectInfo.getTypeValue(), relationObjectInfo.getPropertyConstraintElement(), map, document);
        for (Map.Entry<String, Element> entry : map2.entrySet()) {
            ExtensionInfo extensionInfo = new ExtensionInfo();
            extensionInfo.setId(string + "." + entry.getKey());
            extensionInfo.setExtendedPointIds(new String[]{relationObjectInfo.getRelationsViewId()});
            extensionInfo.setPluginRef(idVersionPair);
            extensionInfo.setMetadataXmlStr(XMLUtil.xmlToString((Node)element2));
            extensionInfo.setObjectXmlStr(XMLUtil.xmlToString((Node)entry.getValue()));
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private Element createContentSpec(Document document) {
        Element element = document.createElement("contentSpec");
        Element element2 = XMLUtil.createXmlElement((String)"url", (String)"resources/ui/views/listview/ListView.html", (Document)document);
        element.appendChild(element2);
        return element;
    }

    private Map<String, Element> createObjectElements(List<Element> list, Document document) {
        LinkedHashMap<String, Element> linkedHashMap = new LinkedHashMap<String, Element>();
        for (Element element : list) {
            NodeList nodeList = element.getChildNodes();
            String string = null;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            block12: for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                switch (string2 = element2.getNodeName()) {
                    case "id": {
                        string = XMLUtil.getTagValue((Element)element2);
                        if (string == null) continue block12;
                        Object object = XMLUtil.createXmlElement((String)"relationId", (String)string, (Document)document);
                        arrayList.add((Element)object);
                        continue block12;
                    }
                    case "label": 
                    case "listViewId": {
                        arrayList.add(element2);
                        continue block12;
                    }
                    case "targetType": {
                        Object object = XMLUtil.getTagValue((Element)element2);
                        if (object == null) continue block12;
                        Element element3 = XMLUtil.createXmlElement((String)"type", (String)object, (Document)document);
                        arrayList.add(element3);
                        continue block12;
                    }
                }
            }
            if (string != null) {
                Element element4 = this.createObjectElement(arrayList, document);
                linkedHashMap.put(string, element4);
                continue;
            }
            _logger.warn((Object)"Wrong formatted <relationSpec>...</relationSpec> has no relationId,  can't create relation view xml object elements");
        }
        return linkedHashMap;
    }

    private Element createObjectElement(List<Element> list, Document document) {
        Element element = XMLUtil.createXmlElement((String)"object", list, (Document)document);
        Element element2 = this.createContentSpec(document);
        element.appendChild(element2);
        return element;
    }

    private Element createMetadataElement(String string, Element element, Map<String, String> map, Document document) {
        Element element2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element3 = XMLUtil.createXmlElement((String)"objectType", (String)string, (Document)document);
        arrayList.add(element3);
        if (element != null) {
            element2 = this.createPropertyConditionsElement(element, document);
            arrayList.add(element2);
        }
        element2 = XMLUtil.createXmlElement((String)"metadata", arrayList, (Document)document);
        if (map != null) {
            this.addExtraMetadata(element2, map, document);
        }
        return element2;
    }

    private Element createPropertyConditionsElement(Element element, Document document) {
        Element element2 = document.createElement("nestedConstraints");
        element2.appendChild(element);
        Element element3 = document.createElement("com.vmware.data.query.CompositeConstraint");
        element3.appendChild(element2);
        Element element4 = document.createElement("propertyConditions");
        element4.appendChild(element3);
        return element4;
    }

    private Element createPropertyConstraintElement(String string, String string2, Document document) {
        Element element = XMLUtil.createXmlElement((String)"propertyName", (String)string, (Document)document);
        Element element2 = XMLUtil.createXmlElement((String)"comparator", (String)"EQUALS", (Document)document);
        Element element3 = document.createElement("comparableValue");
        Element element4 = XMLUtil.createXmlElement((String)"Boolean", (String)string2, (Document)document);
        element3.appendChild(element4);
        Element element5 = document.createElement("com.vmware.data.query.PropertyConstraint");
        element5.appendChild(element);
        element5.appendChild(element2);
        element5.appendChild(element3);
        return element5;
    }

    private void addExtraMetadata(Element element, Map<String, String> map, Document document) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element element2 = XMLUtil.createXmlElement((String)entry.getKey(), (String)entry.getValue(), (Document)document);
            element.appendChild(element2);
        }
    }

    private class RelationObjectInfo {
        private String _typeValue;
        private Element _propertyConstraintElem;
        private String _relationsViewId;
        private List<Element> _relationSpecs = new ArrayList<Element>();
        private Document _document;

        RelationObjectInfo(Node node, Document document) {
            this._document = document;
            this.init(node);
        }

        public String getTypeValue() {
            return this._typeValue;
        }

        public Element getPropertyConstraintElement() {
            return this._propertyConstraintElem;
        }

        public String getRelationsViewId() {
            return this._relationsViewId;
        }

        public List<Element> getRelationSpecs() {
            return this._relationSpecs;
        }

        private void init(Node node) {
            NodeList nodeList = node.getChildNodes();
            block12: for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element)) continue;
                Element element = (Element)node2;
                switch (element.getNodeName()) {
                    case "type": {
                        this._typeValue = XMLUtil.getTagValue((Element)element);
                        continue block12;
                    }
                    case "conditionalProperty": {
                        String string = XMLUtil.getTagValue((Element)element);
                        if (string != null) {
                            String string2 = "true";
                            if (string.charAt(0) == '!') {
                                string2 = "false";
                                string = string.substring(1);
                            }
                            this._propertyConstraintElem = RelationViewExtensionInfoCreator.this.createPropertyConstraintElement(string, string2, this._document);
                            continue block12;
                        }
                    }
                    case "relationsViewId": {
                        this._relationsViewId = XMLUtil.getTagValue((Element)element);
                        continue block12;
                    }
                    case "relationSpecs": {
                        this._relationSpecs.add(element);
                    }
                }
            }
        }
    }
}

