/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.signing;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vise.extensionfw.PluginSignatureService;
import com.vmware.vise.extensionfw.signing.PluginSignatureException;
import com.vmware.vise.extensionfw.signing.PluginSignatureGeneralException;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.VersionInterval;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.security.CertificateUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.CodeSigner;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Timestamp;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.naming.InvalidNameException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginSignatureServiceImpl
implements PluginSignatureService {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    public static final String SIGNATURE_VERSION_PROP = "signature-version";
    public static final String CERTIFIED_FOR_PROP = "certified-for";
    public static final String COMPATIBLE_WITH_PROP = "compatible-with";
    private static final int FILE_IO_BUFFER_SIZE = 4096;
    private static final String TRUSTED_CN = "VMware, Inc.";
    private static final String CLIENT_METADATA_FILE = "plugin-signature-metadata.properties";
    private static final String CACERTS_PASSWORD_PROP = "cacerts.truststore.password";
    private static final String CURRENT_SIGNATURE_VERSION = "2.0";
    private final String _expectedSignatureVersion;
    private final PKIXParameters _certPathValidatorParams;
    private final boolean _isH5Client;
    private final Version _clientVersion;

    public PluginSignatureServiceImpl(ConfigurationService configurationService) {
        this(PluginSignatureServiceImpl.getJavaTrustedCertificates(configurationService), CURRENT_SIGNATURE_VERSION);
    }

    public PluginSignatureServiceImpl(@Nullable Collection<? extends X509Certificate> collection, @Nonnull String string) {
        this._expectedSignatureVersion = string;
        this._isH5Client = BuildProperties.isH5Client();
        this._clientVersion = BuildProperties.getClientVersion();
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        if (collection != null && !collection.isEmpty()) {
            for (X509Certificate x509Certificate : collection) {
                TrustAnchor trustAnchor = new TrustAnchor(x509Certificate, null);
                hashSet.add(trustAnchor);
            }
        }
        Object object = null;
        try {
            object = new PKIXParameters(hashSet);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            _logger.error((Object)("Couldn't create the PKIX parameters with the passed trust anchors " + hashSet), (Throwable)invalidAlgorithmParameterException);
        }
        if (object != null) {
            ((PKIXParameters)object).setRevocationEnabled(false);
        }
        this._certPathValidatorParams = object;
    }

    @Override
    public void verifySignature(@Nonnull JarFile jarFile) throws PluginSignatureException, PluginSignatureGeneralException {
        if (this._certPathValidatorParams == null) {
            throw new PluginSignatureGeneralException("Detected an invalid set of trust anchors.");
        }
        try {
            Manifest manifest;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Validate.notNull((Object)jarFile);
            ZipEntry zipEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                throw new PluginSignatureException("No META-INF/MANIFEST.MF entry found in the plugin zip file.");
            }
            try {
                object4 = jarFile.getInputStream(zipEntry);
                object3 = null;
                try {
                    object2 = new BufferedInputStream((InputStream)object4);
                    object = null;
                    try {
                        manifest = new Manifest((InputStream)object2);
                        Map<String, Attributes> map = manifest.getEntries();
                        _logger.debug((Object)("Jar file entries: " + map));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object2 != null) {
                            if (object != null) {
                                try {
                                    ((BufferedInputStream)object2).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedInputStream)object2).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    if (object4 != null) {
                        if (object3 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object3).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object4).close();
                        }
                    }
                }
            }
            catch (SecurityException securityException) {
                throw new PluginSignatureException("The signature of the META-INF/MANIFEST.MF entry is corrupted.", securityException);
            }
            object4 = PluginSignatureServiceImpl.checkForUnsignedOrMissingEntries(jarFile, manifest);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = jarFile.getJarEntry((String)object2);
                this.verifyJarFileEntry(jarFile, (JarEntry)object);
            }
            this.verifyClientMetadata(jarFile);
        }
        catch (PluginSignatureException pluginSignatureException) {
            throw pluginSignatureException;
        }
        catch (Exception exception) {
            throw new PluginSignatureGeneralException("The signature verification process failed.", exception);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("The jar file " + jarFile.getName() + " was validated successfully"));
        }
    }

    private void verifyJarFileEntry(@Nonnull JarFile jarFile, @Nonnull JarEntry jarEntry) throws IOException, NoSuchAlgorithmException, PluginSignatureException, InvalidAlgorithmParameterException {
        Serializable serializable;
        CodeSigner[] codeSignerArray;
        try {
            codeSignerArray = jarFile.getInputStream(jarEntry);
            serializable = null;
            try {
                PluginSignatureServiceImpl.readFully((InputStream)codeSignerArray);
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (codeSignerArray != null) {
                    if (serializable != null) {
                        try {
                            codeSignerArray.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        codeSignerArray.close();
                    }
                }
            }
        }
        catch (SecurityException securityException) {
            throw new PluginSignatureException("The signature of jar entry " + jarEntry.getName() + " in jar file " + jarFile.getName() + " is corrupted.", securityException);
        }
        codeSignerArray = jarEntry.getCodeSigners();
        if (codeSignerArray.length != 1) {
            throw new PluginSignatureException("Expected one code signer, but found " + codeSignerArray.length);
        }
        serializable = codeSignerArray[0];
        CertPath certPath = ((CodeSigner)serializable).getSignerCertPath();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("-----------------------------------------------------------------------\nCERT PATH:\n-----------------------------------------------------------------------\n" + certPath));
        }
        this.verifyVmwareCommonName(certPath);
        Timestamp timestamp = ((CodeSigner)serializable).getTimestamp();
        if (timestamp == null) {
            throw new PluginSignatureException("Missing timestamp in jar entry " + jarEntry.getName() + " in file " + jarFile.getName(), PluginSignatureException.Reason.MISSING_TIMESTAMP);
        }
        _logger.debug((Object)("Timestamp: " + timestamp.getTimestamp()));
        CertPath certPath2 = timestamp.getSignerCertPath();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("-----------------------------------------------------------------------\nTimestamp CERT PATH:\n-----------------------------------------------------------------------\n" + certPath2));
        }
        Date date = timestamp.getTimestamp();
        PKIXParameters pKIXParameters = (PKIXParameters)this._certPathValidatorParams.clone();
        pKIXParameters.setDate(date);
        this.verifyCertPath(certPath2, pKIXParameters);
        _logger.debug((Object)"Timestamp verified successfully!");
        this.verifyCertPath(certPath, pKIXParameters);
    }

    private void verifyVmwareCommonName(CertPath certPath) throws PluginSignatureException {
        List list;
        List<? extends Certificate> list2 = certPath.getCertificates();
        if (list2.isEmpty()) {
            throw new PluginSignatureException("The certificate path of the code signer is empty.");
        }
        X509Certificate x509Certificate = (X509Certificate)list2.get(0);
        if (x509Certificate == null) {
            throw new PluginSignatureException("The VMware certificate should be an X509 certificate");
        }
        try {
            list = CertificateUtil.getCNs((X509Certificate)x509Certificate);
        }
        catch (InvalidNameException invalidNameException) {
            throw new PluginSignatureException("An error occurred when extracting the certificate common name.", invalidNameException);
        }
        for (String string : list) {
            if (!TRUSTED_CN.equals(string)) continue;
            return;
        }
        throw new PluginSignatureException("The certificate common names (CN) " + list + " do not contain the expected one.", PluginSignatureException.Reason.INCORRECT_CN);
    }

    private void verifyCertPath(CertPath certPath, PKIXParameters pKIXParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, PluginSignatureException {
        CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
        CertPathValidatorResult certPathValidatorResult = null;
        try {
            certPathValidatorResult = certPathValidator.validate(certPath, pKIXParameters);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (CertPathValidatorException.BasicReason.ALGORITHM_CONSTRAINED.equals(certPathValidatorException.getReason())) {
                _logger.debug((Object)"The zip was signed with a constrained algorithm", (Throwable)certPathValidatorException);
            }
            throw new PluginSignatureException("The certification path couldn't be verified", certPathValidatorException, PluginSignatureException.Reason.CERT_PATH_NOT_VERIFIED);
        }
        if (certPathValidatorResult instanceof PKIXCertPathValidatorResult) {
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidatorResult;
            TrustAnchor trustAnchor = pKIXCertPathValidatorResult.getTrustAnchor();
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("-----------------------------------------------------------------------\nTRUST ANCHOR:\n-----------------------------------------------------------------------\n" + x509Certificate));
            }
        }
    }

    private void verifyClientMetadata(JarFile jarFile) throws IOException, PluginSignatureException {
        ZipEntry zipEntry = jarFile.getEntry(CLIENT_METADATA_FILE);
        if (zipEntry == null) {
            throw new PluginSignatureException("No plugin-signature-metadata.properties file found in the zip.", PluginSignatureException.Reason.CLIENT_METADATA_NOT_VERIFIED);
        }
        try (InputStream inputStream = jarFile.getInputStream(zipEntry);){
            Properties properties = new Properties();
            properties.load(inputStream);
            this.verifySignatureVersion(properties);
            this.verifyClientCompatibility(properties);
        }
    }

    private void verifySignatureVersion(Properties properties) throws PluginSignatureException {
        String[] stringArray;
        String string = properties.getProperty(SIGNATURE_VERSION_PROP);
        if (string == null) {
            throw new PluginSignatureException("The \"signature-version\" metadata may not be null", PluginSignatureException.Reason.CLIENT_METADATA_NOT_VERIFIED);
        }
        for (String string2 : stringArray = string.split(",")) {
            if (!this._expectedSignatureVersion.equals(string2 = string2.trim())) continue;
            return;
        }
        throw new PluginSignatureException("The expected signature version " + this._expectedSignatureVersion + "is not among the versions the plugin was signed with: " + string, PluginSignatureException.Reason.CLIENT_METADATA_NOT_VERIFIED);
    }

    private void verifyClientCompatibility(Properties properties) throws PluginSignatureException {
        String[] stringArray;
        String string = properties.getProperty(CERTIFIED_FOR_PROP);
        if (string == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Couldn't find \"certified-for\" metadata. Falling back to the legacy \"compatible-with\" property");
            }
            if ((string = properties.getProperty(COMPATIBLE_WITH_PROP)) != null) {
                string = this.translateCompatibleWithToCertifiedFor(string);
            }
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new PluginSignatureException("The \"certified-for\" metadata may not be null or empty", PluginSignatureException.Reason.CLIENT_METADATA_NOT_VERIFIED);
        }
        for (String string2 : stringArray = string.split(";")) {
            VersionInterval versionInterval;
            String string3 = string2.trim();
            String[] stringArray2 = string3.split(":");
            if (stringArray2.length != 2) {
                _logger.warn((Object)("Detected an invalid client version in the \"certified-for\" metadata: " + string2));
                continue;
            }
            boolean bl = "html".equals(stringArray2[0]);
            boolean bl2 = "flex".equals(stringArray2[0]);
            if ((!this._isH5Client || !bl) && (this._isH5Client || !bl2) || !(versionInterval = new VersionInterval(stringArray2[1])).contains(this._clientVersion)) continue;
            return;
        }
        throw new PluginSignatureException("The plugin is not compatible with the client version. Plugin compatible versions are " + stringArray + " and the client version is " + (this._isH5Client ? "H5C " : "NGC ") + this._clientVersion, PluginSignatureException.Reason.CLIENT_METADATA_NOT_VERIFIED);
    }

    private String translateCompatibleWithToCertifiedFor(String string) {
        String[] stringArray = string.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) {
                _logger.warn((Object)("Detected an invalid client version in the \"compatible-with\" metadata: " + string2));
                continue;
            }
            stringBuilder.append(stringArray2[0]);
            stringBuilder.append(":");
            stringBuilder.append("[" + stringArray2[1] + ", ]");
            stringBuilder.append(";");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static Collection<? extends X509Certificate> getJavaTrustedCertificates(ConfigurationService configurationService) {
        KeyStore keyStore;
        String string;
        String string2 = System.getProperty("java.home");
        String string3 = string = configurationService == null ? null : configurationService.getProperty(CACERTS_PASSWORD_PROP);
        if (string == null) {
            string = "changeit";
        }
        try {
            keyStore = PluginSignatureServiceImpl.loadKeyStore(Paths.get(string2 + "/lib/security/cacerts", new String[0]), string.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            _logger.error((Object)"Couldn't load the java cacerts store", (Throwable)exception);
            return new HashSet();
        }
        return PluginSignatureServiceImpl.extractCertificatesFromKeystore(keyStore);
    }

    @VisibleForTesting
    static Set<X509Certificate> extractCertificatesFromKeystore(KeyStore keyStore) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        assert (keyStore != null);
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate certificate;
                String string = enumeration.nextElement();
                if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
                hashSet.add((X509Certificate)certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            _logger.error((Object)"Error while getting the aliases from the java keystore", (Throwable)keyStoreException);
        }
        return hashSet;
    }

    @Nonnull
    @VisibleForTesting
    static KeyStore loadKeyStore(@Nonnull Path path, @Nullable char[] cArray) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        Validate.notNull((Object)path);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            keyStore.load(bufferedInputStream, cArray);
        }
        return keyStore;
    }

    private static Set<String> checkForUnsignedOrMissingEntries(JarFile jarFile, Manifest manifest) throws PluginSignatureException {
        Object object;
        Cloneable cloneable;
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, Attributes> map = manifest.getEntries();
        for (Map.Entry<String, Attributes> object22 : map.entrySet()) {
            cloneable = object22.getKey();
            object = object22.getValue();
            for (Object object2 : ((Attributes)object).keySet()) {
                String string;
                if (!(object2 instanceof Attributes.Name) || !(string = ((Attributes.Name)object2).toString()).endsWith("-Digest")) continue;
                hashSet.add((String)((Object)cloneable));
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Signed entries: " + hashSet));
        }
        HashSet hashSet2 = new HashSet();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            cloneable = enumeration.nextElement();
            if (((ZipEntry)cloneable).isDirectory()) continue;
            object = ((ZipEntry)cloneable).getName();
            hashSet2.add(object);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("All entries: " + hashSet2));
        }
        cloneable = new HashSet(hashSet2);
        cloneable.removeAll(hashSet);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Unsigned entries: " + cloneable));
        }
        for (Object object3 : cloneable) {
            if (PluginSignatureServiceImpl.isAnEntryThatCanBeUnsigned((String)object3)) continue;
            throw new PluginSignatureException("Found an unsigned entry: " + (String)object3, PluginSignatureException.Reason.UNSIGNED_ENTRIES);
        }
        object = new HashSet(hashSet);
        object.removeAll(hashSet2);
        if (object.size() > 0) {
            throw new PluginSignatureException("Some entries which have a signature in the manifest file but are missing from the archive: " + object, PluginSignatureException.Reason.MISSING_ENTRIES);
        }
        return hashSet;
    }

    private static boolean isAnEntryThatCanBeUnsigned(String string) {
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") && !string.startsWith("/META-INF/")) {
            return false;
        }
        if ("META-INF/MANIFEST.MF".equals(string)) {
            return true;
        }
        return string.endsWith(".SF") || string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".EC");
    }

    private static void readFully(@Nonnull @WillClose InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4096];
        try {
            while (inputStream.read(byArray, 0, 4096) > 0) {
            }
        }
        finally {
            inputStream.close();
        }
    }
}

