/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.certificate;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.vmware.certificate.VMCAAdapter;
import com.vmware.certificate.VMCAException;
import com.vmware.certificate.VMCAServerContext;
import java.io.File;
import java.util.Date;

public final class VMCAAdapter2 {
    public static VMCAServerContext getServerContext(String pszNetworkAddress, String pszUserName, String pszDomain, String pszPassword) throws VMCAException {
        PointerByReference ppContext = new PointerByReference();
        int flags = 0;
        int error = VMCA.INSTANCE.VMCAOpenServerA(pszNetworkAddress, pszUserName, pszDomain, pszPassword, flags, Pointer.NULL, ppContext);
        VMCAAdapter2.THROW_IF_NEEDED(error);
        return new VMCAServerContext(pszNetworkAddress, ppContext.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServerVersion(VMCAServerContext context) throws VMCAException {
        Pointer pServerVersion = Pointer.NULL;
        PointerByReference ppServerVersion = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetServerVersionHA(context.getContext(), context.getNetworkAddress(), ppServerVersion);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pServerVersion = ppServerVersion.getValue();
            String string = pServerVersion.getString(0L);
            return string;
        }
        finally {
            if (pServerVersion != Pointer.NULL) {
                VMCA.INSTANCE.VMCAFreeVersion(pServerVersion);
            }
        }
    }

    public static void AddRootCertificate(VMCAServerContext context, String pszCertificate, String pszPrivateKey) throws VMCAException {
        String pszPassPhrase = null;
        int error = VMCA.INSTANCE.VMCAAddRootCertificateHA(context.getContext(), context.getNetworkAddress(), pszCertificate, pszPassPhrase, pszPrivateKey);
        VMCAAdapter2.THROW_IF_NEEDED(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetRootCertificate(VMCAServerContext context) throws VMCAException {
        Pointer pCertificate = Pointer.NULL;
        PointerByReference ppCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetRootCACertificateHA(context.getContext(), context.getNetworkAddress(), ppCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCertificate = ppCertificate.getValue();
            String string = pCertificate.getString(0L);
            return string;
        }
        finally {
            if (pCertificate != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
        }
    }

    public static void SetValue(int Oid, PointerByReference data, String Value) throws VMCAException {
        int error = VMCA.INSTANCE.VMCASetCertValueA(Oid, data.getPointer(), Value);
        VMCAAdapter2.THROW_IF_NEEDED(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetCSR(Pointer pData, String privateKey) throws VMCAException {
        Pointer pCSR = Pointer.NULL;
        PointerByReference ppCSR = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCACreateSigningRequestA(pData, privateKey, null, ppCSR);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCSR = ppCSR.getValue();
            String string = pCSR.getString(0L);
            return string;
        }
        finally {
            if (pCSR != Pointer.NULL) {
                VMCA.INSTANCE.VMCAFreeCSR(pCSR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetCertificate(VMCAServerContext context, Pointer data, String privateKey, Date notBefore, Date notAfter) throws VMCAException {
        Pointer pCertificate = Pointer.NULL;
        PointerByReference ppCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetSignedCertificateHA(context.getContext(), context.getNetworkAddress(), data, privateKey, null, notBefore.getTime(), notAfter.getTime(), ppCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCertificate = ppCertificate.getValue();
            String string = pCertificate.getString(0L);
            return string;
        }
        finally {
            if (pCertificate != Pointer.NULL) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetSelfSignedCertificate(Pointer data, String privateKey, Date notBefore, Date notAfter) throws VMCAException {
        Pointer pCertificate = Pointer.NULL;
        PointerByReference ppCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCACreateSelfSignedCertificateA(data, privateKey, null, notBefore.getTime(), notAfter.getTime(), ppCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCertificate = ppCertificate.getValue();
            String string = pCertificate.getString(0L);
            return string;
        }
        finally {
            if (pCertificate != Pointer.NULL) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
        }
    }

    public static void RevokeCertificate(VMCAServerContext context, String pszCertificate) throws VMCAException {
        int error = VMCA.INSTANCE.VMCARevokeCertificateHA(context.getContext(), context.getNetworkAddress(), pszCertificate);
        VMCAAdapter2.THROW_IF_NEEDED(error);
    }

    public static boolean IsCACert(String pszCertificate) {
        int error = VMCA.INSTANCE.VMCAValidateCACertificate(pszCertificate);
        return error == 0;
    }

    public static void FreeData(Pointer p) {
        if (p != Pointer.NULL) {
            VMCA.INSTANCE.VMCAFreePKCS10DataA(p);
        }
    }

    private static void THROW_IF_NEEDED(int error) throws VMCAException {
        String err = null;
        if (error != 0) {
            try {
                err = VMCAAdapter.VMCAGetShortError(error);
            }
            catch (VMCAException ex) {
                err = "Unable to get error string from VMCA, Please use error code";
            }
            VMCAException exp = new VMCAException(err);
            exp.setErrorCode(error);
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAJavaGenCert(VMCAServerContext context, String Name, String Country, String Locality, String State, String Organization, String OrgUnit, String DnsName, String URIName, String Email, String IPAddress, int KeyUsageConstraints, int isSelfSigned, String PrivateKey2, long tmNotBefore, long tmNotAfter) throws VMCAException {
        Pointer p = null;
        PointerByReference pCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAJavaGenCertHA(context.getContext(), context.getNetworkAddress(), Name, Country, Locality, State, Organization, OrgUnit, DnsName, URIName, Email, IPAddress, KeyUsageConstraints, isSelfSigned, PrivateKey2, tmNotBefore, tmNotAfter, pCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            p = pCertificate.getValue();
            if (p == null) {
                throw new IllegalStateException("Expected Certificate not Found");
            }
            String string = p.getString(0L);
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (p != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(p);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetSignedCertificateFromCSR(VMCAServerContext context, String pszCSR, long tmNotBefore, long tmNotAfter) throws VMCAException {
        Pointer pCertificate = null;
        PointerByReference ppCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetSignedCertificateFromCSRHA(context.getContext(), context.getNetworkAddress(), pszCSR, tmNotBefore, tmNotAfter, ppCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCertificate = ppCertificate.getValue();
            String string = pCertificate.getString(0L);
            if (pCertificate != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (pCertificate != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetSignedCertificateForHost(VMCAServerContext context, String pszHostName, String pszIpAddress, String pszCSR, long tmNotBefore, long tmNotAfter) throws VMCAException {
        Pointer pCertificate = null;
        PointerByReference ppCertificate = new PointerByReference();
        try {
            int error = VMCA.INSTANCE.VMCAGetSignedCertificateForHostA(context.getContext(), pszHostName, pszIpAddress, pszCSR, tmNotBefore, tmNotAfter, ppCertificate);
            VMCAAdapter2.THROW_IF_NEEDED(error);
            pCertificate = ppCertificate.getValue();
            String string = pCertificate.getString(0L);
            if (pCertificate != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (pCertificate != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCertificate);
            }
            throw throwable;
        }
    }

    public static Pointer VMCAOpenEnumContext(VMCAServerContext context, int certFilter) throws VMCAException {
        PointerByReference ppContext = new PointerByReference();
        int error = VMCA.INSTANCE.VMCAOpenEnumContextHA(context.getContext(), context.getNetworkAddress(), certFilter, ppContext);
        VMCAAdapter2.THROW_IF_NEEDED(error);
        Pointer pEnumContext = ppContext.getValue();
        return pEnumContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetNextCertificate(Pointer ctx) throws VMCAException {
        Pointer pCert;
        PointerByReference ppCertificate;
        IntByReference pEnumStatus;
        block9: {
            IntByReference pCurrentIndex = new IntByReference();
            pEnumStatus = new IntByReference();
            ppCertificate = new PointerByReference();
            pCert = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetNextCertificate(ctx, ppCertificate, pCurrentIndex, pEnumStatus);
                VMCAAdapter2.THROW_IF_NEEDED(error);
                if (pEnumStatus.getValue() == 2) {
                    throw new RuntimeException("Certificate Enum Returned - VMCA_ENUM_ERROR");
                }
                if (pEnumStatus.getValue() != 1) break block9;
                String string = null;
                if (pCert != null) {
                    VMCA.INSTANCE.VMCAFreeCertificate(pCert);
                }
                return string;
            }
            catch (Throwable throwable) {
                if (pCert != null) {
                    VMCA.INSTANCE.VMCAFreeCertificate(pCert);
                }
                throw throwable;
            }
        }
        if (pEnumStatus.getValue() == 0) {
            String pszCertificate;
            pCert = ppCertificate.getValue();
            String string = pszCertificate = pCert.getString(0L);
            if (pCert != null) {
                VMCA.INSTANCE.VMCAFreeCertificate(pCert);
            }
            return string;
        }
        if (pCert != null) {
            VMCA.INSTANCE.VMCAFreeCertificate(pCert);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetShortError(int dwError) throws VMCAException {
        String string;
        block5: {
            PointerByReference ppMsg = new PointerByReference();
            Pointer pMsg = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetShortError(dwError, ppMsg);
                if (error != 0) {
                    VMCAException exp = new VMCAException("Unable to get Error String from VMCA");
                    exp.setErrorCode(error);
                    throw exp;
                }
                pMsg = ppMsg.getValue();
                assert (pMsg != null);
                string = pMsg.getString(0L);
                if (pMsg == null) break block5;
                VMCA.INSTANCE.VMCAFreeVersion(pMsg);
            }
            catch (Throwable throwable) {
                if (pMsg != null) {
                    VMCA.INSTANCE.VMCAFreeVersion(pMsg);
                }
                throw throwable;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String VMCAGetErrorString(int dwError) throws VMCAException {
        String string;
        block5: {
            PointerByReference ppMsg = new PointerByReference();
            Pointer pMsg = null;
            try {
                int error = VMCA.INSTANCE.VMCAGetErrorString(dwError, ppMsg);
                if (error != 0) {
                    VMCAException exp = new VMCAException("Unable to get Error String from VMCA");
                    exp.setErrorCode(error);
                    throw exp;
                }
                pMsg = ppMsg.getValue();
                assert (pMsg != null);
                string = pMsg.getString(0L);
                if (pMsg == null) break block5;
                VMCA.INSTANCE.VMCAFreeVersion(pMsg);
            }
            catch (Throwable throwable) {
                if (pMsg != null) {
                    VMCA.INSTANCE.VMCAFreeVersion(pMsg);
                }
                throw throwable;
            }
        }
        return string;
    }

    public static void VMCACloseEnumContext(Pointer ctx) {
        if (ctx != Pointer.NULL) {
            VMCA.INSTANCE.VMCACloseEnumContext(ctx);
        }
    }

    public static String VMCAGetCRL(VMCAServerContext context, String existingCRL, String newCRL) throws VMCAException {
        int error = VMCA.INSTANCE.VMCAGetCRLHA(context.getContext(), context.getNetworkAddress(), existingCRL, newCRL);
        VMCAAdapter2.THROW_IF_NEEDED(error);
        return newCRL;
    }

    public static void VMCAPublishRoots(VMCAServerContext context) throws VMCAException {
        int error = VMCA.INSTANCE.VMCAPublishRootCertsHA(context.getContext(), context.getNetworkAddress());
        VMCAAdapter2.THROW_IF_NEEDED(error);
    }

    static {
        String InstallPath;
        String[] paths;
        String VMCA_LIB64_PATH = "/usr/lib/vmware-vmca/lib64";
        String LIKEWISE_LIB64_PATH = "/opt/likewise/lib64";
        String LIB_PATH = "/usr/lib";
        String LIB_PATH_64 = "/usr/lib64";
        String ENCODING = "utf8";
        String propName = "jna.library.path";
        System.setProperty("jna.encoding", "utf8");
        String propValue = System.getProperty("jna.library.path");
        StringBuilder jnalibpath = new StringBuilder(propValue == null ? "" : propValue);
        for (String path : paths = new String[]{"/usr/lib64", "/usr/lib", "/opt/likewise/lib64", "/usr/lib/vmware-vmca/lib64"}) {
            File libDir = new File(path);
            if (!libDir.exists() || !libDir.isDirectory()) continue;
            if (jnalibpath.length() > 0) {
                jnalibpath.append(":");
            }
            jnalibpath.append(path);
        }
        if (Platform.isWindows() && (InstallPath = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\VMware, Inc.\\VMware Certificate Services", (String)"InstallPath")).length() > 0) {
            jnalibpath.append(InstallPath);
        }
        if (!(propValue = jnalibpath.substring(0)).isEmpty()) {
            System.setProperty("jna.library.path", propValue);
        }
    }

    public static interface VMCA
    extends Library {
        public static final VMCA INSTANCE = (VMCA)Native.loadLibrary((String)"vmcaclient", VMCA.class);

        public int VMCAOpenServerA(String var1, String var2, String var3, String var4, int var5, Pointer var6, PointerByReference var7);

        public int VMCAGetServerVersionHA(Pointer var1, String var2, PointerByReference var3);

        public int VMCAFreeVersion(Pointer var1);

        public int VMCAGetRootCACertificateHA(Pointer var1, String var2, PointerByReference var3);

        public int VMCAAddRootCertificateHA(Pointer var1, String var2, String var3, String var4, String var5);

        public int VMCACreateSelfSignedCertificateA(Pointer var1, String var2, String var3, long var4, long var6, PointerByReference var8);

        public int VMCACreatePrivateKeyA(String var1, Integer var2, PointerByReference var3, PointerByReference var4);

        public int VMCAAllocatePKCS10DataA(PointerByReference var1);

        public int VMCAGetSignedCertificateHA(Pointer var1, String var2, Pointer var3, String var4, String var5, long var6, long var8, PointerByReference var10);

        public int VMCAGetSignedCertificateFromCSRHA(Pointer var1, String var2, String var3, long var4, long var6, PointerByReference var8);

        public int VMCAGetSignedCertificateForHostA(Pointer var1, String var2, String var3, String var4, long var5, long var7, PointerByReference var9);

        public int VMCARevokeCertificateHA(Pointer var1, String var2, String var3);

        public int VMCAGetCertificateCountHA(Pointer var1, String var2, int var3, IntByReference var4);

        public int VMCAOpenEnumContextHA(Pointer var1, String var2, int var3, PointerByReference var4);

        public int VMCAGetNextCertificate(Pointer var1, PointerByReference var2, IntByReference var3, IntByReference var4);

        public int VMCACloseEnumContext(Pointer var1);

        public int VMCAGetCRLHA(Pointer var1, String var2, String var3, String var4);

        public int VMCAReGenCRLHA(Pointer var1, String var2);

        public int VMCAPublishRootCertsHA(Pointer var1, String var2);

        public int VMCACloseServer(Pointer var1);

        public void VMCAFreeCertificate(Pointer var1);

        public void VMCAFreeKey(Pointer var1);

        public int VMCASetCertValueA(Integer var1, Pointer var2, String var3);

        public int VMCASetKeyUsageConstraintsA(Pointer var1, Integer var2);

        public int VMCAValidateCACertificate(String var1);

        public int VMCACreateSigningRequestA(Pointer var1, String var2, String var3, PointerByReference var4);

        public int VMCAFreeCSR(Pointer var1);

        public int VMCAFreePKCS10DataA(Pointer var1);

        public int VMCAJavaGenCertHA(Pointer var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, int var13, int var14, String var15, long var16, long var18, PointerByReference var20);

        public int VMCAGetShortError(int var1, PointerByReference var2);

        public int VMCAGetErrorString(int var1, PointerByReference var2);
    }

    public static interface VMCA_ENUM_RETURN_CODE {
        public static final int VMCA_ENUM_SUCCESS = 0;
        public static final int VMCA_ENUM_END = 1;
        public static final int VMCA_ENUM_ERROR = 2;
    }

    public static interface VMCA_OID {
        public static final int VMCA_OID_CN = 1;
        public static final int VMCA_OID_COUNTRY = 2;
        public static final int VMCA_OID_LOCALITY = 3;
        public static final int VMCA_OID_STATE = 4;
        public static final int VMCA_OID_ORGANIZATION = 5;
        public static final int VMCA_OID_ORG_UNIT = 6;
        public static final int VMCA_OID_DNS = 7;
        public static final int VMCA_OID_URI = 8;
        public static final int VMCA_OID_EMAIL = 9;
        public static final int VMCA_OID_IPADDRESS = 10;
    }
}

