/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.certificate;

import com.sun.jna.Pointer;
import com.vmware.certificate.Request;
import com.vmware.certificate.VMCAAdapter2;
import com.vmware.certificate.VMCAException;
import com.vmware.certificate.VMCAServerContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.codec.binary.Base64;

public class VMCAClient
implements Iterable<X509Certificate> {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERT = "\n-----END CERTIFICATE-----";
    private String _username;
    private String _domain;
    private String _password;
    private String _serverName;
    private certFilters enumFilter;

    public VMCAClient(String username, String domain, String password, String server_name) {
        this._username = username;
        this._domain = domain;
        this._password = password;
        this._serverName = server_name;
        this.setEnumFilter(certFilters.ACTIVE_CERTIFICATES);
    }

    public static X509Certificate getCertificateFromString(String certificateString) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(certificateString.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate c = (X509Certificate)cf.generateCertificate(is);
        return c;
    }

    private String getEncodedStringFromCertificate(X509Certificate certificate) throws Exception {
        if (certificate == null) {
            throw new IllegalStateException("Invalid Certificate, certificate cannot be null");
        }
        String encoded = new String(Base64.encodeBase64((byte[])certificate.getEncoded()));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return BEGIN_CERT + pemencode.toString() + END_CERT;
    }

    private String encodeX509CertificatesToString(X509Certificate[] certs) throws Exception {
        if (certs == null || certs.length == 0) {
            return null;
        }
        int stringBuilderSize = certs.length * 1024;
        StringBuilder sb = new StringBuilder(stringBuilderSize);
        for (X509Certificate cert : certs) {
            String pem = this.getEncodedStringFromCertificate(cert);
            sb.append(pem);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String encodePrivateKeyToString(PrivateKey key) throws UnsupportedEncodingException {
        if (key == null) {
            return null;
        }
        byte[] privBytes = key.getEncoded();
        String encoded = new String(Base64.encodeBase64((byte[])privBytes));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return "-----BEGIN PRIVATE KEY-----\n" + pemencode.toString() + "\n" + "-----END PRIVATE KEY-----";
    }

    public X509Certificate[] getRootCertificates() throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            X509Certificate[] x509CertificateArray = this.getRootCertificates(context);
            return x509CertificateArray;
        }
    }

    protected X509Certificate[] getRootCertificates(VMCAServerContext context) throws Exception {
        ArrayList<X509Certificate> trustedRoots = new ArrayList<X509Certificate>();
        trustedRoots.add(VMCAClient.getCertificateFromString(VMCAAdapter2.GetRootCertificate(context)));
        return trustedRoots.toArray(new X509Certificate[trustedRoots.size()]);
    }

    public void addRootCertificate(X509Certificate[] certificateChain, PrivateKey key) throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            VMCAAdapter2.AddRootCertificate(context, this.encodeX509CertificatesToString(certificateChain), this.encodePrivateKeyToString(key));
        }
    }

    public X509Certificate getRootCertificate() throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            X509Certificate x509Certificate = this.getRootCertificate(context);
            return x509Certificate;
        }
    }

    protected X509Certificate getRootCertificate(VMCAServerContext context) throws Exception {
        return VMCAClient.getCertificateFromString(VMCAAdapter2.GetRootCertificate(context));
    }

    public X509Certificate getCertificate(String certificateRequest, Date notBefore, Date notAfter) throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            X509Certificate x509Certificate = this.getCertificate(context, certificateRequest, notBefore, notAfter);
            return x509Certificate;
        }
    }

    protected X509Certificate getCertificate(VMCAServerContext context, String certificateRequest, Date notBefore, Date notAfter) throws Exception {
        long epochNotBefore = notBefore.getTime();
        long epochNotAfter = notAfter.getTime();
        return VMCAClient.getCertificateFromString(VMCAAdapter2.VMCAGetSignedCertificateFromCSR(context, certificateRequest, epochNotBefore /= 1000L, epochNotAfter /= 1000L));
    }

    public X509Certificate getCertificateForHost(String hostName, String ipAddress, String certificateRequest, Date notBefore, Date notAfter) throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            X509Certificate x509Certificate = this.getCertificateForHost(context, hostName, ipAddress, certificateRequest, notBefore, notAfter);
            return x509Certificate;
        }
    }

    protected X509Certificate getCertificateForHost(VMCAServerContext context, String hostName, String ipAddress, String certificateRequest, Date notBefore, Date notAfter) throws Exception {
        long epochNotBefore = notBefore.getTime();
        long epochNotAfter = notAfter.getTime();
        return VMCAClient.getCertificateFromString(VMCAAdapter2.VMCAGetSignedCertificateForHost(context, hostName, ipAddress, certificateRequest, epochNotBefore /= 1000L, epochNotAfter /= 1000L));
    }

    private String getPEMEncodedKey(KeyPair Keys) {
        byte[] privBytes = Keys.getPrivate().getEncoded();
        String encoded = new String(Base64.encodeBase64((byte[])privBytes));
        StringBuffer pemencode = new StringBuffer();
        for (int x = 0; x < encoded.length(); ++x) {
            if (x > 0 && x % 64 == 0) {
                pemencode.append("\n");
                pemencode.append(encoded.charAt(x));
                continue;
            }
            pemencode.append(encoded.charAt(x));
        }
        return "-----BEGIN PRIVATE KEY-----\n" + pemencode.toString() + "\n" + "-----END PRIVATE KEY-----";
    }

    public X509Certificate getCertificate(Request req, KeyPair Keys, Date notBefore, Date notAfter) throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            X509Certificate x509Certificate = this.getCertificate(context, req, Keys, notBefore, notAfter);
            return x509Certificate;
        }
    }

    protected X509Certificate getCertificate(VMCAServerContext context, Request req, KeyPair Keys, Date notBefore, Date notAfter) throws Exception {
        long epochNotBefore = notBefore.getTime();
        long epochNotAfter = notAfter.getTime();
        String certString = VMCAAdapter2.VMCAJavaGenCert(context, req.getName(), req.getCountry(), req.getLocality(), req.getState(), req.getOrganization(), req.getOrgunit(), req.getDnsname(), req.getUri(), req.getEmail(), req.getIpaddress(), req.getKeyusage(), 0, this.getPEMEncodedKey(Keys), epochNotBefore /= 1000L, epochNotAfter /= 1000L);
        return VMCAClient.getCertificateFromString(certString);
    }

    public void revokeCertificate(X509Certificate certificate) throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            this.revokeCertificate(context, certificate);
        }
    }

    protected void revokeCertificate(VMCAServerContext context, X509Certificate certificate) throws Exception {
        VMCAAdapter2.RevokeCertificate(context, this.getEncodedStringFromCertificate(certificate));
    }

    public String getServerVersion() throws Exception {
        try (VMCAServerContext context = this.getServerContext();){
            String string = this.getServerVersion(context);
            return string;
        }
    }

    protected String getServerVersion(VMCAServerContext context) throws Exception {
        return VMCAAdapter2.getServerVersion(context);
    }

    @Override
    public Iterator<X509Certificate> iterator() {
        try {
            VMCAServerContext context = this.getServerContext();
            return new VMCACertIterator(context, VMCAClient.filterToInteger(this.getEnumFilter()));
        }
        catch (VMCAException e) {
            throw new RuntimeException(e.getMessage() + " Error Code: [" + e.getErrorCode() + "]");
        }
    }

    public certFilters getEnumFilter() {
        return this.enumFilter;
    }

    public void setEnumFilter(certFilters enumFilter) {
        this.enumFilter = enumFilter;
    }

    private VMCAServerContext getServerContext() throws VMCAException {
        return VMCAAdapter2.getServerContext(this._serverName, this._username, this._domain, this._password);
    }

    private static int filterToInteger(certFilters filter) {
        switch (filter) {
            case ACTIVE_CERTIFICATES: {
                return 0;
            }
            case REVOKED_CERTIFICATES: {
                return 1;
            }
            case EXPIRED_CERTIFICATES: {
                return 2;
            }
            case ALL_CERTIFICATES: {
                return 4;
            }
        }
        return 0;
    }

    public void getCRL(String existingCRL, String value) throws VMCAException, IOException {
        try (VMCAServerContext context = this.getServerContext();){
            this.getCRL(context, existingCRL, value);
        }
    }

    protected void getCRL(VMCAServerContext context, String existingCRL, String value) throws VMCAException {
        String returnedCRL = VMCAAdapter2.VMCAGetCRL(context, existingCRL, value);
    }

    public void publishRoots() throws VMCAException, Exception {
        try (VMCAServerContext context = this.getServerContext();){
            this.publishRoots(context);
        }
    }

    protected void publishRoots(VMCAServerContext context) throws VMCAException, Exception {
        VMCAAdapter2.VMCAPublishRoots(context);
    }

    private class VMCACertIterator
    implements Iterator<X509Certificate>,
    AutoCloseable {
        private VMCAServerContext serverContext;
        private Pointer enumContext;
        private String nextCert;
        private int certFilter;

        public VMCACertIterator(VMCAServerContext context, int certFilter) throws VMCAException {
            this.certFilter = certFilter;
            this.serverContext = context;
            this.enumContext = VMCAAdapter2.VMCAOpenEnumContext(context, this.certFilter);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.enumContext != null) {
                    this.nextCert = VMCAAdapter2.VMCAGetNextCertificate(this.enumContext);
                    if (this.nextCert != null) {
                        return true;
                    }
                    this.close();
                }
            }
            catch (Exception e) {
                this.close();
            }
            return false;
        }

        @Override
        public X509Certificate next() {
            try {
                return VMCAClient.getCertificateFromString(this.nextCert);
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.getMessage());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("To Remove or Revoke a Certificate, Please use Revoke Certificate");
        }

        @Override
        public void close() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.dispose();
            }
            finally {
                super.finalize();
            }
        }

        public void dispose() {
            if (this.enumContext != null) {
                VMCAAdapter2.VMCACloseEnumContext(this.enumContext);
                this.enumContext = null;
            }
            if (this.serverContext != null) {
                this.serverContext.dispose();
                this.serverContext = null;
            }
        }
    }

    public static enum certFilters {
        ACTIVE_CERTIFICATES,
        REVOKED_CERTIFICATES,
        EXPIRED_CERTIFICATES,
        ALL_CERTIFICATES;

    }
}

