/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.cdc;

import com.vmware.identity.cdc.CdcAdapter;
import com.vmware.identity.cdc.CdcAddressType;
import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcDCEntryNative;
import com.vmware.identity.cdc.CdcGenericException;
import com.vmware.identity.cdc.CdcState;
import com.vmware.identity.cdc.IntRef;
import com.vmware.identity.cdc.PointerRef;
import java.util.ArrayList;
import java.util.List;

public class CdcSession
implements AutoCloseable {
    private PointerRef _serverHandle;
    private final String _userName;
    private final String _serverName;
    private static final String LOCALHOST = "__localhost__";
    private static final String LOCALUSER = "__localuser__";

    CdcSession(String serverName, String userName, String password) {
        PointerRef pServer = new PointerRef();
        int error = 0;
        this._serverName = serverName == null ? LOCALHOST : serverName;
        this._userName = userName == null ? LOCALUSER : userName;
        error = CdcAdapter.VmAfdOpenServerW(serverName, userName, password, pServer);
        if (error != 0) {
            throw new CdcGenericException(String.format("Error opening server '%s' for user '%s'", serverName, userName), error);
        }
        this._serverHandle = pServer;
    }

    private void closeSession() {
        if (this._serverHandle != null) {
            CdcAdapter.VmAfdCloseServer(this._serverHandle);
        }
        this._serverHandle = null;
    }

    public void enableClientAffinity() {
        int error = CdcAdapter.CdcEnableClientAffinity(this._serverHandle);
        CdcSession.BAIL_ON_ERROR(error, "Enabling client affinity failed. [Server: %s, User: %s]", this._serverName, this._userName);
    }

    public void disableClientAffinity() {
        int error = CdcAdapter.CdcDisableClientAffinity(this._serverHandle);
        CdcSession.BAIL_ON_ERROR(error, "Enabling client affinity failed. [Server: %s, User: %s]", this._serverName, this._userName);
    }

    public CdcDCEntry getAffinitizedDC(String domainName, int flags) {
        CdcDCEntry resultEntry = null;
        CdcDCEntryNative pEntry = new CdcDCEntryNative();
        int error = CdcAdapter.CdcGetDCNameW(this._serverHandle, domainName, flags, pEntry);
        if (error == 4312) {
            resultEntry = null;
        } else {
            CdcSession.BAIL_ON_ERROR(error, "Getting affinitized DC for domain %s failed. [Server: %s, User: %s]", domainName, this._serverName, this._userName);
            resultEntry = CdcSession.convertCdcDCEntryNativeToCdcDCEntry(pEntry);
        }
        return resultEntry;
    }

    public List<String> enumDCEntries() {
        ArrayList<String> dcEntryList = new ArrayList<String>();
        int error = CdcAdapter.CdcEnumDCEntriesW(this._serverHandle, dcEntryList);
        CdcSession.BAIL_ON_ERROR(error, "Enumerating DCs failed. [Server: %s, User: %s]", this._serverName, this._userName);
        return dcEntryList;
    }

    public CdcState getCdcState() {
        IntRef pState = new IntRef();
        int error = CdcAdapter.CdcGetCurrentState(this._serverHandle, pState);
        CdcSession.BAIL_ON_ERROR(error, "Getting CDC State failed. [Server: %s, User: %s]", this._serverName, this._userName);
        CdcState cdcState = CdcState.getState(pState.number);
        return cdcState;
    }

    @Override
    public void close() {
        this.closeSession();
    }

    private static CdcDCEntry convertCdcDCEntryNativeToCdcDCEntry(CdcDCEntryNative entryNative) {
        String dcName = entryNative.dcName;
        CdcAddressType type = CdcAddressType.getEntryType(entryNative.addressType);
        String dcAddress = entryNative.dcAddress;
        String dcSiteName = entryNative.dcSiteName;
        return new CdcDCEntry(type, dcName, dcAddress, dcSiteName);
    }

    private static void BAIL_ON_ERROR(int error, String format, Object ... vargs) {
        switch (error) {
            case 0: {
                break;
            }
            default: {
                throw new CdcGenericException(String.format(format, vargs), error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.closeSession();
        }
        finally {
            super.finalize();
        }
    }
}

