/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.util;

import com.vmware.cis.SessionDefinitions;
import com.vmware.cis.TasksDefinitions;
import com.vmware.cis.task.StructDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> mapping) {
        Validate.notNull(mapping);
        StructTypeUtil.add(mapping, "com.vmware.cis.session.info", SessionDefinitions.info);
        StructTypeUtil.add(mapping, "com.vmware.cis.tasks.get_spec", TasksDefinitions.getSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.tasks.filter_spec", TasksDefinitions.filterSpec);
        StructTypeUtil.add(mapping, "com.vmware.cis.task.progress", StructDefinitions.progress);
        StructTypeUtil.add(mapping, "com.vmware.cis.task.common_info", StructDefinitions.commonInfo);
        StructTypeUtil.add(mapping, "com.vmware.cis.task.info", StructDefinitions.info);
    }

    private static void add(Map<String, StructType> mapping, String key, StructType structType) {
        if (mapping.containsKey(key)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + key + ". Unable to populate the map.");
        }
        mapping.put(key, structType);
    }
}

