/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis;

import com.vmware.cis.TasksDefinitions;
import com.vmware.cis.TasksSyncProvider;
import com.vmware.cis.TasksTypes;
import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class TasksSyncApiInterface
extends ApiInterfaceSkeleton {
    private TasksSyncProvider impl;

    public TasksSyncApiInterface() {
        this((Class<? extends TasksSyncProvider>)null);
    }

    public TasksSyncApiInterface(Class<? extends TasksSyncProvider> implClass) {
        this((TasksSyncProvider)TasksSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.cis.impl.TasksImpl", TasksSyncProvider.class));
    }

    public TasksSyncApiInterface(TasksSyncProvider impl) {
        super("com.vmware.cis.tasks");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new CancelApiMethod());
    }

    private class CancelApiMethod
    extends ApiMethodSkeleton {
        public CancelApiMethod() {
            super(TasksSyncApiInterface.this.getIdentifier(), "cancel", TasksDefinitions.__cancelInput, TasksDefinitions.__cancelOutput, TasksSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.error;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notAllowedInCurrentState;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unsupported;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__cancelInput, TasksSyncApiInterface.this.getTypeConverter());
            String task = (String)extr.valueForField("task");
            try {
                TasksSyncApiInterface.this.impl.cancel(task, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(TasksSyncApiInterface.this.getIdentifier(), "list", TasksDefinitions.__listInput, TasksDefinitions.__listOutput, TasksSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__listInput, TasksSyncApiInterface.this.getTypeConverter());
            TasksTypes.FilterSpec filterSpec = (TasksTypes.FilterSpec)extr.valueForField("filter_spec");
            TasksTypes.GetSpec resultSpec = (TasksTypes.GetSpec)extr.valueForField("result_spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TasksSyncApiInterface.this.getTypeConverter().convertToVapi(TasksSyncApiInterface.this.impl.list(filterSpec, resultSpec, invocationContext), TasksDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(TasksSyncApiInterface.this.getIdentifier(), "get", TasksDefinitions.__getInput, TasksDefinitions.__getOutput, TasksSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.error;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.resourceInaccessible;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.serviceUnavailable;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthenticated;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.unauthorized;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, TasksDefinitions.__getInput, TasksSyncApiInterface.this.getTypeConverter());
            String task = (String)extr.valueForField("task");
            TasksTypes.GetSpec spec = (TasksTypes.GetSpec)extr.valueForField("spec");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)TasksSyncApiInterface.this.getTypeConverter().convertToVapi((Object)TasksSyncApiInterface.this.impl.get(task, spec, invocationContext), TasksDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

