/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.admin.interposer.impl;

import com.vmware.vapi.admin.impl.InterposerImpl;
import com.vmware.vapi.admin.interposer.impl.Utils;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;
import java.util.Iterator;
import java.util.List;

public final class PostInterposerHandler
extends DecoratorAsyncHandle<MethodResult> {
    private final Iterator<InterposerImpl.InterposerDefinition> iter;
    private MethodResult invocationResult;
    private RuntimeException invocationError;
    private final ExecutionContext context;
    private final DataValue input;
    private final MethodIdentifier interposedMethod;
    private AsyncHandle<MethodResult> originalCallback;

    public PostInterposerHandler(List<InterposerImpl.InterposerDefinition> interposers, MethodIdentifier method, ExecutionContext context, DataValue input, AsyncHandle<MethodResult> callBack) {
        super(callBack);
        this.interposedMethod = method;
        this.context = context;
        this.input = input;
        this.originalCallback = callBack;
        this.iter = interposers.iterator();
    }

    private void executeOnCallback(Iterator<InterposerImpl.InterposerDefinition> iter) {
        if (iter.hasNext()) {
            this.executeNextInterposer(iter);
        } else if (this.invocationError != null) {
            this.originalCallback.setError(this.invocationError);
        } else {
            this.originalCallback.setResult((Object)this.invocationResult);
        }
    }

    void executeNextInterposer(final Iterator<InterposerImpl.InterposerDefinition> iter) {
        if (iter.hasNext()) {
            InterposerImpl.InterposerDefinition def = iter.next();
            MethodDefinition md = def.getMethodDefinition();
            ApiProvider provider = def.getProvider();
            AsyncHandle<MethodResult> handle = new AsyncHandle<MethodResult>(){

                public void setResult(MethodResult result) {
                    PostInterposerHandler.this.executeOnCallback(iter);
                }

                public void setError(RuntimeException error) {
                    PostInterposerHandler.this.executeOnCallback(iter);
                }

                public void updateProgress(DataValue progress) {
                }
            };
            provider.invoke(md.getIdentifier().getInterfaceIdentifier().getName(), md.getIdentifier().getName(), Utils.getInterposerInput(this.interposedMethod, md, this.input), this.context, (AsyncHandle)handle);
        }
    }

    public void setResult(MethodResult result) {
        this.invocationResult = result;
        if (this.iter.hasNext()) {
            this.execute();
        } else {
            this.originalCallback.setResult((Object)this.invocationResult);
        }
    }

    public void setError(RuntimeException error) {
        this.invocationError = error;
        if (this.iter.hasNext()) {
            this.execute();
        } else {
            this.originalCallback.setError(this.invocationError);
        }
    }

    public void execute() {
        this.executeNextInterposer(this.iter);
    }
}

