/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class CompositeOperation {
    private final Object lock = new Object();
    private final int operationCount;
    private final CompletionCallback completionCallback;
    private final OperationOutcome[] outcomes;
    private final List<AsyncHandle<MethodResult>> callbacks;
    private int received;

    public CompositeOperation(int operationCount, CompletionCallback completionCallback) {
        Validate.isTrue((operationCount >= 0 ? 1 : 0) != 0);
        Validate.notNull((Object)completionCallback);
        this.operationCount = operationCount;
        this.completionCallback = completionCallback;
        this.outcomes = new OperationOutcome[operationCount];
        this.callbacks = new ArrayList<AsyncHandle<MethodResult>>(operationCount);
        for (int i = 0; i < operationCount; ++i) {
            this.callbacks.add(new OperationHandle(i));
        }
        if (operationCount == 0) {
            completionCallback.onComplete(this.outcomes);
        }
    }

    public List<AsyncHandle<MethodResult>> getCallbacks() {
        return Collections.unmodifiableList(this.callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOperationComplete(int operationIndex, OperationOutcome outcome) {
        Object object = this.lock;
        synchronized (object) {
            if (this.received >= this.operationCount) {
                return;
            }
            this.outcomes[operationIndex] = outcome;
            ++this.received;
            if (this.received >= this.operationCount) {
                this.completionCallback.onComplete(this.outcomes);
            }
        }
    }

    private class OperationHandle
    extends AsyncHandle<MethodResult> {
        private final int operationIndex;

        public OperationHandle(int operationIndex) {
            this.operationIndex = operationIndex;
        }

        public void updateProgress(DataValue progress) {
        }

        public void setResult(MethodResult result) {
            CompositeOperation.this.onOperationComplete(this.operationIndex, new OperationOutcome(result));
        }

        public void setError(RuntimeException error) {
            CompositeOperation.this.onOperationComplete(this.operationIndex, new OperationOutcome(error));
        }
    }

    public static interface CompletionCallback {
        public void onComplete(OperationOutcome[] var1);
    }

    public static final class OperationOutcome {
        private final MethodResult result;
        private final RuntimeException error;

        OperationOutcome(MethodResult result) {
            Validate.notNull((Object)result);
            this.result = result;
            this.error = null;
        }

        OperationOutcome(RuntimeException error) {
            Validate.notNull((Object)error);
            this.result = null;
            this.error = error;
        }

        public MethodResult getResult() {
            return this.result;
        }

        public RuntimeException getError() {
            return this.error;
        }
    }
}

