/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.interposition.builder;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.interposition.Interposition;
import com.vmware.vapi.interposition.InterpositionConfig;
import com.vmware.vapi.interposition.InterpositionConfigFactory;
import com.vmware.vapi.interposition.InterpositionConfigImpl;
import com.vmware.vapi.interposition.OperationInvocationInfo;
import com.vmware.vapi.interposition.PostInterposerConfig;
import com.vmware.vapi.interposition.PostInterposerConfigImpl;
import com.vmware.vapi.interposition.VetoInterposerConfig;
import com.vmware.vapi.interposition.VetoInterposerConfigImpl;
import com.vmware.vapi.interposition.builder.InterposerSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class InterpositionBuilder {
    private final ApiProvider decoratedProvider;
    private List<InterposerSpec> vetoInterposers;
    private List<InterposerSpec> postInterposers;

    public InterpositionBuilder(ApiProvider decoratedProvider) {
        Validate.notNull((Object)decoratedProvider);
        this.decoratedProvider = decoratedProvider;
        this.vetoInterposers = Collections.emptyList();
        this.postInterposers = Collections.emptyList();
    }

    public InterpositionBuilder setVetoInterposers(List<InterposerSpec> interposers) {
        Validate.noNullElements(interposers);
        this.vetoInterposers = Collections.unmodifiableList(new ArrayList<InterposerSpec>(interposers));
        return this;
    }

    public InterpositionBuilder setPostInterposers(List<InterposerSpec> interposers) {
        Validate.noNullElements(interposers);
        this.postInterposers = Collections.unmodifiableList(new ArrayList<InterposerSpec>(interposers));
        return this;
    }

    public Interposition build() {
        return new Interposition(this.decoratedProvider, new SpecBasedInterpositionConfigFactory(this.vetoInterposers, this.postInterposers, this.decoratedProvider), null);
    }

    private static class SpecBasedInterpositionConfigFactory
    implements InterpositionConfigFactory {
        private final List<InterposerSpec> vetoInterposers;
        private final List<InterposerSpec> postInterposers;
        private final ApiProvider provider;

        public SpecBasedInterpositionConfigFactory(List<InterposerSpec> vetoInterposers, List<InterposerSpec> postInterposers, ApiProvider provider) {
            Validate.notNull(vetoInterposers);
            Validate.notNull(postInterposers);
            Validate.notNull((Object)provider);
            this.vetoInterposers = vetoInterposers;
            this.postInterposers = postInterposers;
            this.provider = provider;
        }

        private VetoInterposerConfig toVeto(InterposerSpec spec, OperationInvocationInfo operationInfo) {
            return new VetoInterposerConfigImpl(spec.getServiceId(), spec.getOperationId(), operationInfo.getExecutionContext(), this.provider, 0L, true);
        }

        private List<VetoInterposerConfig> getMatchingVetoInterposers(List<InterposerSpec> specs, OperationInvocationInfo operationInfo) {
            ArrayList<VetoInterposerConfig> configs = new ArrayList<VetoInterposerConfig>();
            String operation = operationInfo.getOperationQualifiedId();
            for (InterposerSpec spec : specs) {
                if (!spec.matchesOperation(operation)) continue;
                configs.add(this.toVeto(spec, operationInfo));
            }
            return configs;
        }

        private PostInterposerConfig toPost(InterposerSpec spec, OperationInvocationInfo operationInfo) {
            return new PostInterposerConfigImpl(spec.getServiceId(), spec.getOperationId(), operationInfo.getExecutionContext(), this.provider);
        }

        private List<PostInterposerConfig> getMatchingPostInterposers(List<InterposerSpec> specs, OperationInvocationInfo operationInfo) {
            ArrayList<PostInterposerConfig> configs = new ArrayList<PostInterposerConfig>();
            String operation = operationInfo.getOperationQualifiedId();
            for (InterposerSpec spec : specs) {
                if (!spec.matchesOperation(operation)) continue;
                configs.add(this.toPost(spec, operationInfo));
            }
            return configs;
        }

        @Override
        public InterpositionConfig getInterpositionConfig(OperationInvocationInfo operationInfo) {
            return new InterpositionConfigImpl(this.getMatchingVetoInterposers(this.vetoInterposers, operationInfo), this.getMatchingPostInterposers(this.postInterposers, operationInfo));
        }
    }
}

