/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.cli;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.cli.CommandDefinitions;
import com.vmware.vapi.metadata.cli.CommandSyncProvider;
import com.vmware.vapi.metadata.cli.CommandTypes;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class CommandSyncApiInterface
extends ApiInterfaceSkeleton {
    private CommandSyncProvider impl;

    public CommandSyncApiInterface() {
        this((Class<? extends CommandSyncProvider>)null);
    }

    public CommandSyncApiInterface(Class<? extends CommandSyncProvider> implClass) {
        this((CommandSyncProvider)CommandSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.cli.impl.CommandImpl", CommandSyncProvider.class));
    }

    public CommandSyncApiInterface(CommandSyncProvider impl) {
        super("com.vmware.vapi.metadata.cli.command");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new FingerprintApiMethod());
    }

    private class FingerprintApiMethod
    extends ApiMethodSkeleton {
        public FingerprintApiMethod() {
            super(CommandSyncApiInterface.this.getIdentifier(), "fingerprint", CommandDefinitions.__fingerprintInput, CommandDefinitions.__fingerprintOutput, CommandSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CommandSyncApiInterface.this.getTypeConverter().convertToVapi((Object)CommandSyncApiInterface.this.impl.fingerprint(invocationContext), CommandDefinitions.__fingerprintOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(CommandSyncApiInterface.this.getIdentifier(), "get", CommandDefinitions.__getInput, CommandDefinitions.__getOutput, CommandSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, CommandDefinitions.__getInput, CommandSyncApiInterface.this.getTypeConverter());
            CommandTypes.Identity identity = (CommandTypes.Identity)extr.valueForField("identity");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CommandSyncApiInterface.this.getTypeConverter().convertToVapi((Object)CommandSyncApiInterface.this.impl.get(identity, invocationContext), CommandDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(CommandSyncApiInterface.this.getIdentifier(), "list", CommandDefinitions.__listInput, CommandDefinitions.__listOutput, CommandSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, CommandDefinitions.__listInput, CommandSyncApiInterface.this.getTypeConverter());
            String path = (String)extr.valueForField("path");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)CommandSyncApiInterface.this.getTypeConverter().convertToVapi(CommandSyncApiInterface.this.impl.list(path, invocationContext), CommandDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

