/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.metadata.metamodel;

import com.vmware.vapi.bindings.server.InvocationContext;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton;
import com.vmware.vapi.internal.bindings.ApiMethodSkeleton;
import com.vmware.vapi.internal.bindings.StructValueExtractor;
import com.vmware.vapi.metadata.metamodel.SourceDefinitions;
import com.vmware.vapi.metadata.metamodel.SourceSyncProvider;
import com.vmware.vapi.metadata.metamodel.SourceTypes;
import com.vmware.vapi.provider.ApiMethod;
import com.vmware.vapi.std.errors.StructDefinitions;
import java.util.Arrays;
import org.apache.commons.lang.Validate;

public class SourceSyncApiInterface
extends ApiInterfaceSkeleton {
    private SourceSyncProvider impl;

    public SourceSyncApiInterface() {
        this((Class<? extends SourceSyncProvider>)null);
    }

    public SourceSyncApiInterface(Class<? extends SourceSyncProvider> implClass) {
        this((SourceSyncProvider)SourceSyncApiInterface.createImplInstance(implClass, (String)"com.vmware.vapi.metadata.metamodel.impl.SourceImpl", SourceSyncProvider.class));
    }

    public SourceSyncApiInterface(SourceSyncProvider impl) {
        super("com.vmware.vapi.metadata.metamodel.source");
        Validate.notNull((Object)impl);
        this.impl = impl;
        this.registerMethod((ApiMethod)new CreateApiMethod());
        this.registerMethod((ApiMethod)new DeleteApiMethod());
        this.registerMethod((ApiMethod)new GetApiMethod());
        this.registerMethod((ApiMethod)new ListApiMethod());
        this.registerMethod((ApiMethod)new ReloadApiMethod());
        this.registerMethod((ApiMethod)new FingerprintApiMethod());
    }

    private class FingerprintApiMethod
    extends ApiMethodSkeleton {
        public FingerprintApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "fingerprint", SourceDefinitions.__fingerprintInput, SourceDefinitions.__fingerprintOutput, SourceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__fingerprintInput, SourceSyncApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SourceSyncApiInterface.this.getTypeConverter().convertToVapi((Object)SourceSyncApiInterface.this.impl.fingerprint(sourceId, invocationContext), SourceDefinitions.__fingerprintOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ReloadApiMethod
    extends ApiMethodSkeleton {
        public ReloadApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "reload", SourceDefinitions.__reloadInput, SourceDefinitions.__reloadOutput, SourceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__reloadInput, SourceSyncApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            try {
                SourceSyncApiInterface.this.impl.reload(sourceId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class ListApiMethod
    extends ApiMethodSkeleton {
        public ListApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "list", SourceDefinitions.__listInput, SourceDefinitions.__listOutput, SourceSyncApiInterface.this.getTypeConverter(), null, MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SourceSyncApiInterface.this.getTypeConverter().convertToVapi(SourceSyncApiInterface.this.impl.list(invocationContext), SourceDefinitions.__listOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class GetApiMethod
    extends ApiMethodSkeleton {
        public GetApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "get", SourceDefinitions.__getInput, SourceDefinitions.__getOutput, SourceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__getInput, SourceSyncApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            try {
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)SourceSyncApiInterface.this.getTypeConverter().convertToVapi((Object)SourceSyncApiInterface.this.impl.get(sourceId, invocationContext), SourceDefinitions.__getOutput)));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class DeleteApiMethod
    extends ApiMethodSkeleton {
        public DeleteApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "delete", SourceDefinitions.__deleteInput, SourceDefinitions.__deleteOutput, SourceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__deleteInput, SourceSyncApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            try {
                SourceSyncApiInterface.this.impl.delete(sourceId, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }

    private class CreateApiMethod
    extends ApiMethodSkeleton {
        public CreateApiMethod() {
            super(SourceSyncApiInterface.this.getIdentifier(), "create", SourceDefinitions.__createInput, SourceDefinitions.__createOutput, SourceSyncApiInterface.this.getTypeConverter(), Arrays.asList(new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.alreadyExists;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.invalidArgument;
                }
            }, new TypeReference<StructType>(){

                public StructType resolve() {
                    return StructDefinitions.notFound;
                }
            }), MethodDefinition.TaskSupport.NONE);
        }

        public void doInvoke(InvocationContext invocationContext, StructValue inStruct, AsyncHandle<MethodResult> asyncHandle) {
            StructValueExtractor extr = new StructValueExtractor(inStruct, SourceDefinitions.__createInput, SourceSyncApiInterface.this.getTypeConverter());
            String sourceId = (String)extr.valueForField("source_id");
            SourceTypes.CreateSpec spec = (SourceTypes.CreateSpec)extr.valueForField("spec");
            try {
                SourceSyncApiInterface.this.impl.create(sourceId, spec, invocationContext);
                asyncHandle.setResult((Object)MethodResult.newResult((DataValue)VoidValue.getInstance()));
            }
            catch (RuntimeException ex) {
                asyncHandle.setResult((Object)MethodResult.newErrorResult((ErrorValue)this.toErrorValue(ex)));
            }
        }
    }
}

