/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.HandlerMappingIntrospectorFactoryBean;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public enum MatcherType {
    ant(AntPathRequestMatcher.class),
    regex(RegexRequestMatcher.class),
    ciRegex(RegexRequestMatcher.class),
    mvc(MvcRequestMatcher.class);

    private static final String HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final String HANDLER_MAPPING_INTROSPECTOR_FACTORY_BEAN_NAME = "org.springframework.security.config.http.HandlerMappingIntrospectorFactoryBean";
    private static final String ATT_MATCHER_TYPE = "request-matcher";
    final Class<? extends RequestMatcher> type;

    private MatcherType(Class<? extends RequestMatcher> type) {
        this.type = type;
    }

    public BeanDefinition createMatcher(ParserContext pc, String path, String method) {
        if (("/**".equals(path) || "**".equals(path)) && method == null) {
            return new RootBeanDefinition(AnyRequestMatcher.class);
        }
        BeanDefinitionBuilder matcherBldr = BeanDefinitionBuilder.rootBeanDefinition(this.type);
        if (this == mvc) {
            if (!pc.getRegistry().isBeanNameInUse(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME)) {
                BeanDefinitionBuilder hmifb = BeanDefinitionBuilder.rootBeanDefinition(HandlerMappingIntrospectorFactoryBean.class);
                pc.getRegistry().registerBeanDefinition(HANDLER_MAPPING_INTROSPECTOR_FACTORY_BEAN_NAME, (BeanDefinition)hmifb.getBeanDefinition());
                RootBeanDefinition hmi = new RootBeanDefinition(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME);
                hmi.setFactoryBeanName(HANDLER_MAPPING_INTROSPECTOR_FACTORY_BEAN_NAME);
                hmi.setFactoryMethodName("createHandlerMappingIntrospector");
                pc.getRegistry().registerBeanDefinition(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME, (BeanDefinition)hmi);
            }
            matcherBldr.addConstructorArgReference(HANDLER_MAPPING_INTROSPECTOR_BEAN_NAME);
        }
        matcherBldr.addConstructorArgValue((Object)path);
        if (this == mvc) {
            matcherBldr.addPropertyValue("method", (Object)method);
        } else {
            matcherBldr.addConstructorArgValue((Object)method);
        }
        if (this == ciRegex) {
            matcherBldr.addConstructorArgValue((Object)true);
        }
        return matcherBldr.getBeanDefinition();
    }

    static MatcherType fromElement(Element elt) {
        if (StringUtils.hasText((String)elt.getAttribute(ATT_MATCHER_TYPE))) {
            return MatcherType.valueOf(elt.getAttribute(ATT_MATCHER_TYPE));
        }
        return ant;
    }
}

