/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServerInfo;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AdminServiceBase {
    private static final String SSO_ADMIN_SERVICE_KEY = "ssoAdminService";
    private static final String SSO_SOLUTION_USER_ADMIN_SERVICE_KEY = "ssoSolutionUserAdminService";
    private static final String SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY = "ssoAdminServiceSyncObject";
    private SsoService _ssoService;
    private SsoServiceManager _ssoServiceManager;
    private SsoServerInfo _ssoServerInfo;
    private Boolean _useSolutionUser = false;
    private SsoAdminService _presetAdminService = null;
    private BackendExceptionTransformer _exceptionTransformer;

    public AdminServiceBase(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        Validate.notNull((Object)ssoServiceManager, (String)"ssoService is null");
        Validate.notNull((Object)ssoServiceManager, (String)"ssoServiceManager is null");
        Validate.notNull((Object)backendExceptionTransformer, (String)"transformer is null");
        this._ssoService = ssoService;
        this._ssoServiceManager = ssoServiceManager;
        this._exceptionTransformer = backendExceptionTransformer;
    }

    public AdminServiceBase(SsoAdminService ssoAdminService) {
        this._presetAdminService = ssoAdminService;
    }

    public AdminServiceBase(SsoService ssoService, SsoServiceManager ssoServiceManager, Boolean bl, BackendExceptionTransformer backendExceptionTransformer) {
        this(ssoService, ssoServiceManager, backendExceptionTransformer);
        this._useSolutionUser = bl;
    }

    protected Exception transformBackendException(Exception exception) {
        return this._exceptionTransformer.transformException(exception);
    }

    protected SsoServerInfo getSsoServerInfo() throws SsoServiceException {
        if (this._ssoServerInfo == null) {
            try {
                this._ssoServerInfo = this._ssoService.getServerInfo();
            }
            catch (Exception exception) {
                throw new SsoServiceException((Throwable)exception);
            }
        }
        return this._ssoServerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SsoAdminService getAdminService(HttpSession httpSession) throws SsoServiceException {
        Object object;
        if (this._presetAdminService != null) {
            return this._presetAdminService;
        }
        if (httpSession == null) {
            throw new IllegalArgumentException("session");
        }
        Object object2 = object = SessionUtil.getSyncObject((String)SSO_ADMIN_SERVICE_SYNC_OBJECT_KEY, (HttpSession)httpSession);
        synchronized (object2) {
            String string = this.getSessionKey();
            SsoAdminService ssoAdminService = (SsoAdminService)SessionUtil.getData((String)string);
            if (ssoAdminService == null) {
                ssoAdminService = this._useSolutionUser != false ? this._ssoServiceManager.getSolutionAdminService(null) : this._ssoServiceManager.getAdminService(null);
            }
            return ssoAdminService;
        }
    }

    protected String getSessionKey() {
        return this._useSolutionUser != false ? SSO_SOLUTION_USER_ADMIN_SERVICE_KEY : SSO_ADMIN_SERVICE_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void releaseResources(HttpSession httpSession) throws SsoServiceException {
        if (httpSession == null) {
            throw new IllegalArgumentException("session");
        }
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            for (String string : new String[]{SSO_ADMIN_SERVICE_KEY, SSO_SOLUTION_USER_ADMIN_SERVICE_KEY}) {
                SsoAdminService ssoAdminService = (SsoAdminService)SessionUtil.getData((String)string);
                if (ssoAdminService == null) continue;
                ssoAdminService.logout();
                SessionUtil.removeData((String)string, (HttpSession)httpSession);
            }
        }
    }
}

