/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.IdentityProviderService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.ExportIdentityProviderSpec;
import com.vmware.vsphere.client.sso.admin.model.ImportIdentityProviderSpec;
import javax.servlet.http.HttpSession;

public class IdentityProviderServiceImpl
extends AdminServiceBase
implements IdentityProviderService {
    public IdentityProviderServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public void importIdentityProviderConfiguration(ImportIdentityProviderSpec importIdentityProviderSpec) throws SsoServiceException {
        this.validateIdentityProviderSpec(importIdentityProviderSpec);
        ConfigurationManagementService configurationManagementService = this.getConfigService();
        configurationManagementService.importSAMLMetadata(importIdentityProviderSpec.xmlConfiguration);
    }

    @Override
    public ExportIdentityProviderSpec exportIdentityProviderConfiguration(ExportIdentityProviderSpec exportIdentityProviderSpec) throws SsoServiceException {
        this.validateExportIdentityProviderSpec(exportIdentityProviderSpec);
        ExportIdentityProviderSpec exportIdentityProviderSpec2 = new ExportIdentityProviderSpec();
        exportIdentityProviderSpec2.idpName = exportIdentityProviderSpec.idpName;
        exportIdentityProviderSpec2.metadataUrl = this.getMetadataUrl(exportIdentityProviderSpec.idpName);
        return exportIdentityProviderSpec2;
    }

    private String getMetadataUrl(String string) throws SsoServiceException {
        return this.getSsoServerInfo().getMetadataUrl();
    }

    private void validateIdentityProviderSpec(ImportIdentityProviderSpec importIdentityProviderSpec) throws IllegalArgumentException {
        if (importIdentityProviderSpec == null) {
            throw new IllegalArgumentException("The spec should not be null");
        }
        if (StringUtil.isNullOrEmpty((String)importIdentityProviderSpec.xmlConfiguration)) {
            throw new IllegalArgumentException("The provided xml should not be empty");
        }
    }

    private void validateExportIdentityProviderSpec(ExportIdentityProviderSpec exportIdentityProviderSpec) throws IllegalArgumentException {
        if (exportIdentityProviderSpec == null) {
            throw new IllegalArgumentException("The spec should not be null");
        }
    }

    private final ConfigurationManagementService getConfigService() throws SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        ConfigurationManagementService configurationManagementService = this.getAdminService(httpSession).getConfigurationManagementService();
        return configurationManagementService;
    }
}

